/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.common.core.CoreUtils;
import com.ti.common.core.FileUtil;
import com.ti.gui.composer.webserver.adapter.internal.IServerFileOperations;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class ServerFileOperations
implements IServerFileOperations {
    static int STORAGE_TYPE_COUNT = 2;
    static long QUOTA_CHECK_INTERVAL = 5000L;
    static long[] quota = new long[]{0x3200000L, 0xA00000L};
    static long[] currentSize = new long[]{-1L, -1L};
    static final int PREFIX_LENGTH = 15;
    static final String ZEROS = "000000000000000";
    static String rooFolder;
    static String[] folders;
    static String[] folderNames;
    static String[] envVarNames;
    static long lastSizeCheck;

    static {
        folders = new String[STORAGE_TYPE_COUNT];
        folderNames = new String[]{"temporary_files", "persistent_files"};
        envVarNames = new String[]{"serverTemporaryStorage", "serverPermanentStorage"};
        lastSizeCheck = System.currentTimeMillis();
        ServerFileOperations.setPaths();
        ServerFileOperations.readSystemProps();
    }

    ServerFileOperations() {
    }

    public String uploadFile(InputStream inputStream, String fileName, int storageType, String[] error) {
        if (storageType >= STORAGE_TYPE_COUNT) {
            return null;
        }
        if (folders[storageType] == null) {
            return null;
        }
        if (inputStream == null) {
            return null;
        }
        String generatedName = this.generateRandonNonExistent(fileName, storageType);
        String fullPath = this.getFullPath(generatedName, storageType);
        OutputStream outStream = null;
        try {
            try {
                byte[] bucket = new byte[32768];
                outStream = new BufferedOutputStream(new FileOutputStream(fullPath));
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = inputStream.read(bucket);
                    if (bytesRead <= 0) continue;
                    outStream.write(bucket, 0, bytesRead);
                }
            }
            finally {
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
        catch (FileNotFoundException ex) {
            error[0] = ex.getLocalizedMessage();
            return null;
        }
        catch (IOException ex) {
            error[0] = ex.getLocalizedMessage();
            return null;
        }
        return generatedName;
    }

    String generateRandonNonExistent(String fileName, int storageType) {
        String fullPath;
        boolean fileExist = false;
        String generatedName = null;
        while (fileExist = new File(fullPath = this.getFullPath(generatedName = this.generateRandom(fileName), storageType)).isFile()) {
        }
        return generatedName;
    }

    private String getFullPath(String name, int storageType) {
        return new Path(this.getFolder(storageType)).append(name).toOSString();
    }

    private String generateRandom(String fileName) {
        int num = new Random().nextInt();
        if (num < 0) {
            num = -num;
        }
        String s1 = String.valueOf(new Integer(num).toString()) + "_";
        String s2 = ZEROS.substring(s1.length());
        String s3 = fileName != null ? fileName : ".dat";
        return String.valueOf(s2) + s1 + s3;
    }

    public String getRootFolder() {
        return rooFolder;
    }

    static void setPaths() {
        IPath root = CoreUtils.instance().getSharedTemporaryFileDir().append(".WebServer").append("remote_files");
        rooFolder = root.toOSString();
        int i = 0;
        while (i < STORAGE_TYPE_COUNT) {
            IPath temp = root.append(folderNames[i]);
            if (!temp.toFile().exists() && !temp.toFile().mkdirs()) {
                return;
            }
            ServerFileOperations.folders[i] = temp.toString();
            ++i;
        }
    }

    static void readSystemProps() {
        int i = 0;
        while (i < STORAGE_TYPE_COUNT) {
            String s = System.getProperty(envVarNames[i]);
            if (folders[i] != null && s != null) {
                if ("clear".equals(s)) {
                    File f = new File(folders[i]);
                    FileUtil.delete((File)f);
                    f = new File(folders[i]);
                    f.mkdirs();
                } else {
                    try {
                        long l = Long.parseLong(s);
                        ServerFileOperations.quota[i] = l * 1024L * 1024L;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            ++i;
        }
    }

    String getFolder(int storageType) {
        if (storageType >= STORAGE_TYPE_COUNT) {
            return null;
        }
        return folders[storageType];
    }

    public boolean ensureQuota(int storageType, long bytesRequested) {
        if (storageType >= STORAGE_TYPE_COUNT) {
            return true;
        }
        String fname = this.getFolder(storageType);
        if (fname == null) {
            return true;
        }
        File f = new File(fname);
        long now = System.currentTimeMillis();
        if (currentSize[storageType] == -1L) {
            ServerFileOperations.currentSize[storageType] = ServerFileOperations.folderSize(f);
            lastSizeCheck = now;
        } else if (now - lastSizeCheck > QUOTA_CHECK_INTERVAL) {
            lastSizeCheck = now;
            ServerFileOperations.currentSize[storageType] = ServerFileOperations.folderSize(f);
        }
        return currentSize[storageType] + bytesRequested < quota[storageType];
    }

    public static long folderSize(File directory) {
        long length = 0L;
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            length = file.isFile() ? (length += file.length()) : (length += ServerFileOperations.folderSize(file));
            ++n2;
        }
        return length;
    }
}

