/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBackplane;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindAction;
import com.ti.backplane.bind.IBindFactory;
import com.ti.backplane.bind.IBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.Backplane;
import com.ti.backplane.internal.bind.DefaultBinder;
import com.ti.backplane.internal.bind.FinishedCallback;
import com.ti.backplane.internal.bind.IBackplaneFileOperations;
import com.ti.backplane.internal.bind.IFileLocationResolver;
import com.ti.backplane.internal.bind.OutStreamValue;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.model.BackplaneModel;
import com.ti.gui.composer.common.internal.BackplaneFileOperations;
import com.ti.gui.composer.common.internal.ErrorReporter;
import com.ti.gui.composer.common.internal.PropBindFactory;
import com.ti.gui.composer.common.internal.RegistryBasedDataModelContribution;
import com.ti.gui.composer.common.internal.ServerFileOperations;
import com.ti.gui.composer.common.internal.WebWidgetErrorBind;
import com.ti.gui.composer.common.internal.WebWidgetValueBind;
import com.ti.gui.composer.common.internal.WebWidgetsBindFactory;
import com.ti.gui.composer.common.internal.WebWidgetsInitData;
import com.ti.gui.composer.webserver.adapter.internal.IBindingInfo;
import com.ti.gui.composer.webserver.adapter.internal.IBindingRegistry;
import com.ti.gui.composer.webserver.adapter.internal.IClientInfo;
import com.ti.gui.composer.webserver.adapter.internal.IClientInfoProvider;
import com.ti.gui.composer.webserver.adapter.internal.IClientListener;
import com.ti.gui.composer.webserver.adapter.internal.IGroupChangeListener;
import com.ti.gui.composer.webserver.adapter.internal.IServerFileOperations;
import com.ti.gui.composer.webserver.adapter.internal.IServerListener;
import com.ti.gui.composer.webserver.adapter.internal.IWidgetValueChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class WebBindingRegistry
implements IBindingRegistry {
    static final String WIDGET_MODEL = "widget";
    static final String PROP_MODEL = "prop";
    static final String WIDGET_PREFIX = "widget.";
    static final String BACKPLANE_MODEL = "backplane";
    static final String CRITICAL_ERROR_PRPERTY_ID = "value:backplane.$last_critical_error";
    static final String CRITICAL_ERROR_WIDGET_ID = "backplane";
    static final String CRITICAL_ERROR_MODEL_URI = "value:backplane.$last_critical_error";
    static final String[] ALWAYS_MODEL_ENABLED_PROPS = new String[]{"disabled", "visible", "Disabled", "Visible"};
    long fNextSessionId = 0L;
    HashMap<String, WebClientData> fBackplanes = new HashMap();
    ServerFileOperations serverFileOperations = new ServerFileOperations();

    public synchronized String getUniqueSessionId() {
        String ret = new String(new Long(this.fNextSessionId).toString());
        ++this.fNextSessionId;
        return ret;
    }

    public IServerListener createSession(String sessionId, IClientListener clientListener) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data != null) {
            ErrorReporter.report("WebBindingRegistry.createSession(" + sessionId + "). Session already exists.");
            return data.getServerLisnter();
        }
        data = new WebClientData(sessionId, clientListener);
        this.fBackplanes.put(sessionId, data);
        return data.getServerLisnter();
    }

    public synchronized IServerListener createSession(String sessionId, ArrayList<IBindingInfo> bindingInfoList, IClientListener clientListener) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data != null) {
            ErrorReporter.report("WebBindingRegistry.createSession(" + sessionId + "). Session already exists.");
            return data.getServerLisnter();
        }
        data = new WebClientData(sessionId, clientListener);
        this.fBackplanes.put(sessionId, data);
        data.add(bindingInfoList);
        return data.getServerLisnter();
    }

    public synchronized void addBindings(String sessionId, ArrayList<IBindingInfo> bindingInfoList) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data == null) {
            ErrorReporter.report("WebBindingRegistry.addBindings(" + sessionId + "). Session id does not exist.");
            return;
        }
        data.add(bindingInfoList);
    }

    public synchronized void enableBindings(String sessionId, boolean enable, ArrayList<IBindingInfo> bindingInfoList) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data == null) {
            ErrorReporter.report("WebBindingRegistry.enableBindings(" + sessionId + "). Session id does not exist.");
            return;
        }
        data.enableBindings(enable, bindingInfoList);
    }

    public synchronized void removeBindings(String sessionId, ArrayList<IBindingInfo> bindingInfoList) {
        ErrorReporter.report("WebBindingRegistry.removeBindings() not impelemented.");
    }

    public synchronized void removeSession(String sessionId) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data == null) {
            ErrorReporter.report("WebBindingRegistry.removeSession(" + sessionId + "). Session id does not exist.");
            return;
        }
        data.dispose();
        this.fBackplanes.remove(sessionId);
    }

    public synchronized void setInitInfo(String sessionId, Map<String, Object> initInfo) {
        WebClientData data = this.fBackplanes.get(sessionId);
        if (data == null) {
            ErrorReporter.report("WebBindingRegistry.setInitInfo(" + sessionId + "). Session id does not exist.");
            return;
        }
        data.setInitInfo(initInfo);
    }

    static boolean valuesEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return o1 == null;
        }
        return o1.equals(o2);
    }

    static String getWidgetURI(String widgetId, String propertyName) {
        if (widgetId == null) {
            return null;
        }
        if (widgetId.equals(PROP_MODEL)) {
            return String.valueOf(widgetId) + '.' + propertyName;
        }
        String widgetURI = WIDGET_PREFIX + widgetId;
        if (propertyName != null && propertyName.length() > 0) {
            widgetURI = String.valueOf(widgetURI) + '.' + propertyName;
        }
        return widgetURI;
    }

    static String getWidgetURI(IBindingInfo info) {
        return WebBindingRegistry.getWidgetURI(info.getWidgetId(), info.getPropertyName());
    }

    public IServerFileOperations getServerFileOperations() {
        return this.serverFileOperations;
    }

    public static class Testing {
        static IBackplane mruBackplane = null;
        static WebWidgetsBindFactory mruWidgetFactory = null;

        public static void setValue(String uri, Object value) {
            Testing.setValues(new String[]{uri}, new Object[]{value});
        }

        public static void setValues(final String[] uris, final Object[] values) {
            mruBackplane.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < uris.length) {
                        ((IBindValue)mruBackplane.getBinding(uris[i])).setValue(values[i], null);
                        ++i;
                    }
                }
            });
        }

        static void setMRUBackplane(IBackplane backplane) {
            mruBackplane = backplane;
        }

        public static boolean bindExistsOnBackplane(String name) {
            if (mruWidgetFactory == null) {
                return false;
            }
            if (!name.startsWith(WebBindingRegistry.WIDGET_MODEL) && !name.startsWith(WebBindingRegistry.PROP_MODEL)) {
                return true;
            }
            IBind[] iBindArray = mruWidgetFactory.getBindings();
            int n = iBindArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBind b = iBindArray[n2];
                if (name.equals(b.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        static void setMRUWebWidgetFactory(WebWidgetsBindFactory factory) {
            mruWidgetFactory = factory;
        }
    }

    class WebClientData {
        String fSessionId;
        Backplane backplane;
        DefaultBinder binder;
        IFileLocationResolver fileLocationResolver;
        BackplaneFileOperations backplaneFileOperations;
        BackplaneModel backplaneModel;
        ArrayList<IBindValue> dataBind = new ArrayList();
        ArrayList<IBindValue> widgetsBind = new ArrayList();
        WebWidgetsBindFactory webWidgetsModel;
        PropBindFactory propsBind;
        IServerListener fServerListener;
        IClientListener fClientListener;
        ClentFilteredListener fClientFilteredListener;
        HashMap<String, Object> fServerViewOfValues = new HashMap();
        Map<String, Object> initInfo = null;

        WebClientData(String sessionId, IClientListener clientListener) {
            this.fSessionId = sessionId;
            this.fClientListener = clientListener;
            this.fServerListener = new ServerListener();
            this.fClientFilteredListener = new ClentFilteredListener();
            this.backplane = new Backplane();
            Testing.setMRUBackplane((IBackplane)this.backplane);
            this.fileLocationResolver = new FileLocationResolver();
            this.backplane.setFileLocationResolver(this.fileLocationResolver);
            IClientInfo clientInfo = null;
            if (clientListener instanceof IClientInfoProvider) {
                clientInfo = ((IClientInfoProvider)clientListener).getClientInfo();
            }
            this.backplaneFileOperations = new BackplaneFileOperations(WebBindingRegistry.this.serverFileOperations, clientInfo);
            this.backplane.setFileOperationsProvider((IBackplaneFileOperations)this.backplaneFileOperations);
            this.binder = new DefaultBinder();
            this.backplaneModel = new BackplaneModel();
            this.backplane.addModel("backplane", (IBindFactory)this.backplaneModel);
            this.webWidgetsModel = new WebWidgetsBindFactory();
            this.webWidgetsModel.setClientListener(this.fClientListener);
            Testing.setMRUWebWidgetFactory(this.webWidgetsModel);
            this.backplane.addModel(WebBindingRegistry.WIDGET_MODEL, (IBindFactory)this.webWidgetsModel);
            this.propsBind = new PropBindFactory("prop.", (IBindProvider)this.webWidgetsModel);
            this.backplane.addModel(WebBindingRegistry.PROP_MODEL, (IBindFactory)this.propsBind);
            RegistryBasedDataModelContribution.addDataModelsFromRegistry(this.backplane);
            this.createDefaultErrorBind();
        }

        void createDefaultErrorBind() {
            final IBindValue modelBind = (IBindValue)this.backplane.getBinding("value:backplane.$last_critical_error");
            String widgetURI = WebBindingRegistry.getWidgetURI("backplane", null);
            final WebWidgetErrorBind widgetBind = (WebWidgetErrorBind)this.backplane.getBinding(widgetURI);
            widgetBind.setWidgetInfo("backplane", "value:backplane.$last_critical_error", this.fClientFilteredListener);
            this.backplane.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebClientData.this.binder != null) {
                        WebClientData.this.binder.bind((IBindValue)widgetBind, modelBind, true, true);
                    }
                }
            });
        }

        void add(ArrayList<IBindingInfo> bindingInfoList) {
            final ArrayList<IBindingInfo> copied = new ArrayList<IBindingInfo>();
            copied.addAll(bindingInfoList);
            this.backplane.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebClientData.this.backplane != null) {
                        WebClientData.this.addOnRealm(copied);
                    }
                }
            });
        }

        /*
         * Could not resolve type clashes
         */
        void addOnRealm(ArrayList<IBindingInfo> bindingInfoList) {
            boolean hasDisabledBinds = false;
            for (IBindingInfo info : bindingInfoList) {
                Map attributes;
                Object disabledObject;
                String modelUri = info.getServerBindName();
                String widgetURI = WebBindingRegistry.getWidgetURI(info);
                IBind modelBindBase = null;
                if (modelUri != null) {
                    modelBindBase = this.backplane.getBinding(modelUri);
                }
                Map options = info.getOptions();
                WebWidgetsInitData initData = new WebWidgetsInitData(widgetURI, options, info.getWidgetId());
                Object defaultValue = initData.getDefaultValue();
                Class<?> dataType = initData.getType();
                boolean modelDisabled = false;
                if (options != null && (disabledObject = options.get("disabled")) instanceof Boolean) {
                    modelDisabled = (Boolean)disabledObject;
                }
                if (modelDisabled) {
                    String[] stringArray = ALWAYS_MODEL_ENABLED_PROPS;
                    int n = ALWAYS_MODEL_ENABLED_PROPS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        if (p.equals(info.getPropertyName())) {
                            modelDisabled = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (modelBindBase instanceof IBindValue && info.getWidgetId() == null) {
                    Object newDefaultValue = defaultValue;
                    if (options.get("dataType") != null) {
                        IStatus[] status = new IStatus[1];
                        Class<Object> clazz = defaultValue != null ? defaultValue.getClass() : (dataType != null ? dataType : String.class);
                        Object v = new DataConverter().convert(clazz, dataType, defaultValue, null, status);
                        if (status[0] == null) {
                            newDefaultValue = v;
                        }
                    }
                    ((IBindValue)modelBindBase).setValue(newDefaultValue, null);
                    continue;
                }
                if (this.webWidgetsModel.completesConnectRequest(initData)) continue;
                this.webWidgetsModel.setNextInitData(initData);
                IBind widgetBind = this.backplane.getBinding(widgetURI);
                this.webWidgetsModel.setNextToDefault();
                if (widgetBind instanceof WebWidgetValueBind) {
                    WebWidgetValueBind wb = (WebWidgetValueBind)widgetBind;
                    wb.setWidgetInfo(info.getWidgetId(), info.getPropertyName(), this.fClientFilteredListener);
                    if (modelDisabled) {
                        wb.setUpdateEnabled(false);
                        hasDisabledBinds = true;
                    }
                }
                if (modelBindBase == null) continue;
                if (modelBindBase instanceof IBindValue && widgetBind instanceof IBindValue) {
                    final boolean modelToTarget = defaultValue == null;
                    final boolean initiallyEnabled = !modelDisabled;
                    final IBindValue finalModelBindValue = (IBindValue)modelBindBase;
                    final IBindValue finalWidgetBindValue = (IBindValue)widgetBind;
                    this.backplane.getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (WebClientData.this.binder != null) {
                                WebClientData.this.binder.bind(finalWidgetBindValue, finalModelBindValue, modelToTarget, initiallyEnabled);
                            }
                        }
                    });
                }
                if ((attributes = info.getOptions()) == null) continue;
                for (Map.Entry entry : attributes.entrySet()) {
                    IBindValue widgetAttrBind;
                    String attributeName = (String)entry.getKey();
                    Object attributeValue = entry.getValue();
                    boolean createOptionBinding = true;
                    String[] stringArray = WebWidgetsInitData.OPTIONS_WITH_NO_BINDINGS;
                    int n = WebWidgetsInitData.OPTIONS_WITH_NO_BINDINGS.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String opt = stringArray[n3];
                        if (opt.equals(attributeName)) {
                            createOptionBinding = false;
                        }
                        ++n3;
                    }
                    if (!createOptionBinding) continue;
                    String modelArrtUri = String.valueOf(modelUri) + ".$" + attributeName;
                    IBind objModelAttrUri = this.backplane.getBinding(modelArrtUri);
                    final IBindValue modelAttrBind = objModelAttrUri instanceof IBindValue ? (IBindValue)objModelAttrUri : null;
                    String widgetArrtUri = widgetBind + ".$" + attributeName;
                    IBind objWidgetAttrUri = this.backplane.getBinding(widgetArrtUri);
                    IBindValue iBindValue = widgetAttrBind = objWidgetAttrUri instanceof IBindValue ? (IBindValue)objWidgetAttrUri : null;
                    if (attributeValue != null && widgetAttrBind != null) {
                        this.setWidgetValue(widgetAttrBind, info.getWidgetId(), info.getPropertyName(), attributeName, attributeValue);
                    }
                    if (widgetAttrBind instanceof WebWidgetValueBind) {
                        ((WebWidgetValueBind)widgetAttrBind).setClientListener(this.fClientFilteredListener);
                    }
                    if (modelAttrBind == null || widgetAttrBind == null) continue;
                    this.backplane.getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (WebClientData.this.binder != null) {
                                WebClientData.this.binder.bind(widgetAttrBind, modelAttrBind, false, true);
                            }
                        }
                    });
                }
            }
            if (hasDisabledBinds) {
                this.backplane.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (WebClientData.this.binder != null) {
                            WebClientData.this.binder.synchEnabledState();
                        }
                    }
                });
            }
        }

        void enableBindings(final boolean enable, final ArrayList<IBindingInfo> bindingInfoList) {
            this.backplane.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WebClientData.this.enableOnRealm(enable, bindingInfoList);
                }
            });
        }

        void setInitInfo(Map<String, Object> initInfo) {
            this.initInfo = initInfo;
            Object href = initInfo.get("href");
            if (href instanceof String && this.backplane != null) {
                this.backplane.setURL((String)href);
            }
        }

        void enableOnRealm(boolean enable, ArrayList<IBindingInfo> bindingInfoList) {
            boolean changed = false;
            ArrayList<IBind> bindsToChange = new ArrayList<IBind>();
            for (IBindingInfo info : bindingInfoList) {
                if (info.getPropertyName() != null) {
                    String uri = WebBindingRegistry.getWidgetURI(info);
                    IBind bind = this.backplane.getBinding(uri);
                    if (bind != null) {
                        bindsToChange.add(bind);
                    }
                } else {
                    ArrayList<IBind> binds = this.webWidgetsModel.getBindsForWidgetExcept(info.getWidgetId(), ALWAYS_MODEL_ENABLED_PROPS);
                    bindsToChange.addAll(binds);
                }
                for (IBind widgetBind : bindsToChange) {
                    Object o;
                    WebWidgetValueBind wb;
                    if (!(widgetBind instanceof WebWidgetValueBind) || (wb = (WebWidgetValueBind)widgetBind).getUpdateEnabled() == enable) continue;
                    changed = true;
                    if (info.getOptions() != null && (o = info.getOptions().get("syncValue")) instanceof Boolean) {
                        wb.updateValueOnEnable((Boolean)o);
                    }
                    wb.setUpdateEnabled(enable);
                }
            }
            if (changed) {
                this.binder.synchEnabledState();
            }
        }

        String getSessionId() {
            return this.fSessionId;
        }

        void dispose() {
            this.backplane.dispose();
            this.backplane = null;
            this.binder.unbindAll();
            this.binder = null;
        }

        IServerListener getServerLisnter() {
            return this.fServerListener;
        }

        void setWidgetValue(IBindValue bind, String widgetId, String propId, String attrId, Object newValue) {
            String keyName = String.valueOf(widgetId) + "." + propId;
            if (attrId != null) {
                keyName = String.valueOf(keyName) + "." + attrId;
            }
            if (bind.getValue() instanceof OutStreamValue) {
                OutStreamValue sv = (OutStreamValue)bind.getValue();
                sv.addRecord(newValue, (IFinished)new FinishedCallback());
            } else {
                this.fServerViewOfValues.put(keyName, newValue);
                bind.setValue(newValue, (IFinished)new FinishedCallback());
            }
        }

        class ClentFilteredListener
        implements IClientListener {
            ArrayList<Change> groupChanges = new ArrayList();
            ArrayList<GroupWidget> groupWidgets = new ArrayList();
            boolean groupUpdatePosted = false;

            ClentFilteredListener() {
            }

            Change getChange(String widgetId, String propertyId) {
                for (Change c : this.groupChanges) {
                    if (!c.getWidgetId().equals(widgetId) || !c.getPropertyId().equals(propertyId)) continue;
                    return c;
                }
                return null;
            }

            GroupWidget getGroupWidget(String widgetId, String propertyId) {
                for (GroupWidget w : this.groupWidgets) {
                    if (!w.widgetId.equals(widgetId) || !w.propertyId.equals(propertyId)) continue;
                    return w;
                }
                return null;
            }

            public void addToGroup(String groupId, long groupOrder, String widgetId, String propertyId) {
                if (this.getGroupWidget(widgetId, propertyId) == null) {
                    this.groupWidgets.add(new GroupWidget(groupId, groupOrder, widgetId, propertyId));
                }
            }

            void handleGroupUpdates() {
                while (this.groupChanges.size() > 0) {
                    Change change = this.groupChanges.get(0);
                    ArrayList<Change> currentGroup = new ArrayList<Change>();
                    ArrayList<Change> remaining = new ArrayList<Change>();
                    for (Change c : this.groupChanges) {
                        if (c.gw.groupId.equals(change.gw.groupId)) {
                            currentGroup.add(c);
                            continue;
                        }
                        remaining.add(c);
                    }
                    this.groupChanges = remaining;
                    Object[] arrayRet = currentGroup.toArray(new Change[0]);
                    Arrays.sort(arrayRet);
                    ((IGroupChangeListener)WebClientData.this.fClientListener).onMultipleValuesChanged((IWidgetValueChange[])arrayRet);
                }
                this.groupUpdatePosted = false;
            }

            void postGroupValueChange(String widgetId, String propertyName, Object value) {
                GroupWidget gw = this.getGroupWidget(widgetId, propertyName);
                if (gw == null) {
                    return;
                }
                Change change = this.getChange(widgetId, propertyName);
                if (change != null) {
                    change.setValue(value);
                } else {
                    change = new Change(gw, value);
                    this.groupChanges.add(change);
                }
                if (!this.groupUpdatePosted) {
                    this.groupUpdatePosted = true;
                    WebClientData.this.backplane.getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ClentFilteredListener.this.handleGroupUpdates();
                        }
                    });
                }
            }

            public void onValueChanged(String widgetId, String propertyName, Object newValue) {
                String keyName = String.valueOf(widgetId) + "." + propertyName;
                boolean widgetInSet = WebClientData.this.fServerViewOfValues.containsKey(keyName);
                Object cachedValue = WebClientData.this.fServerViewOfValues.remove(keyName);
                if (!widgetInSet || !this.valuesEqual(cachedValue, newValue)) {
                    if (this.getGroupWidget(widgetId, propertyName) != null) {
                        this.postGroupValueChange(widgetId, propertyName, newValue);
                    } else {
                        WebClientData.this.fClientListener.onValueChanged(widgetId, propertyName, newValue);
                    }
                }
            }

            boolean valuesEqual(Object o1, Object o2) {
                return WebBindingRegistry.valuesEquals(o1, o2);
            }

            public void onOperationCompleted(String requestId, Object result) {
            }

            public void onStatusChanged(String widgetId, String propertyName, String statusType, String statusMessage) {
                WebClientData.this.fClientListener.onStatusChanged(widgetId, propertyName, statusType, statusMessage);
            }

            public String resolveAppPath(String appPath) {
                return WebClientData.this.fClientListener.resolveAppPath(appPath);
            }

            public void onValueChanged(String widgetId, String propertyName, Object newValue, Map<String, Object> attributes) {
                WebClientData.this.fClientListener.onValueChanged(widgetId, propertyName, newValue, attributes);
            }

            public void requestWidgetConnect(String widgetId, String propertyName) {
                WebClientData.this.fClientListener.requestWidgetConnect(widgetId, propertyName);
            }

            class Change
            implements IWidgetValueChange,
            Comparable<Change> {
                Object value;
                GroupWidget gw;

                Change(GroupWidget gw, Object value) {
                    this.gw = gw;
                    this.value = value;
                }

                public String getWidgetId() {
                    return this.gw.widgetId;
                }

                public String getPropertyId() {
                    return this.gw.propertyId;
                }

                public Object getValue() {
                    return this.value;
                }

                public void setValue(Object value) {
                    this.value = value;
                }

                @Override
                public int compareTo(Change o) {
                    int x = this.gw.groupId.compareTo(o.gw.groupId);
                    if (x != 0) {
                        return x;
                    }
                    return new Long(this.gw.groupOrder).compareTo(new Long(o.gw.groupOrder));
                }
            }

            class GroupWidget {
                String widgetId;
                String propertyId;
                long groupOrder;
                String groupId;

                GroupWidget(String groupId, long groupOrder, String widgetId, String propId) {
                    this.widgetId = widgetId;
                    this.propertyId = propId;
                    this.groupId = groupId;
                    this.groupOrder = groupOrder;
                }
            }
        }

        class FileLocationResolver
        implements IFileLocationResolver {
            FileLocationResolver() {
            }

            public String resolveAppPath(String appPath) {
                return WebClientData.this.fClientListener.resolveAppPath(appPath);
            }
        }

        class ServerListener
        implements IServerListener {
            ServerListener() {
            }

            public void onValueChanged(final String widgetId, final String propertyName, final Object newValue) {
                WebClientData.this.backplane.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (((ServerListener)ServerListener.this).WebClientData.this.backplane == null) {
                            return;
                        }
                        String widgetURI = WebBindingRegistry.getWidgetURI(widgetId, propertyName);
                        IBind widgetBind = ((ServerListener)ServerListener.this).WebClientData.this.backplane.getBinding(widgetURI);
                        if (!(widgetBind instanceof IBindValue)) {
                            ErrorReporter.report("WebBindingRegistry...onValueChanged()" + widgetURI + " binding does not exist.");
                            return;
                        }
                        IBindValue bv = (IBindValue)widgetBind;
                        Object newNewValue = ServerListener.this.convertFromJson(newValue);
                        WebClientData.this.setWidgetValue(bv, widgetId, propertyName, null, newNewValue);
                    }
                });
            }

            private Object convertFromJson(Object newValue) {
                if (newValue instanceof ArrayList) {
                    ArrayList newList = newValue;
                    ArrayList<Long> longList = new ArrayList<Long>();
                    boolean conversionOK = true;
                    for (Object x : newList) {
                        if (x instanceof Integer) {
                            longList.add(new Long(((Integer)x).intValue()));
                            continue;
                        }
                        if (x instanceof Long) {
                            longList.add((Long)x);
                            continue;
                        }
                        conversionOK = false;
                        break;
                    }
                    if (conversionOK) {
                        newValue = longList;
                    }
                }
                return newValue;
            }

            public void executeOperation(final String operationName, final Object arguments, final String requestId) {
                WebClientData.this.backplane.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IBind modleBind = ((ServerListener)ServerListener.this).WebClientData.this.backplane.getBinding(operationName);
                        if (!(modleBind instanceof IBindAction)) {
                            String errorMessage = String.valueOf(operationName) + " it is not an action binding.";
                            ErrorReporter.report(errorMessage);
                            Object ret = ServerListener.this.createResult(AbstractStatus.createErrorStatus((String)errorMessage), null);
                            ((ServerListener)ServerListener.this).WebClientData.this.fClientListener.onOperationCompleted(requestId, ret);
                            return;
                        }
                        IFinishedWithResult callback = new IFinishedWithResult(){

                            public void done(IStatus status, Object result) {
                                Object ret = ServerListener.this.createResult(status, result);
                                ((ServerListener)(this).ServerListener.this).WebClientData.this.fClientListener.onOperationCompleted(requestId, ret);
                            }
                        };
                        ((IBindAction)modleBind).run(arguments, callback);
                    }
                });
            }

            private Object createResult(IStatus status, Object result) {
                HashMap<String, Object> top = new HashMap<String, Object>();
                if (status != null) {
                    HashMap<String, String> stat = new HashMap<String, String>();
                    String message = status.getMessage();
                    String type = status.getType().name();
                    String id = status.getId();
                    stat.put("type", type);
                    stat.put("message", message);
                    stat.put("id", id);
                    top.put("status", stat);
                }
                top.put("result", result);
                return top;
            }
        }
    }
}

