/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.gui.composer.common.internal.GCCommonPlugin;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;

public class WebContent {
    private static WebContent instance = null;
    private HashMap<String, String> cache = new HashMap();

    public static synchronized WebContent getInstance() {
        if (instance == null) {
            instance = new WebContent();
        }
        return instance;
    }

    private WebContent() {
    }

    public String getProgressURI(String message) {
        return String.valueOf(this.getURI("progress.html")) + "?status=" + URLEncoder.encode(message).replaceAll("\\+", "%20");
    }

    public String getErrorURI(String message) {
        return String.valueOf(this.getURI("error_message.html")) + "?status=" + URLEncoder.encode(message).replaceAll("\\+", "%20");
    }

    public String getPreviewURI(String message) {
        return String.valueOf(this.getURI("preview.html")) + "?src=" + URLEncoder.encode(message).replaceAll("\\+", "%20");
    }

    public String getCommonPagesURI(String type, Object message) {
        if ("progress".equals(type) && message instanceof String) {
            return this.getProgressURI((String)message);
        }
        if ("error".equals(type) && message instanceof String) {
            return this.getErrorURI((String)message);
        }
        if ("preview".equals(type) && message instanceof String) {
            return this.getPreviewURI((String)message);
        }
        return "about:blank";
    }

    private String getURI(String resource) {
        if (this.cache.get(resource) == null) {
            URL url = GCCommonPlugin.getDefault().getBundle().getEntry("WebContents/" + resource);
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                GCCommonPlugin.log(e);
            }
            String value = url.toExternalForm().replaceFirst("file:/", "file:///");
            this.cache.put(resource, value);
        }
        return this.cache.get(resource);
    }

    public String getXULRunnerErrorURI() {
        return this.getURI("xulrunner_error.html");
    }
}

