/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ConversionErrorStatus;
import com.ti.backplane.internal.bind.IBindWidget;
import com.ti.backplane.internal.bind.IStreamListener;
import com.ti.backplane.internal.bind.IStreamValue;
import com.ti.backplane.internal.bind.OutStreamValue;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.FormattedString;
import com.ti.backplane.internal.datatypes.IDataConverter;
import com.ti.backplane.internal.datatypes.IDataConverterFactory;
import com.ti.gui.composer.common.internal.WebBindingRegistry;
import com.ti.gui.composer.common.internal.WebWidgetsBindFactory;
import com.ti.gui.composer.common.internal.WebWidgetsInitData;
import com.ti.gui.composer.webserver.adapter.internal.IClientListener;
import java.util.HashMap;

class WebWidgetValueBind
extends AbstractBindValue
implements IBindWidget,
IDataConverterFactory {
    static HashMap<String, Object> streamMsgAttributes = new HashMap();
    boolean fUpdateEnabled = true;
    boolean fValueDifferentThatWidget = false;
    WebBindingRegistry.WebClientData.ClentFilteredListener fClientListener;
    String fDataFormat;
    IDataConverterFactory fConverterFactory;
    String fWidgetId;
    String fPropertyId;
    String fAttributeId;
    IStreamListener streamValueListener;
    boolean connectedToClient = true;
    boolean clientValueRequested = false;
    WebWidgetsInitData fInitData;

    public WebWidgetValueBind(AbstractBindFactory model, Object initValue, Class<?> clazz) {
        super(model, initValue, clazz);
        streamMsgAttributes.put("setValueWhenEqual", new Boolean(true));
    }

    public WebWidgetValueBind(AbstractBindFactory model, WebWidgetsInitData initData) {
        super(model, initData.getDefaultValue(), initData.getType());
        streamMsgAttributes.put("setValueWhenEqual", new Boolean(true));
        this.fInitData = initData;
        this.setDataFormat(initData.getDataFormat());
    }

    public WebWidgetValueBind(AbstractBindFactory model, String fullUri) {
        super(model);
        streamMsgAttributes.put("setValueWhenEqual", new Boolean(true));
        this.connectedToClient = false;
        this.setName(fullUri);
        String[] parts = fullUri.split("\\Q.\\E");
        if (parts[0].equals("widget")) {
            if (parts.length > 1) {
                this.fWidgetId = parts[1];
            }
            if (parts.length > 2) {
                this.fPropertyId = parts[2];
            }
        } else {
            if (parts.length > 0) {
                this.fWidgetId = parts[0];
            }
            if (parts.length > 1) {
                this.fPropertyId = parts[1];
            }
        }
    }

    protected void onValueChanged(Object oldValue, Object newValue) {
        if (newValue instanceof OutStreamValue) {
            return;
        }
        if (this.getClientListener() != null) {
            if (this.getUpdateEnabled()) {
                this.onDataChanged(newValue);
            } else {
                this.fValueDifferentThatWidget = true;
            }
        }
    }

    protected boolean valuesEqual(Object newValue, Object oldValue) {
        if (super.valuesEqual(newValue, oldValue)) {
            return true;
        }
        return WebBindingRegistry.valuesEquals(newValue, oldValue);
    }

    public void setUpdateEnabled(boolean enabled) {
        this.fUpdateEnabled = enabled;
        if (this.fUpdateEnabled && this.fValueDifferentThatWidget) {
            Object value = this.getValue();
            if (value != null) {
                this.onDataChanged(value);
            }
            this.fValueDifferentThatWidget = false;
        }
    }

    public boolean getUpdateEnabled() {
        return this.fUpdateEnabled;
    }

    public IClientListener getClientListener() {
        return this.fClientListener;
    }

    public void setClientListener(WebBindingRegistry.WebClientData.ClentFilteredListener clientListener) {
        this.fClientListener = clientListener;
    }

    public void setDataFormat(String dataFormat) {
        this.fDataFormat = dataFormat;
        this.fConverterFactory = this.fDataFormat != null ? new FormattedString(null, this.fDataFormat) : null;
    }

    public IDataConverter getConverter(Class<?> sourceType, Class<?> destinationType) {
        if (IStreamValue.class.isAssignableFrom(sourceType)) {
            return new IDataConverter(){

                public Object convert(Object source, IStatus[] status) {
                    return source;
                }
            };
        }
        if (this.fConverterFactory instanceof FormattedString) {
            return this.fConverterFactory.getConverter(sourceType, FormattedString.class);
        }
        return null;
    }

    public void onDataChanged(Object newValue) {
        if (this.fClientListener != null) {
            Object oldValue = this.getValue();
            if (this.streamValueListener != null && oldValue instanceof IStreamValue) {
                ((IStreamValue)oldValue).removeStreamListener(this.streamValueListener);
                this.streamValueListener = null;
            }
            if (newValue instanceof IStreamValue) {
                this.streamValueListener = new IStreamListener(){

                    public void onRecordAdded(Object record, IFinished callback) {
                        IStatus[] s = new IStatus[1];
                        Class modelType = record != null ? record.getClass() : String.class;
                        Class targetType = WebWidgetValueBind.this.fDefaultType;
                        Object valueForTarget = new DataConverter().convert(modelType, targetType, record, null, s);
                        if (s[0] != null && valueForTarget != null) {
                            WebWidgetValueBind.this.setStatus(s[0]);
                        } else {
                            WebWidgetValueBind.this.fClientListener.onValueChanged(WebWidgetValueBind.this.fWidgetId, WebWidgetValueBind.this.fPropertyId, valueForTarget, streamMsgAttributes);
                        }
                        if (callback != null) {
                            callback.done(null);
                        }
                    }
                };
                ((IStreamValue)newValue).addStreamListener(this.streamValueListener);
                return;
            }
            if (newValue instanceof FormattedString) {
                newValue = newValue.toString();
            }
            this.fClientListener.onValueChanged(this.fWidgetId, this.fPropertyId, newValue);
        }
    }

    public void onStatusChanged(IStatus oldStatus, IStatus newStatus) {
        if (this.fClientListener != null) {
            String statusType = "ok";
            String statusMessage = null;
            if (newStatus != null && (!(newStatus instanceof ConversionErrorStatus) || ((ConversionErrorStatus)newStatus).getTarget().equals((Object)this))) {
                if (newStatus.getType() == IStatus.StatusType.ERROR) {
                    statusType = "error";
                } else if (newStatus.getType() == IStatus.StatusType.WARNING) {
                    statusType = "warning";
                }
                statusMessage = newStatus.getMessage();
            }
            this.fClientListener.onStatusChanged(this.fWidgetId, this.fPropertyId, statusType, statusMessage);
        }
    }

    public String getWidgetId() {
        return this.fWidgetId;
    }

    public String getPropertyId() {
        return this.fPropertyId;
    }

    public void setWidgetInfo(String widgetId, String propertyId, WebBindingRegistry.WebClientData.ClentFilteredListener clientListener) {
        this.fWidgetId = widgetId;
        this.fPropertyId = propertyId;
        this.fClientListener = clientListener;
        if (this.fInitData != null) {
            String groupId = this.fInitData.getGroupId();
            Long groupOrder = this.fInitData.getGroupOrder();
            if (groupId != null && groupOrder != null) {
                this.fClientListener.addToGroup(groupId, groupOrder, widgetId, propertyId);
            }
        }
    }

    public void updateValueOnEnable(boolean update) {
        this.fValueDifferentThatWidget = update;
    }

    public Object getValue() {
        if (!this.connectedToClient && !this.clientValueRequested) {
            this.clientValueRequested = true;
            this.getModel().getClientListener().requestWidgetConnect(this.fWidgetId, this.fPropertyId);
        }
        return super.getValue();
    }

    public WebWidgetsBindFactory getModel() {
        return (WebWidgetsBindFactory)super.getModel();
    }

    boolean isWaintingForConnectResponse() {
        return !this.connectedToClient && this.clientValueRequested;
    }

    void onConnectReceived(WebWidgetsInitData initData) {
        if (!this.isWaintingForConnectResponse()) {
            return;
        }
        this.clientValueRequested = true;
        this.connectedToClient = true;
        this.setValue(initData.getValue(), null);
    }
}

