/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.IBind;
import com.ti.gui.composer.common.internal.WebWidgetErrorBind;
import com.ti.gui.composer.common.internal.WebWidgetValueBind;
import com.ti.gui.composer.common.internal.WebWidgetsInitData;
import com.ti.gui.composer.webserver.adapter.internal.IClientListener;
import java.util.ArrayList;

class WebWidgetsBindFactory
extends AbstractBindFactory {
    WebWidgetsInitData fNextInitData = new WebWidgetsInitData();
    IClientListener clientListener;

    protected IBind createNewBind(String uri) {
        String longURI = WebWidgetsBindFactory.toLongWidgetURI(uri);
        if ("backplane".equals(uri)) {
            return new WebWidgetErrorBind(this);
        }
        if (longURI.equals(this.fNextInitData.getWidURI())) {
            return new WebWidgetValueBind((AbstractBindFactory)this, this.fNextInitData);
        }
        return new WebWidgetValueBind((AbstractBindFactory)this, longURI);
    }

    void setNextToDefault() {
        this.fNextInitData = new WebWidgetsInitData();
    }

    void setNextInitData(WebWidgetsInitData initData) {
        this.fNextInitData = initData;
    }

    ArrayList<IBind> getBindsForWidgetExcept(String widgetId, String[] propsToExclude) {
        ArrayList<IBind> retArray = new ArrayList<IBind>();
        IBind[] iBindArray = this.getBindings();
        int n = iBindArray.length;
        int n2 = 0;
        while (n2 < n) {
            WebWidgetValueBind wb;
            IBind widgetBind = iBindArray[n2];
            if (widgetBind instanceof WebWidgetValueBind && widgetId.equals((wb = (WebWidgetValueBind)widgetBind).getWidgetId()) && !this.propertyMatches(propsToExclude, wb.getPropertyId())) {
                retArray.add(widgetBind);
            }
            ++n2;
        }
        return retArray;
    }

    public boolean propertyMatches(String[] props, String propertyId) {
        String[] stringArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (prop.equals(propertyId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IClientListener getClientListener() {
        return this.clientListener;
    }

    public void setClientListener(IClientListener listener) {
        this.clientListener = listener;
    }

    public boolean completesConnectRequest(WebWidgetsInitData initData) {
        if (!initData.getConnectResponse()) {
            return false;
        }
        String shortURI = WebWidgetsBindFactory.toShortWidgetURI(initData.getWidURI());
        IBind bind = this.findBinding(shortURI);
        if (!(bind instanceof WebWidgetValueBind)) {
            return false;
        }
        WebWidgetValueBind w = (WebWidgetValueBind)bind;
        if (!w.isWaintingForConnectResponse()) {
            return false;
        }
        w.onConnectReceived(initData);
        return true;
    }

    static String toShortWidgetURI(String longURI) {
        if (longURI.startsWith("widget.")) {
            return longURI.substring("widget.".length());
        }
        return longURI;
    }

    static String toLongWidgetURI(String shortURI) {
        if (shortURI.startsWith("prop")) {
            return shortURI;
        }
        return "widget." + shortURI;
    }
}

