/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GCUIUtils {
    public static String NEWLINE = System.getProperty("line.separator");

    public static void ensureMozillaPreferences() throws Throwable {
        IPath profilePath = GCUIUtils.getProfilePath();
        if (profilePath != null) {
            profilePath.toFile().mkdirs();
            File userPref = profilePath.append("user.js").toFile();
            if (userPref.exists()) {
                userPref.delete();
                userPref = profilePath.append("user.js").toFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(userPref));
            writer.write(GCUIUtils.composePrefBoolean("browser.cache.disk.enable", false));
            writer.close();
        }
    }

    private static IPath getProfilePath() throws Throwable {
        Class<?> clazz = Class.forName("org.eclipse.swt.browser.MozillaDelegate");
        if (clazz != null) {
            Method m = clazz.getDeclaredMethod("getProfilePath", new Class[0]);
            m.setAccessible(true);
            return new Path((String)m.invoke(new Object(), new Object[0]));
        }
        return null;
    }

    private static String composePrefBoolean(String key, boolean value) {
        return "user_pref(\"" + key + "\", " + value + ");" + NEWLINE;
    }
}

