/*
 * Decompiled with CFR 0.152.
 */
package com.ti.base.rcp.internal.gc;

import com.ti.backplane.bind.IDisposable;
import com.ti.gui.composer.common.GCInitData;
import com.ti.gui.composer.common.internal.GCServerInfo;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServer;
import com.ti.gui.composer.webserver.internal.WebAppInfo;
import java.util.HashSet;
import java.util.Set;

public class BackendServer {
    private static BackendServer instance;
    private Set<IDisposable> disposeListeners = new HashSet<IDisposable>();

    public void addDisposeListener(IDisposable listener) {
        this.disposeListeners.add(listener);
    }

    public void deinit() {
        for (IDisposable l : this.disposeListeners) {
            l.dispose();
        }
        this.disposeListeners.clear();
    }

    public static synchronized BackendServer instance() {
        if (instance == null) {
            instance = new BackendServer();
        }
        return instance;
    }

    private BackendServer() {
        if (!GCServerInfo.getInstance().hasPort()) {
            System.exit(1);
        }
    }

    public synchronized void startAppServer(final IRequestMonitor monitor) {
        GCServerInfo.getInstance().startAppServer(new IRequestMonitor(){

            public void failed(String errorMsg) {
                monitor.failed(errorMsg);
            }

            public void done(Object result) {
                GCInitData.WebAppIsnitall a = GCInitData.getInstance().getReadOnlyWebAppInstall();
                if (a != null) {
                    WebAppInfo webAppInfo = new WebAppInfo(a.getFolder(), a.getName());
                    GuiComposerWebServer.getInstance().addApp(webAppInfo);
                }
                monitor.done(null);
            }
        });
    }
}

