/*
 * Decompiled with CFR 0.152.
 */
package com.ti.base.rcp.internal.gc;

import com.ti.base.rcp.IWebAppInitializer;
import com.ti.base.rcp.internal.gc.BackendServer;
import com.ti.base.rcp.internal.gc.GCExtensionPlugin;
import com.ti.browser.ITIBrowser;
import com.ti.browser.internal.TIBrowserPlugin;
import com.ti.gui.composer.common.GCInitData;
import com.ti.gui.composer.common.internal.GCAppStartupReturnInfo;
import com.ti.gui.composer.common.internal.GCServerInfo;
import com.ti.gui.composer.common.internal.WebContent;
import com.ti.gui.composer.common.internal.ui.GCCommonUIPlugin;
import com.ti.gui.composer.common.internal.ui.GCUIUtils;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

public class WebAppInitializer
implements IWebAppInitializer {
    private static String TIREX_CONTEXT = "TiRex";
    private Map<String, GCAppStartupReturnInfo> appHandles = new HashMap<String, GCAppStartupReturnInfo>();
    private boolean initMozillaPref = false;

    private synchronized void initBackend() throws Throwable {
        if (!this.initMozillaPref) {
            this.initMozillaPref = true;
            GCUIUtils.ensureMozillaPreferences();
        }
        BackendServer.instance();
    }

    public boolean isXULRunnerAvaliable() {
        return GCCommonUIPlugin.isXULRunnerAvaliable();
    }

    public boolean hasChromeBrowserPlugin() {
        return TIBrowserPlugin.hasChromeBrowserPlugin();
    }

    public String getXULRunnerErrorURI() {
        return WebContent.getInstance().getXULRunnerErrorURI();
    }

    public synchronized void initTiRexWebapp(final ITIBrowser browser, final String url) {
        try {
            this.initBackend();
            browser.setUrl(WebContent.getInstance().getProgressURI("Loading Application..."));
            GCServerInfo.getInstance().addFolder(url, TIREX_CONTEXT, true, new IRequestMonitor(){

                public void failed(final String errorMsg) {
                    Display d = browser.getDisplay();
                    d.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errorURI = WebContent.getInstance().getProgressURI(errorMsg);
                            browser.setUrl(errorURI);
                        }
                    });
                }

                public void done(final Object result) {
                    Display d = browser.getDisplay();
                    d.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            GCAppStartupReturnInfo appHandle = (GCAppStartupReturnInfo)result;
                            WebAppInitializer.this.appHandles.put(url, appHandle);
                            browser.setUrl(appHandle.getURI());
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            GCExtensionPlugin.log(e);
        }
    }

    public synchronized void initStandaloneWebapp(final ITIBrowser browser, String url) {
        try {
            this.initBackend();
            browser.setUrl(WebContent.getInstance().getProgressURI("Loading Application..."));
            BackendServer.instance().startAppServer(new IRequestMonitor(){

                public void done(Object result) {
                    browser.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String url = WebAppInitializer.this.getStandaloneAppURI();
                            if (url != null) {
                                browser.setUrl(url);
                            } else {
                                String errorURI = WebContent.getInstance().getErrorURI("System property gc.webApp is not specified.");
                                browser.setUrl(errorURI);
                            }
                        }
                    });
                }

                public void failed(final String errorMsg) {
                    browser.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errorURI = WebContent.getInstance().getProgressURI(errorMsg);
                            browser.setUrl(errorURI);
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            GCExtensionPlugin.log(e);
        }
    }

    public synchronized void deinitWebapp(String url) {
        GCAppStartupReturnInfo appHandle = this.appHandles.get(url);
        if (appHandle != null) {
            GCServerInfo.getInstance().removeFolder(appHandle);
            this.appHandles.remove(url);
        }
        BackendServer.instance().deinit();
    }

    private String getStandaloneAppURI() {
        GCInitData.WebAppIsnitall webAppIntall = GCInitData.getInstance().getReadOnlyWebAppInstall();
        if (webAppIntall == null) {
            return null;
        }
        String webAppName = GCInitData.getInstance().getWebAppName();
        if (webAppName == null) {
            return null;
        }
        if (!GCServerInfo.getInstance().hasPort()) {
            return null;
        }
        String port = new Integer(GCServerInfo.getInstance().getPort()).toString();
        String gcContext = GCServerInfo.getInstance().getContextName();
        String appContext = webAppIntall.getName();
        return "http://localhost:" + port + "/" + gcContext + "/" + appContext + "/" + webAppName + "/index.html";
    }
}

