/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.binding.program.ui;

import com.ti.binding.program.internal.DSSessionManager;
import com.ti.ccstudio.debug.service.IDSBackendService;
import com.ti.ccstudio.debug.ui.CCSDebugUITools;
import com.ti.debug.engine.IDspTask;
import com.ti.xpcom.XPCOMException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DSActiveContextProvider
implements IDebugContextListener {
    String fTaskName;
    IDspTask fTask;
    IDebugContextService fContextService;

    public DSActiveContextProvider(final IWorkbenchWindow workbenchWindow) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DSActiveContextProvider.this.fContextService = DebugUITools.getDebugContextManager().getContextService(workbenchWindow);
                DSActiveContextProvider.this.fContextService.addDebugContextListener((IDebugContextListener)DSActiveContextProvider.this);
                DSActiveContextProvider.this.setTask(DSActiveContextProvider.this.getDebugContextForSelection(DSActiveContextProvider.this.fContextService.getActiveContext()));
            }
        });
    }

    public void dispose() {
        if (this.fContextService != null) {
            this.fContextService.removeDebugContextListener((IDebugContextListener)this);
            this.fContextService = null;
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.setTask(this.getDebugContextForSelection(event.getContext()));
    }

    void setTask(IDspTask newTask) {
        if (this.fTask == newTask) {
            return;
        }
        String newTaskName = null;
        try {
            if (newTask != null) {
                newTaskName = newTask.getFullPathName();
            }
        }
        catch (XPCOMException xPCOMException) {}
        if (newTaskName == null ? this.fTaskName == null : newTaskName.equals(this.fTaskName)) {
            return;
        }
        this.fTaskName = newTaskName;
        this.fTask = newTask;
        DSSessionManager.getInstance().fireSessionActivated(this.fTask, this.fTaskName);
    }

    IDspTask getDebugContextForSelection(ISelection selection) {
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IDSBackendService.IDSTaskContext[] dsTaskContexts = CCSDebugUITools.getDSTasks((Object[])((IStructuredSelection)selection).toArray());
        if (dsTaskContexts == null) {
            return null;
        }
        if (dsTaskContexts.length != 1) {
            return null;
        }
        return dsTaskContexts[0].getTask();
    }
}

