/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.binding.program.ui;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSInitScriptInfo;
import com.ti.binding.program.internal.DSSessionManager;
import com.ti.binding.program.internal.ProgressLogger;
import com.ti.binding.program.internal.ui.provider.IDSInitializer;
import com.ti.binding.program.internal.ui.provider.IDSInitializerParent;
import com.ti.ccstudio.debug.launch.CCSLaunch;
import com.ti.ccstudio.debug.launch.ScriptedLaunchInfo;
import com.ti.ccstudio.debug.ui.launch.CCSLauncher;
import com.ti.ccstudio.rhino.IRhinoOutput;
import com.ti.ccstudio.rhino.RhinoPlugin;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IProgressTask;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.data.IProgressTaskData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import java.io.IOException;

public class DSInitializerCCS
implements IDSInitializer {
    IDSInitializerParent parent;
    boolean launchingCompleted = false;
    boolean launchingStarted = false;
    DSSessionManager.IDSSessionListener acListener = null;
    CCSLaunch.ILaunchInProgressListener lipListener = null;
    IRhinoOutput rhinoListener = null;
    String bufferedString = "";
    private OnTaskStartedListener onTaskStarted;
    private IStringEventListener onErrorListener;
    private IStringEventListener onFatalListener;
    private IStringEventListener onInfoListener;
    private IStringEventListener onWarningListener;
    private final IStatus[] dsErrorStatus = new IStatus[1];
    private IApplication application;

    DSInitializerCCS(IDSInitializerParent parent) {
        this.parent = parent;
    }

    public IStatus restart(DSInitScriptInfo info) {
        CCSLauncher.terminateAll();
        if (CCSLaunch.getCanLaunch()) {
            CCSLaunch.setMRLaunchScriptException(null);
            String configFileName = (String)info.getVars().get("appConfigFile");
            ScriptedLaunchInfo launchInfo = new ScriptedLaunchInfo(configFileName, info.getPath(), info.getVars());
            this.launchingCompleted = false;
            this.launchingStarted = false;
            this.subscribeRhinoListener();
            this.subscribeAppConfigured();
            this.subscribeLaunchInProgress();
            CCSLauncher.launchScript((ScriptedLaunchInfo)launchInfo);
            this.waitLaunchInProgress();
            this.waitForLauncingToComlete();
            this.unsubscribeLaunchInProgress();
            this.unsubscribeAppConfigured();
            this.unsubscribeRhinoListener();
            Exception mrException = CCSLaunch.getMRLaunchScriptException();
            if (mrException != null) {
                CCSLaunch.setMRLaunchScriptException(null);
                String errorMessage = mrException.getMessage();
                this.parent.reportError(errorMessage);
                return AbstractStatus.createErrorStatus((String)errorMessage);
            }
            if (this.dsErrorStatus[0] != null) {
                CCSLaunch.setMRLaunchScriptException(null);
                String errorMessage = this.dsErrorStatus[0].getMessage();
                this.parent.reportError(errorMessage);
                return AbstractStatus.createErrorStatus((String)errorMessage);
            }
        }
        return null;
    }

    private void subscribeAppConfigured() {
        this.acListener = new DSSessionManager.IDSSessionListener(){

            public void onSessionStarted(String taskId) {
            }

            public void onSessionEnding(String taskId) {
            }

            public void onSessionActivated(String taskId) {
            }

            public void onAppConfigured() {
                DSInitializerCCS.this.launchingCompleted = true;
            }
        };
        DSSessionManager.getInstance().addSessionListener(this.acListener);
    }

    private void unsubscribeAppConfigured() {
        if (this.acListener != null) {
            DSSessionManager.getInstance().removeSessionListener(this.acListener);
            this.acListener = null;
        }
    }

    private void subscribeLaunchInProgress() {
        this.lipListener = new CCSLaunch.ILaunchInProgressListener(){

            public void onChanged(boolean newValue) {
                DSInitializerCCS.this.launchingStarted = true;
            }

            public void onAppCreated(IApplication app) {
                if (app != null) {
                    DSInitializerCCS.this.application = app;
                    DSInitializerCCS.this.addApplicationListeners();
                }
            }

            public void onAppAboutToBeDeconfigured(IApplication app) {
                if (DSInitializerCCS.this.application.equals(app)) {
                    DSInitializerCCS.this.application = null;
                    DSInitializerCCS.this.removeApplicationListeners();
                }
            }
        };
        CCSLaunch.addLaunchInProgressChangeListener((CCSLaunch.ILaunchInProgressListener)this.lipListener);
    }

    private void unsubscribeLaunchInProgress() {
        if (this.lipListener != null) {
            CCSLaunch.removeLaunchInProgressChangeListener((CCSLaunch.ILaunchInProgressListener)this.lipListener);
            this.lipListener = null;
        }
    }

    private void waitLaunchInProgress() {
        while (!this.launchingStarted) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return;
    }

    private void waitForLauncingToComlete() {
        while (!this.launchingCompleted) {
            if (CCSLaunch.getCanLaunch()) {
                return;
            }
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return;
    }

    private void subscribeRhinoListener() {
        this.rhinoListener = new IRhinoOutput(){

            public void output(int b) throws IOException {
                if (b != 10) {
                    DSInitializerCCS.this.bufferedString = String.valueOf(DSInitializerCCS.this.bufferedString) + (char)b;
                }
                if (b == 13) {
                    DSInitializerCCS.this.parent.reportError(DSInitializerCCS.this.bufferedString);
                    DSInitializerCCS.this.bufferedString = "";
                }
            }
        };
        RhinoPlugin.addOutputListener((IRhinoOutput)this.rhinoListener);
    }

    private void unsubscribeRhinoListener() {
        if (this.rhinoListener != null) {
            RhinoPlugin.removeOutputListener((IRhinoOutput)this.rhinoListener);
            this.rhinoListener = null;
        }
    }

    private void addApplicationListeners() {
        if (this.application == null) {
            return;
        }
        this.onErrorListener = new IStringEventListener(){

            public void onEvent(String data) {
                ((DSInitializerCCS)DSInitializerCCS.this).dsErrorStatus[0] = AbstractStatus.createErrorStatus((String)data);
            }
        };
        this.onFatalListener = new IStringEventListener(){

            public void onEvent(String data) {
                ((DSInitializerCCS)DSInitializerCCS.this).dsErrorStatus[0] = AbstractStatus.createErrorStatus((String)data);
            }
        };
        this.onInfoListener = new IStringEventListener(){

            public void onEvent(String data) {
                DSInitializerCCS.this.parent.reportError(String.valueOf(data) + "\n");
            }
        };
        this.onWarningListener = new IStringEventListener(){

            public void onEvent(String data) {
                ((DSInitializerCCS)DSInitializerCCS.this).dsErrorStatus[0] = AbstractStatus.createErrorStatus((String)data);
            }
        };
        this.onTaskStarted = new OnTaskStartedListener();
        this.application.onTaskStart().addIObjectEventListener((IObjectEventListener)this.onTaskStarted);
        this.application.onError().addIStringEventListener(this.onErrorListener);
        this.application.onFatal().addIStringEventListener(this.onFatalListener);
        this.application.onInfo().addIStringEventListener(this.onInfoListener);
        this.application.onWarning().addIStringEventListener(this.onWarningListener);
    }

    private void removeApplicationListeners() {
        if (this.application == null) {
            return;
        }
        if (this.onTaskStarted != null) {
            this.application.onTaskStart().removeIObjectEventListener((IObjectEventListener)this.onTaskStarted);
        }
        if (this.onErrorListener != null) {
            this.application.onError().removeIStringEventListener(this.onErrorListener);
        }
        if (this.onFatalListener != null) {
            this.application.onFatal().removeIStringEventListener(this.onFatalListener);
        }
        if (this.onInfoListener != null) {
            this.application.onInfo().removeIStringEventListener(this.onInfoListener);
        }
        if (this.onWarningListener != null) {
            this.application.onWarning().removeIStringEventListener(this.onWarningListener);
        }
    }

    class OnTaskChangedListener
    implements IObjectEventListener<IEventData<IProgressTaskData>> {
        public String taskName;

        public OnTaskChangedListener(String name) {
            this.taskName = name;
        }

        public void onEvent(IEventData<IProgressTaskData> data) {
            IProgressTaskData taskData = (IProgressTaskData)data.getEventData();
            int percentDone = taskData.getPercentDone();
            String subActivity = taskData.getSubActivity();
            if (percentDone == 0 || percentDone == 100) {
                ProgressLogger.getInstance().removeLog(this.taskName);
            } else {
                ProgressLogger.getInstance().writeLog(this.taskName, subActivity, percentDone);
            }
        }
    }

    class OnTaskStartedListener
    implements IObjectEventListener<IEventData<IProgressTask>> {
        private IStringEventListener onTaskCompletedListener;
        private OnTaskChangedListener onTaskChangedListener;

        OnTaskStartedListener() {
        }

        public void onEvent(IEventData<IProgressTask> data) {
            IProgressTask task = (IProgressTask)data.getEventData();
            final String name = task.getName();
            this.onTaskCompletedListener = new IStringEventListener(){

                public void onEvent(String error) {
                    ProgressLogger.getInstance().removeLog(name);
                }
            };
            this.onTaskChangedListener = new OnTaskChangedListener(name);
            task.onCompleted().addIStringEventListener(this.onTaskCompletedListener);
            task.onUpdate().addIObjectEventListener((IObjectEventListener)this.onTaskChangedListener);
        }
    }
}

