/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.binding.program.ui;

import com.ti.binding.program.internal.DSSessionManager;
import com.ti.ccstudio.binding.program.ui.Activator;
import com.ti.ccstudio.debug.CCSDsfSessions;
import com.ti.ccstudio.debug.service.IDSBackendService;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspTask;
import com.ti.xpcom.XPCOMException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public class DSSessionProvider
implements DsfSession.SessionStartedListener,
DsfSession.SessionEndedListener {
    private HashSet<String> fSessionIds = new HashSet();
    private static DSSessionProvider instance = null;

    public static synchronized DSSessionProvider getInstance() {
        if (instance == null) {
            instance = new DSSessionProvider();
        }
        return instance;
    }

    private DSSessionProvider() {
        this.init();
        CCSDsfSessions.instance().addSessionStartedListener((DsfSession.SessionStartedListener)this);
        CCSDsfSessions.instance().addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    void init() {
        DsfSession[] sessions;
        DsfSession[] dsfSessionArray = sessions = CCSDsfSessions.instance().getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            DsfSession session = dsfSessionArray[n2];
            this.sessionStarted(session);
            ++n2;
        }
    }

    public void sessionStarted(final DsfSession session) {
        this.fSessionIds.add(session.getId());
        this.postTo(session, new Runnable(){

            @Override
            public void run() {
                session.addServiceEventListener((Object)DSSessionProvider.this, null);
            }
        });
        this.requestVisibleDSTasks(session);
    }

    public void dispose() {
        CCSDsfSessions.instance().removeSessionStartedListener((DsfSession.SessionStartedListener)this);
        CCSDsfSessions.instance().removeSessionEndedListener((DsfSession.SessionEndedListener)this);
        Iterator<String> it = this.fSessionIds.iterator();
        while (it.hasNext()) {
            final DsfSession session = DsfSession.getSession((String)it.next());
            this.postTo(session, new Runnable(){

                @Override
                public void run() {
                    session.removeServiceEventListener((Object)DSSessionProvider.this);
                }
            });
        }
    }

    public void sessionEnded(DsfSession session) {
        this.fSessionIds.remove(session.getId());
        session.removeServiceEventListener((Object)this);
    }

    void updateVisibleDSTasks(DsfSession session, IDSBackendService.IDSTaskContext[] dsTaskContexts) {
        IDSBackendService.IDSTaskContext[] iDSTaskContextArray = dsTaskContexts;
        int n = dsTaskContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IDSBackendService.IDSTaskContext taskContext = iDSTaskContextArray[n2];
            try {
                IDspTask dspTask = taskContext.getTask();
                String taskId = dspTask.getFullPathName();
                DSSessionManager.getInstance().fireSessionStarted(dspTask, taskId);
            }
            catch (XPCOMException xPCOMException) {}
            ++n2;
        }
    }

    void requestVisibleDSTasks(final DsfSession session) {
        if (!this.postTo(session, new Runnable(){

            @Override
            public void run() {
                DsfExecutor executor = session.getExecutor();
                DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
                try {
                    IDSBackendService service = (IDSBackendService)tracker.getService(IDSBackendService.class);
                    if (service == null) {
                        DSSessionProvider.this.updateVisibleDSTasks(session, new IDSBackendService.IDSTaskContext[0]);
                        return;
                    }
                    service.getVisibleDSTasks((DataRequestMonitor)new DataRequestMonitor<IDSBackendService.IDSTaskContext[]>((Executor)executor, null){

                        protected void handleSuccess() {
                            DSSessionProvider.this.updateVisibleDSTasks(session, (IDSBackendService.IDSTaskContext[])this.getData());
                        }

                        protected void handleFailure() {
                            DSSessionProvider.this.updateVisibleDSTasks(session, new IDSBackendService.IDSTaskContext[0]);
                        }
                    });
                }
                finally {
                    if (tracker != null) {
                        tracker.dispose();
                    }
                }
            }
        })) {
            this.updateVisibleDSTasks(session, new IDSBackendService.IDSTaskContext[0]);
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IDSBackendService.IDSAppConfiguredEvent event) {
        try {
            IApplication app = ((IDSBackendService.IDSApplicationContext)event.getDMContext()).getApplication();
            DSSessionManager.getInstance().fireAppConfigured(app);
        }
        catch (XPCOMException xPCOMException) {}
    }

    @DsfServiceEventHandler
    public void handleEvent(IDSBackendService.IDSAppAboutToBeDeconfiguredEvent event) {
    }

    @DsfServiceEventHandler
    public void handleEvent(IDSBackendService.IDSTaskDisplayedEvent event) {
        try {
            IDspTask dspTask = ((IDSBackendService.IDSTaskContext)event.getDMContext()).getTask();
            String taskId = dspTask.getFullPathName();
            DSSessionManager.getInstance().fireSessionStarted(dspTask, taskId);
        }
        catch (XPCOMException xPCOMException) {}
    }

    @DsfServiceEventHandler
    public void handleEvent(IDSBackendService.IDSTaskHiddenEvent event) {
        try {
            IDspTask dspTask = ((IDSBackendService.IDSTaskContext)event.getDMContext()).getTask();
            String taskId = dspTask.getFullPathName();
            DSSessionManager.getInstance().fireSessionEnding(dspTask, taskId);
        }
        catch (XPCOMException xPCOMException) {}
    }

    boolean postTo(DsfSession session, Runnable command) {
        if (session == null) {
            return false;
        }
        DsfExecutor executor = session.getExecutor();
        if (executor == null || executor.isShutdown()) {
            return false;
        }
        executor.execute(command);
        return true;
    }
}

