/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.maqetta.commands;

import com.ti.ccstudio.core.PathManager;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.system.setup.SystemSetupEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.Command;

public abstract class AbstractCommand
extends Command {
    protected static final SystemSetupEditor systemSetup = new SystemSetupEditor();
    protected static final IPreferenceStore preference;
    private static final IPath workspaceRoot;
    private static final String PREFERENCE_FILE = ".appsettings";
    private static final String KEY__DEFAULT = "default";
    protected static final String OK = "OK";
    protected static final String PREF__PROGRAM = "program";
    protected static final String PREF__CONNECTION = "connection";
    protected static final String PREF__DEVICE = "device";
    protected static final String PREF__CONNECTION_FILTER = "connectionFilter";
    protected static final String PREF__DEVICE_FILTER = "deviceFilter";
    protected static final String PREF__COMPORT_FILTER = "comportFilter";
    protected static final String PREF__BAUDRATE = "baudrate";
    protected static final String PREF__FILE_FILTER_PATH = "fileFilterPath";

    static {
        systemSetup.setInstallDirectory(PathManager.INSTANCE.getSystemSetupDatabaseDir().toString());
        systemSetup.setUserDirectory(PathManager.INSTANCE.getSystemSetupUserDir().toString());
        preference = GUIComposerUIPlugin.getDefault().getPreferenceStore();
        workspaceRoot = GUIComposerUIPlugin.getDefault().getMaqettaWorkspace();
    }

    public final void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        String project = req.getParameter("project");
        if (project == null || project.isEmpty()) {
            this.doHandleCommand(req, user);
        } else {
            this.doHandleCommand(workspaceRoot.append(project), req, user);
        }
    }

    private File getPreferenceFile(IPath path) {
        IPath preferencePath = path.append(PREFERENCE_FILE);
        return preferencePath.toFile();
    }

    private JSONObject newDefaultObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(KEY__DEFAULT, (Object)new JSONObject());
            return jsonObject;
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
            return new JSONObject();
        }
    }

    private JSONObject getPreference(File preferenceFile) {
        if (preferenceFile != null && preferenceFile.exists() && preferenceFile.isFile()) {
            try {
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = new BufferedReader(new FileReader(preferenceFile));
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
                reader.close();
                return new JSONObject(buffer.toString());
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
        return this.newDefaultObject();
    }

    protected <T> T getProjectPreference(IPath projectPath, String key) {
        File preferenceFile = this.getPreferenceFile(projectPath);
        return this.getPreference(preferenceFile, key);
    }

    protected <T> T getWorkspacePreference(String key) {
        File preferenceFile = this.getPreferenceFile(workspaceRoot);
        return this.getPreference(preferenceFile, key);
    }

    private <T> T getPreference(File preferenceFile, String key) {
        JSONObject preference = this.getPreference(preferenceFile);
        try {
            JSONObject defaultObj = preference.getJSONObject(KEY__DEFAULT);
            return (T)defaultObj.get(key);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    protected void setProjectPreferences(IPath projectPath, Map<String, Object> preferences, boolean override) {
        File preferenceFile = this.getPreferenceFile(projectPath);
        this.setPreferences(preferenceFile, preferences, override);
    }

    protected void setWorkspacePreferences(Map<String, Object> preferences, boolean override) {
        File preferenceFile = this.getPreferenceFile(workspaceRoot);
        this.setPreferences(preferenceFile, preferences, override);
    }

    private void setPreferences(File preferenceFile, Map<String, Object> preferences, boolean override) {
        JSONObject preference;
        JSONObject jSONObject = preference = override ? this.newDefaultObject() : this.getPreference(preferenceFile);
        if (preferenceFile.exists()) {
            preferenceFile.delete();
        }
        try {
            JSONObject defaultObj = preference.getJSONObject(KEY__DEFAULT);
            if (defaultObj != null) {
                for (Map.Entry<String, Object> entry : preferences.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof String)) continue;
                    defaultObj.put(entry.getKey(), (Object)value.toString());
                }
            }
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
        try {
            FileWriter writer = new FileWriter(preferenceFile);
            preference.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            GUIComposerUIPlugin.log(e);
        }
    }

    protected void setProjectPreferences(IPath projectPath, Map<String, Object> preferences) {
        this.setProjectPreferences(projectPath, preferences, false);
    }

    protected void setWorkspacePreferences(Map<String, Object> preferences) {
        this.setWorkspacePreferences(preferences, false);
    }

    protected boolean assertValidParam(String param) {
        return param != null && !param.isEmpty();
    }

    protected String quoteText(String text) {
        return "'" + text + "'";
    }

    protected String escapeString(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("'", "\\\\'");
    }

    protected void doHandleCommand(IPath projectPath, HttpServletRequest req, IUser user) throws IOException {
    }

    protected void doHandleCommand(HttpServletRequest req, IUser user) throws IOException {
    }
}

