/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.maqetta.commands;

import com.ti.ccstudio.gui.composer.internal.maqetta.commands.AbstractCommand;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.Messages;
import com.ti.ccstudio.gui.composer.internal.ui.ZipUtil;
import com.ti.ccstudio.system.setup.SystemSetupWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class ExportProject
extends AbstractCommand {
    private static String APP_PROGRAM = "appProgram.out";
    private static ZipUtil.IZipFilter filter = new ZipUtil.IZipFilter(){

        @Override
        public boolean accept(File fileOrDir) {
            return !fileOrDir.getName().endsWith("workingcopy");
        }
    };

    @Override
    public void doHandleCommand(IPath projectPath, HttpServletRequest req, IUser user) throws IOException {
        boolean result = true;
        String zipFile = req.getParameter("zipFile");
        if (!this.assertValidParam(zipFile)) {
            this.responseString = this.quoteText(Messages.ERROR__export_undefined_location);
            GUIComposerUIPlugin.log(Messages.ERROR__export_undefined_location, null);
            return;
        }
        if (new File(zipFile).exists() && !new File(zipFile).delete()) {
            this.responseString = this.quoteText(Messages.ERROR__export_failed_delete_file);
            GUIComposerUIPlugin.log(Messages.ERROR__export_failed_delete_file, null);
            return;
        }
        CONNECTION_TYPE connectionType = CONNECTION_TYPE.JTAG;
        String connection = req.getParameter("connection");
        if (!this.assertValidParam(connection)) {
            this.responseString = this.quoteText(Messages.ERROR__export_undefined_connection);
            GUIComposerUIPlugin.log(Messages.ERROR__export_undefined_connection, null);
            return;
        }
        connectionType = this.getConnectionType(connection);
        String connectionFilter = req.getParameter("connectionFilter");
        String comportFilter = req.getParameter("comportFilter");
        String baudRate = req.getParameter("baudrate");
        String device = req.getParameter("device");
        if (!this.assertValidParam(device)) {
            this.responseString = this.quoteText(Messages.ERROR__export_undefined_device);
            GUIComposerUIPlugin.log(Messages.ERROR__export_undefined_device, null);
            return;
        }
        String deviceFilter = req.getParameter("deviceFilter");
        String programFile = req.getParameter("program");
        if (!this.assertValidParam(programFile)) {
            this.responseString = this.quoteText(Messages.ERROR__export_undefined_program);
            GUIComposerUIPlugin.log(Messages.ERROR__export_undefined_program, null);
            return;
        }
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        preferences.put("connection", connection);
        preferences.put("connectionFilter", connectionFilter);
        if (connectionType == CONNECTION_TYPE.UARTConnection) {
            preferences.put("comportFilter", comportFilter);
            preferences.put("baudrate", baudRate);
        }
        preferences.put("device", device);
        preferences.put("deviceFilter", deviceFilter);
        preferences.put("program", APP_PROGRAM);
        this.setProjectPreferences(projectPath, preferences, true);
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            Path baseDir = new Path(new Path(zipFile).removeFileExtension().lastSegment());
            result &= ZipUtil.addDirectory(zout, projectPath.toFile(), (IPath)baseDir, filter);
            if (programFile != null) {
                result &= ZipUtil.addFile(zout, new File(programFile), baseDir.append(APP_PROGRAM), filter);
            }
            Bundle bundle = GUIComposerUIPlugin.getDefault().getBundle();
            URL webAppUrl = bundle.getEntry("WebContents/webapp");
            webAppUrl = FileLocator.toFileURL((URL)webAppUrl);
            result &= ZipUtil.addDirectory(zout, new Path(webAppUrl.getPath()).append("common").toFile(), (IPath)baseDir, filter);
            switch (connectionType) {
                case JTAG: {
                    result &= ZipUtil.addDirectory(zout, new Path(webAppUrl.getPath()).append("jtag").toFile(), (IPath)baseDir, filter);
                    break;
                }
                case UARTConnection: {
                    result &= ZipUtil.addDirectory(zout, new Path(webAppUrl.getPath()).append("uart").toFile(), (IPath)baseDir, filter);
                }
            }
            zout.close();
        }
        catch (Exception e) {
            GUIComposerUIPlugin.log(String.valueOf(Messages.ERROR__export_failed) + projectPath.lastSegment(), e);
            result = false;
        }
        this.responseString = result ? this.quoteText("OK") : this.quoteText(Messages.ERROR__export_failed);
    }

    private CONNECTION_TYPE getConnectionType(String connection) {
        String UARTConnectionName = CONNECTION_TYPE.UARTConnection.name();
        List setupItems = systemSetup.getListOfConnections().getComponents();
        for (SystemSetupWriter.SetupItem setupItem : setupItems) {
            String type;
            if (!setupItem.name.matches(connection) || !UARTConnectionName.equals(type = setupItem.connectionType)) continue;
            return CONNECTION_TYPE.UARTConnection;
        }
        return CONNECTION_TYPE.JTAG;
    }

    static enum CONNECTION_TYPE {
        JTAG,
        UARTConnection;

    }
}

