/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.maqetta.commands;

import com.ti.ccstudio.debug.launch.CCSLaunchConfigWorkingCopy;
import com.ti.ccstudio.debug.service.contexts.ApplicationDMContext;
import com.ti.ccstudio.debug.service.contexts.ThreadDMContext;
import com.ti.ccstudio.debug.ui.DebugUIUtils;
import com.ti.ccstudio.gui.composer.internal.maqetta.commands.AbstractCommand;
import com.ti.ccstudio.system.setup.HardwareDbException;
import com.ti.ccstudio.system.setup.SystemSetupEditor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.davinci.server.user.IUser;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GetDebugSessionInfo
extends AbstractCommand {
    @Override
    public void doHandleCommand(HttpServletRequest req, IUser user) throws IOException {
        String currentConnection = null;
        String currentBoardOrDevice = null;
        String programLoaded = null;
        ThreadDMContext threadContext = DebugUIUtils.getActiveDebugThreadDMContext();
        if (threadContext != null) {
            ApplicationDMContext appDmc;
            if (threadContext.getUser().isProgramLoaded()) {
                programLoaded = threadContext.getModulesDMContext().getMRUProgram();
            }
            if ((appDmc = (ApplicationDMContext)DMContexts.getAncestorOfType((IDMContext)threadContext, ApplicationDMContext.class)) != null) {
                ILaunchConfiguration launchCfg = appDmc.getLaunch().getLaunchConfiguration();
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = launchCfg.getWorkingCopy();
                    CCSLaunchConfigWorkingCopy launchConfigCopy = new CCSLaunchConfigWorkingCopy(workingCopy);
                    String targetConfigFile = launchConfigCopy.getTargetConfigFile();
                    FileInputStream xmlInput = new FileInputStream(targetConfigFile);
                    systemSetup.load((InputStream)xmlInput, targetConfigFile);
                    ArrayList basicProperties = systemSetup.getBasicProperties();
                    if (basicProperties.size() >= 2) {
                        currentConnection = systemSetup.getProperty(((SystemSetupEditor.AbstractProperty)basicProperties.get((int)0)).id).toString();
                        currentBoardOrDevice = systemSetup.getProperty(((SystemSetupEditor.AbstractProperty)basicProperties.get((int)1)).id).toString();
                    }
                }
                catch (CoreException coreException) {
                }
                catch (HardwareDbException hardwareDbException) {}
            }
        }
        this.responseString = "{";
        if (currentConnection != null) {
            this.responseString = String.valueOf(this.responseString) + "connection: '" + currentConnection + "'";
        }
        if (currentBoardOrDevice != null) {
            if (this.responseString.length() > 1) {
                this.responseString = String.valueOf(this.responseString) + ", ";
            }
            this.responseString = String.valueOf(this.responseString) + "device: '" + currentBoardOrDevice + "'";
        }
        if (programLoaded != null) {
            if (this.responseString.length() > 1) {
                this.responseString = String.valueOf(this.responseString) + ", ";
            }
            this.responseString = String.valueOf(this.responseString) + "program: '" + new Path(programLoaded).toString() + "'";
        }
        this.responseString = String.valueOf(this.responseString) + "}";
    }
}

