/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.maqetta.commands;

import com.ti.ccstudio.gui.composer.internal.maqetta.commands.AbstractCommand;
import com.ti.ccstudio.system.setup.SystemSetupWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.IPath;

public class GetProjectDevices
extends AbstractCommand {
    @Override
    public void doHandleCommand(IPath projectPath, HttpServletRequest req, IUser user) throws IOException {
        ArrayList devicesAndBoards = new ArrayList(30);
        String connectionType = null;
        String connectionName = req.getParameter("connection");
        if (connectionName != null) {
            connectionType = GetProjectDevices.getConnectionType(connectionName);
            devicesAndBoards = systemSetup.getBoardsAndDevices(null, connectionType, connectionName);
        } else {
            devicesAndBoards.addAll(systemSetup.getListOfBoards().getComponents());
            devicesAndBoards.addAll(systemSetup.getListOfDevices().getComponents());
            devicesAndBoards.addAll(systemSetup.getListOfConfigurations().getComponents());
        }
        this.responseString = "{devices: [";
        for (SystemSetupWriter.SetupItem item : devicesAndBoards) {
            this.responseString = String.valueOf(this.responseString) + this.quoteText(this.escapeString(item.name)) + ",";
        }
        String selection = (String)this.getProjectPreference(projectPath, "device");
        if ((selection == null || selection.isEmpty()) && devicesAndBoards.size() > 0) {
            selection = ((SystemSetupWriter.SetupItem)devicesAndBoards.get((int)0)).name;
        }
        this.responseString = String.valueOf(this.responseString) + "], selection: '" + this.escapeString(selection) + "'}";
    }

    static String getConnectionType(String connection) {
        List setupItems = systemSetup.getListOfConnections().getComponents();
        for (SystemSetupWriter.SetupItem setupItem : setupItems) {
            if (!setupItem.name.equals(connection)) continue;
            return setupItem.connectionType;
        }
        return null;
    }
}

