/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.maqetta.commands;

import com.ti.ccstudio.gui.composer.internal.maqetta.commands.AbstractCommand;
import com.ti.ccstudio.gui.composer.internal.ui.FileUtil;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.VersionUtil;
import com.ti.ccstudio.gui.composer.internal.ui.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ImportProject
extends AbstractCommand {
    private static ZipUtil.IZipFilter filter;
    private static String LINE_SEPARATOR;

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        filter = new ZipUtil.IZipFilter(){

            @Override
            public boolean accept(File fileOrDir) {
                String name = fileOrDir.getName();
                return !name.equalsIgnoreCase("index.html") && !name.equalsIgnoreCase("appProgram.out") && !name.equalsIgnoreCase("launcher.exe");
            }
        };
    }

    @Override
    protected void doHandleCommand(IPath projectPath, HttpServletRequest req, IUser user) throws IOException {
        String projectName;
        String zipFolder;
        String path = req.getParameter("path");
        File zipFile = new File(path);
        boolean upgradeRequired = VersionUtil.isUpgradeRequired(zipFile);
        if (upgradeRequired) {
            final boolean[] answer = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    answer[0] = MessageDialog.openQuestion((Shell)shell, (String)"WARNING: Project Upgrade Required", (String)"GUI Composer has detected your project is using an older library.\nIt is required to upgrade to the latest version, do you want to continue?");
                }
            });
            if (!answer[0]) {
                return;
            }
        }
        Path tempDir = new Path(String.valueOf(ZipUtil.TEMP_DIR) + "/.gc_import");
        FileUtil.delete(tempDir.toFile());
        boolean copied = false;
        ZipUtil.unzip(zipFile, (IPath)tempDir, filter);
        File[] files = tempDir.toFile().listFiles();
        if (files != null && files.length == 1 && (zipFolder = files[0].getName()).equals(projectName = projectPath.lastSegment())) {
            FileUtil.copyDirectory(tempDir.append(zipFolder).toFile(), projectPath.toFile());
            copied = true;
        }
        if (!copied) {
            FileUtil.copyDirectory(tempDir.toFile(), projectPath.toFile());
        }
        if (upgradeRequired) {
            this.ensureProjectIsLatest(projectPath);
        }
        user.rebuildWorkspace();
        this.responseString = "OK";
    }

    private void ensureProjectIsLatest(IPath projectPath) {
        try {
            int length;
            File outfile;
            Bundle bundle = GUIComposerUIPlugin.getDefault().getBundle();
            URL libsSettingsURL = bundle.getEntry("MaqettaProjectSettingFiles/libs.settings");
            libsSettingsURL = FileLocator.toFileURL((URL)libsSettingsURL);
            Path libsSettingsPath = new Path(libsSettingsURL.getPath());
            FileInputStream in = new FileInputStream(libsSettingsPath.toFile());
            IPath folderPath = projectPath.append(".settings");
            if (!folderPath.toFile().exists()) {
                folderPath.toFile().mkdirs();
            }
            if ((outfile = folderPath.append("libs.settings").toFile()).exists()) {
                outfile.delete();
            }
            outfile.createNewFile();
            FileOutputStream out = new FileOutputStream(outfile);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            GUIComposerUIPlugin.log(e);
        }
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("html");
        List<File> htmlFiles = VersionUtil.getFiles(projectPath.toFile(), null, extensions);
        for (File htmlFile : htmlFiles) {
            try {
                String line;
                BufferedReader rd = new BufferedReader(new FileReader(htmlFile));
                String content = "";
                while ((line = rd.readLine()) != null) {
                    content = String.valueOf(content) + VersionUtil.convertLine(line) + LINE_SEPARATOR;
                }
                rd.close();
                BufferedWriter wr = new BufferedWriter(new FileWriter(htmlFile));
                wr.write(content);
                wr.close();
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
    }
}

