/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.MaqettaLoader;
import com.ti.ccstudio.lerm.base.IRegContextExt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BindingManager {
    public static BindingManager INSTANCE = new BindingManager();
    private static final String KEY__WIDGET_BINDINGS = "widgetBindings";
    private static final String KEY__WIDGET_ID = "widgetId";
    private static final String KEY__WIDGET_PROPERTY = "propertyName";
    private static final String KEY__SERVER_BIND_NAME = "serverBindName";
    private static final String KEY__OPTIONS = "options";
    private Map<File, JSONObject> jsonFileCache = new HashMap<File, JSONObject>();
    private final String UPDATE_TRIGGER_BINDING_PROP = "updateTrigger";
    private final String UPDATE_TRIGGER_BINDING = "$refresh_id";
    private final String SCALAR_LINE_GRAPH = "gc.dijit.ScalarLineGraph";

    private BindingManager() {
    }

    public void bindProperty(String htmlFile, String widgetId, String widgetType, String widgetProperty, String jsonOptionsString) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        try {
            JSONObject widgetBindingJson = this.getJSONObject(jsonFile);
            JSONObject optionsJson = jsonOptionsString != null ? new JSONObject(jsonOptionsString) : new JSONObject();
            this.setWidgetBinding(widgetBindingJson, widgetId, widgetProperty, optionsJson);
            if ("gc.dijit.ScalarLineGraph".equals(widgetType)) {
                JSONObject myOption = new JSONObject();
                myOption.put("dataType", (Object)"String");
                myOption.put(KEY__SERVER_BIND_NAME, (Object)"$refresh_id");
                this.setWidgetBinding(widgetBindingJson, widgetId, "updateTrigger", myOption);
            }
            this.saveJSONObject(jsonFile, widgetBindingJson);
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
    }

    public void unbindProperty(String htmlFile, String widgetId, String widgetType, String widgetProperty, String jsonOptionsString) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        try {
            JSONObject widgetBindingJson = this.getJSONObject(jsonFile);
            JSONObject optionsJson = jsonOptionsString != null ? new JSONObject(jsonOptionsString) : new JSONObject();
            this.unsetWidgetBinding(widgetBindingJson, widgetId, widgetProperty, optionsJson);
            this.saveJSONObject(jsonFile, widgetBindingJson);
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
    }

    public String getBindingJsonString(String htmlFile) {
        try {
            File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
            return this.getJSONObject(jsonFile).toString();
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
            return null;
        }
    }

    public String getPropertyBinding(String htmlFile, String widgetId, String widgetProperty) {
        String value = "";
        try {
            File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
            JSONObject widgetBindingJson = this.getJSONObject(jsonFile);
            value = this.getWidgetPropertyValue(widgetBindingJson, widgetId, widgetProperty);
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
        return value;
    }

    public boolean createBindingFile(String htmlFile) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        try {
            JSONObject json = new JSONObject();
            JSONArray array = new JSONArray();
            json.put(KEY__WIDGET_BINDINGS, (Object)array);
            this.saveJSONObject(jsonFile, json);
            return true;
        }
        catch (Exception e) {
            GUIComposerUIPlugin.log(e);
            return false;
        }
    }

    public boolean deleteBindingFile(String htmlFile) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        if (jsonFile != null) {
            this.jsonFileCache.remove(jsonFile);
            jsonFile.delete();
            return true;
        }
        return false;
    }

    public boolean deleteAllBindingFromProject(String project) {
        Object[] keys;
        IPath projFolder = MaqettaLoader.getMaqettaWorkspacePath().append(project);
        Object[] objectArray = keys = this.jsonFileCache.keySet().toArray();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            File file = (File)key;
            if (projFolder.isPrefixOf((IPath)new Path(file.getPath()))) {
                this.jsonFileCache.remove(key);
                file.delete();
            }
            ++n2;
        }
        return true;
    }

    public void removeAllWidgetBindings(String htmlFile, String widgetId) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        try {
            JSONObject widgetBindingJson = this.getJSONObject(jsonFile);
            this.removeWidgetBindings(widgetBindingJson, widgetId);
            this.saveJSONObject(jsonFile, widgetBindingJson);
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
    }

    public void rebaseAllWidgetBindings(String htmlFile, String newWidgetId, String oldWidgetId) {
        File jsonFile = this.getJSONFileFromHTMLFile(htmlFile);
        try {
            JSONObject widgetBindingJson = this.getJSONObject(jsonFile);
            JSONArray widgetBindings = widgetBindingJson.getJSONArray(KEY__WIDGET_BINDINGS);
            int i = 0;
            while (i < widgetBindings.length()) {
                JSONObject widgetBinding = widgetBindings.getJSONObject(i);
                String id = widgetBinding.getString(KEY__WIDGET_ID);
                if (oldWidgetId.equals(id)) {
                    widgetBinding.put(KEY__WIDGET_ID, (Object)newWidgetId);
                }
                ++i;
            }
            this.saveJSONObject(jsonFile, widgetBindingJson);
        }
        catch (JSONException e) {
            GUIComposerUIPlugin.log(e);
        }
    }

    private String getWidgetPropertyValue(JSONObject json, String widgetId, String widgetProperty) throws JSONException {
        JSONArray widgetsJSON = json.getJSONArray(KEY__WIDGET_BINDINGS);
        if (widgetsJSON != null) {
            int length = widgetsJSON.length();
            int i = 0;
            while (i < length) {
                Object object = widgetsJSON.get(i);
                if (object instanceof JSONObject) {
                    String id = ((JSONObject)object).optString(KEY__WIDGET_ID);
                    String property = ((JSONObject)object).optString(KEY__WIDGET_PROPERTY);
                    if (widgetId.equals(id) && widgetProperty.equals(property)) {
                        return ((JSONObject)object).optString(KEY__SERVER_BIND_NAME);
                    }
                }
                ++i;
            }
        }
        return "";
    }

    private void setWidgetBinding(JSONObject json, String widgetId, String widgetProperty, JSONObject options) throws JSONException {
        JSONArray widgetsJSON = json.getJSONArray(KEY__WIDGET_BINDINGS);
        int index = 0;
        JSONObject widgetJSON = null;
        index = 0;
        while (index < widgetsJSON.length()) {
            JSONObject jsonObj;
            Object object = widgetsJSON.get(index);
            if (object instanceof JSONObject && widgetId.equals((jsonObj = (JSONObject)object).get(KEY__WIDGET_ID)) && widgetProperty.equals(jsonObj.get(KEY__WIDGET_PROPERTY))) {
                widgetJSON = jsonObj;
                break;
            }
            ++index;
        }
        if (widgetJSON == null) {
            widgetJSON = new JSONObject();
            index = widgetsJSON.length();
        }
        widgetJSON.put(KEY__WIDGET_ID, (Object)widgetId);
        widgetJSON.put(KEY__WIDGET_PROPERTY, (Object)widgetProperty);
        try {
            String serverBindName = options.getString(KEY__SERVER_BIND_NAME);
            if (serverBindName != null) {
                widgetJSON.put(KEY__SERVER_BIND_NAME, (Object)serverBindName);
                options.remove(KEY__SERVER_BIND_NAME);
            }
        }
        catch (JSONException jSONException) {}
        widgetJSON.put(KEY__OPTIONS, (Object)options);
        widgetsJSON.put(index, (Object)widgetJSON);
    }

    private void removeWidgetBindings(JSONObject json, String widgetId) throws JSONException {
        JSONArray widgetsJSON = json.getJSONArray(KEY__WIDGET_BINDINGS);
        if (widgetsJSON != null) {
            int index = 0;
            while (index < widgetsJSON.length()) {
                Object object = widgetsJSON.get(index);
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObj = (JSONObject)object;
                if (widgetId.equals(jsonObj.get(KEY__WIDGET_ID))) {
                    widgetsJSON.remove(index);
                    continue;
                }
                ++index;
            }
        }
    }

    private void unsetWidgetBinding(JSONObject json, String widgetId, String widgetProperty, JSONObject options) throws JSONException {
        JSONArray widgetsJSON = json.getJSONArray(KEY__WIDGET_BINDINGS);
        if (widgetsJSON != null) {
            int index = 0;
            while (index < widgetsJSON.length()) {
                JSONObject jsonObj;
                Object object = widgetsJSON.get(index);
                if (object instanceof JSONObject && widgetId.equals((jsonObj = (JSONObject)object).get(KEY__WIDGET_ID)) && widgetProperty.equals(jsonObj.get(KEY__WIDGET_PROPERTY))) {
                    JSONObject existingOptions;
                    try {
                        Object serverBindName = options.get(KEY__SERVER_BIND_NAME);
                        if (serverBindName != null) {
                            jsonObj.remove(KEY__SERVER_BIND_NAME);
                            options.remove(KEY__SERVER_BIND_NAME);
                        }
                    }
                    catch (JSONException jSONException) {}
                    if ((existingOptions = jsonObj.getJSONObject(KEY__OPTIONS)) != null) {
                        this.removeElements(existingOptions, options);
                    }
                    if (!jsonObj.has(KEY__SERVER_BIND_NAME) && existingOptions.length() == 0) {
                        widgetsJSON.remove(index);
                    }
                    return;
                }
                ++index;
            }
        }
    }

    private void removeElements(JSONObject baseObj, JSONObject removeObj) {
        Iterator keys = removeObj.keys();
        while (keys.hasNext()) {
            Object obj = keys.next();
            baseObj.remove(obj.toString());
        }
    }

    private JSONObject getJSONObject(File jsonFile) throws JSONException {
        JSONObject json = this.jsonFileCache.get(jsonFile);
        if (json != null) {
            return json;
        }
        if (jsonFile != null && jsonFile.exists()) {
            try {
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
                reader.close();
                json = new JSONObject(buffer.toString());
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
        if (json == null) {
            json = new JSONObject();
            JSONArray array = new JSONArray();
            json.put(KEY__WIDGET_BINDINGS, (Object)array);
        }
        this.jsonFileCache.put(jsonFile, json);
        return json;
    }

    private void saveJSONObject(File jsonFile, JSONObject json) {
        if (jsonFile != null) {
            if (jsonFile.exists()) {
                jsonFile.delete();
            }
            try {
                FileWriter writer = new FileWriter(jsonFile);
                json.write((Writer)writer);
                writer.close();
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
    }

    private File getJSONFileFromHTMLFile(String htmlFile) {
        String filename = new Path(htmlFile).removeFileExtension().addFileExtension("json").lastSegment();
        IPath folder = MaqettaLoader.getMaqettaWorkspacePath().append(htmlFile).removeLastSegments(1);
        File jsonFile = folder.append(filename).toFile();
        return jsonFile;
    }

    private String getActiveSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof TreeSelection) {
            Object element = ((TreeSelection)selection).getFirstElement();
            if (element instanceof IAdaptable) {
                IAdaptable adapter = (IAdaptable)element;
                IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)adapter.getAdapter(IExpressions.IExpressionDMContext.class);
                if (exprDmc != null) {
                    return exprDmc.getExpression();
                }
                IRegContextExt regDmc = (IRegContextExt)adapter.getAdapter(IRegContextExt.class);
                if (regDmc != null) {
                    return regDmc.getExpression();
                }
            }
            if (element instanceof IWatchExpression) {
                return ((IWatchExpression)element).getExpressionText();
            }
        }
        return null;
    }
}

