/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.common.ui.BaseTIUIPlugin;
import com.ti.gui.composer.common.GCInitData;
import com.ti.gui.composer.common.internal.GCServerInfo;
import com.ti.gui.composer.common.internal.ui.GCUIUtils;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServer;
import com.ti.gui.composer.webserver.internal.WebAppInfo;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;

public class GUIComposerUIPlugin
extends BaseTIUIPlugin {
    public static final String PLUGIN_ID = "com.ti.ccstudio.gui.composer.ui";
    private static GUIComposerUIPlugin plugin;
    public static boolean DEBUG;

    protected void singletonInit() {
        plugin = this;
        DEBUG = "true".equals(Platform.getDebugOption((String)"com.ti.ccstudio.gui.composer.ui/debug"));
        this.ensureMozillaPreferences();
    }

    protected void singletonDispose() {
        plugin = null;
    }

    private void ensureMozillaPreferences() {
        try {
            GCUIUtils.ensureMozillaPreferences();
        }
        catch (Throwable t) {
            GUIComposerUIPlugin.log(t);
        }
    }

    private String composePrefString(String key, String value) {
        return "user_pref(\"" + key + "\", \"" + value + "\");" + GCUIUtils.NEWLINE;
    }

    public static GUIComposerUIPlugin getDefault() {
        return plugin;
    }

    public static void log(String msg, Throwable t) {
        GUIComposerUIPlugin.getDefault().doLog(msg, t);
    }

    public static void log(Throwable t) {
        GUIComposerUIPlugin.getDefault().doLog(t);
    }

    public synchronized void startAppServer(final IRequestMonitor monitor) {
        GCServerInfo.getInstance().startAppServer(new IRequestMonitor(){

            public void failed(String errorMsg) {
                monitor.failed(errorMsg);
            }

            public void done(Object result) {
                GCInitData.WebAppIsnitall[] apps;
                GCInitData.WebAppIsnitall[] webAppIsnitallArray = apps = GCInitData.getInstance().getWebAppInstalls();
                int n = apps.length;
                int n2 = 0;
                while (n2 < n) {
                    GCInitData.WebAppIsnitall a = webAppIsnitallArray[n2];
                    WebAppInfo webAppInfo = new WebAppInfo(a.getFolder(), a.getName());
                    GuiComposerWebServer.getInstance().addApp(webAppInfo);
                    ++n2;
                }
                IPath previewPath = GUIComposerUIPlugin.this.getMaqettaWorkspace();
                if (previewPath != null) {
                    WebAppInfo webAppInfo = new WebAppInfo(previewPath.toOSString(), GUIComposerUIPlugin.this.getMaqettaPreviewContext());
                    GuiComposerWebServer.getInstance().addApp(webAppInfo);
                }
                monitor.done(null);
            }
        });
    }

    public String getPreviewURL(String filePath) {
        if (!GCServerInfo.getInstance().hasPort()) {
            return null;
        }
        String port = new Integer(GCServerInfo.getInstance().getPort()).toString();
        String gc = GCServerInfo.getInstance().getContextName();
        String preview = this.getMaqettaPreviewContext();
        return "http://127.0.0.1:" + port + "/" + gc + "/" + preview + "/" + filePath;
    }

    public IPath getMaqettaWorkspace() {
        Path ws = null;
        String wsOverride = System.getProperty("GUIComposerWS");
        if (wsOverride != null) {
            ws = new Path(wsOverride);
        }
        if (ws == null) {
            try {
                String MAQETTA_WORKSAPCE = ".GUIComposerWS";
                Location userLoc = Platform.getInstanceLocation();
                ws = new Path(FileLocator.toFileURL((URL)userLoc.getURL()).getPath()).append(MAQETTA_WORKSAPCE);
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
        return ws;
    }

    private String getMaqettaPreviewContext() {
        return "maqetta_preview";
    }

    public static BundleContext getBundleContext() {
        if (plugin == null) {
            return null;
        }
        return plugin.getBundle().getBundleContext();
    }
}

