/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.gui.composer.common.internal.GCUtils;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class MaqettaLoader {
    private static MaqettaLoader INSTANCE;
    private static final int serverPingTimeout;
    private static final IPath maqettaWorkspacePath;
    private static boolean started;
    private static String host;
    private static Integer port;
    private static String url;

    static {
        String timeout = System.getProperty("MaqettaServerPingTimeout");
        serverPingTimeout = timeout != null ? Integer.parseInt(timeout) : 30000;
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.StdErrLog");
        MaqettaLoader.loadMaqettaBundles();
        maqettaWorkspacePath = GUIComposerUIPlugin.getDefault().getMaqettaWorkspace();
        if (maqettaWorkspacePath == null) {
            GUIComposerUIPlugin.log("Can not created default Maqetta workspace", null);
        } else {
            File workspaceDir = maqettaWorkspacePath.toFile();
            if (!workspaceDir.exists()) {
                workspaceDir.mkdirs();
            }
            System.setProperty("maqetta.baseDirectory", maqettaWorkspacePath.toOSString());
            System.setProperty("loginUrl", "/maqetta/welcome");
            System.setProperty("maqetta.cacheLevel", "0");
            System.setProperty("maqetta.localInstall", "true");
            try {
                Bundle bundle = GUIComposerUIPlugin.getDefault().getBundle();
                URL url = bundle.getEntry("MaqettaConfigFiles");
                url = FileLocator.toFileURL((URL)url);
                Path path = new Path(url.getPath());
                System.setProperty("orion.core.configFile", path.append("maqetta.conf").toPortableString());
                System.setProperty("maqetta.siteConfigDirectory", path.append("siteConfig").toPortableString());
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
        }
    }

    public static MaqettaLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MaqettaLoader();
        }
        return INSTANCE;
    }

    public static IPath getMaqettaWorkspacePath() {
        return maqettaWorkspacePath;
    }

    public static String getMaqettaURL() {
        return url;
    }

    public synchronized void init(final IRequestMonitor monitor) {
        if (!started) {
            new Job("Pinging Maqetta Server"){

                protected IStatus run(IProgressMonitor progress) {
                    boolean responded = false;
                    long start = System.currentTimeMillis();
                    do {
                        if (host != null && port != null) {
                            responded = GCUtils.ping((String)host, (int)port);
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } while (!responded && System.currentTimeMillis() - start < (long)serverPingTimeout);
                    if (responded) {
                        monitor.done(null);
                    } else {
                        monitor.failed("Maqetta server not responding");
                    }
                    started = true;
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            monitor.done(null);
        }
    }

    private static void loadMaqettaBundles() {
        new Job("Maqetta Bundler Loader"){
            {
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor progress) {
                try {
                    Platform.getBundle((String)"javax.servlet").start(1);
                    Platform.getBundle((String)"maqetta.core.server").start(1);
                    Platform.getBundle((String)"maqetta.core.server.standalone").start(1);
                    Platform.getBundle((String)"maqetta.core.client").start(1);
                    Platform.getBundle((String)"org.apache.commons.io").start(1);
                    Platform.getBundle((String)"org.apache.commons.fileupload").start(1);
                    Platform.getBundle((String)"org.eclipse.core.runtime").start(1);
                    Platform.getBundle((String)"org.eclipse.core.contenttype").start(1);
                    Platform.getBundle((String)"org.eclipse.core.jobs").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.common").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.app").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.http.jetty").start();
                    Platform.getBundle((String)"org.eclipse.equinox.http.registry").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.http.servlet").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.preferences").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.registry").start(1);
                    Platform.getBundle((String)"org.eclipse.equinox.security").start(1);
                    Platform.getBundle((String)"org.eclipse.osgi.services").start(1);
                    Platform.getBundle((String)"org.eclipse.jetty.server").start(1);
                    port = Integer.parseInt(System.getProperty("org.eclipse.equinox.http.jetty.http.port"));
                    host = System.getProperty("org.eclipse.equinox.http.jetty.http.host");
                    url = "http://" + host + ":" + port + "/maqetta";
                    System.out.println("Maqetta server started: " + url);
                }
                catch (BundleException e) {
                    GUIComposerUIPlugin.log("Failed to load Maqetta bundles.", e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

