/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.ccstudio.gui.composer.internal.ui.FileUtil;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.gui.composer.common.GCInitData;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RemoveWebAppDialog
extends Dialog {
    private final String READ_ONLY_FOLDER = "ccs_eclipse";
    private Table table;

    public RemoveWebAppDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Remove GUI Composer\u2122 Application");
        newShell.setSize(500, 300);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        GCInitData.WebAppIsnitall[] webApps;
        Composite control = (Composite)super.createDialogArea(parent);
        Label label = new Label(control, 0);
        label.setText("Installed &Applications:");
        this.table = new Table(control, 68384);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object data;
                if (event.detail == 32 && (data = event.item.getData()) instanceof MetaData && ((MetaData)data).folder.toString().contains("ccs_eclipse")) {
                    event.detail = 0;
                    event.type = 0;
                    event.doit = false;
                    try {
                        RemoveWebAppDialog.this.table.setRedraw(false);
                        TableItem item = (TableItem)event.item;
                        item.setChecked(!item.getChecked());
                    }
                    finally {
                        RemoveWebAppDialog.this.table.setRedraw(true);
                    }
                }
            }
        });
        GCInitData.WebAppIsnitall[] webAppIsnitallArray = webApps = GCInitData.getInstance().getWebAppInstalls();
        int n = webApps.length;
        int n2 = 0;
        while (n2 < n) {
            GCInitData.WebAppIsnitall webApp = webAppIsnitallArray[n2];
            try {
                File[] folders;
                File webAppFolder = new File(webApp.getFolder());
                File[] fileArray = folders = webAppFolder.listFiles();
                int n3 = folders.length;
                int n4 = 0;
                while (n4 < n3) {
                    File folder = fileArray[n4];
                    if (folder.isDirectory()) {
                        TableItem item = new TableItem(this.table, 0);
                        item.setText(folder.getName());
                        item.setData((Object)new MetaData(webApp, folder));
                        if (folder.toString().contains("ccs_eclipse")) {
                            item.setForeground(Display.getDefault().getSystemColor(33));
                        }
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                GUIComposerUIPlugin.log(e);
            }
            ++n2;
        }
        return control;
    }

    protected void okPressed() {
        if (this.table != null) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.table.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    MetaData data = (MetaData)item.getData();
                    this.closeOpenedViews(data);
                    FileUtil.delete(data.folder);
                }
                ++n2;
            }
        }
        super.okPressed();
    }

    private void closeOpenedViews(MetaData metaData) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            IViewReference viewRef = page.findViewReference("com.ti.ccstudio.gui.composer.ui.applicationBrowserViewPart", String.valueOf(metaData.webApp.getName()) + "/" + metaData.folder.getName());
            if (viewRef != null) {
                page.hideView(viewRef);
            }
            ++n2;
        }
    }

    private class MetaData {
        GCInitData.WebAppIsnitall webApp;
        File folder;

        MetaData(GCInitData.WebAppIsnitall webApp, File folder) {
            this.webApp = webApp;
            this.folder = folder;
        }
    }
}

