/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.ccstudio.gui.composer.internal.ui.FileUtil;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.ZipUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class VersionUtil {
    private static String PLUGIN_QUALIFIER = GUIComposerUIPlugin.getDefault().getBundle().getVersion().getQualifier();
    private static String BOOT_FILE = "app.html";
    private static String RUNTIME_TAG = "data-gc-version=";
    private static String RUNTIME_VERSION = "1.5";
    private static String DAVINCI_GC_TAG = "davinci.gc";
    private static String DAVINCI_GC_VERSION = "_1_5";

    public static List<File> getFiles(File directory, Set<String> filenames, Set<String> extensions) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    results.addAll(VersionUtil.getFiles(file, filenames, extensions));
                } else {
                    int index;
                    String extension;
                    String filename = file.getName().toLowerCase();
                    if (filenames != null) {
                        if (filenames.contains(filename)) {
                            results.add(file);
                        }
                    } else if (extensions != null && extensions.contains(extension = filename.substring((index = filename.lastIndexOf(".")) + 1))) {
                        results.add(file);
                    }
                }
                ++n2;
            }
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUpgradeRequired(File zipFile) {
        Path tempDir = new Path(String.valueOf(ZipUtil.TEMP_DIR) + "/.gc_version");
        FileUtil.delete(tempDir.toFile());
        ZipUtil.unzip(zipFile, (IPath)tempDir, new ZipUtil.IZipFilter(){

            @Override
            public boolean accept(File fileOrDir) {
                return fileOrDir.getName().equalsIgnoreCase(BOOT_FILE);
            }
        });
        HashSet<String> filenames = new HashSet<String>();
        filenames.add(BOOT_FILE);
        List<File> files = VersionUtil.getFiles(tempDir.toFile(), filenames, null);
        if (files.size() <= 0) return false;
        try {
            BufferedReader rd = new BufferedReader(new FileReader(files.get(0)));
            try {
                String line;
                do {
                    if ((line = rd.readLine()) != null) continue;
                    return false;
                } while (!(line.contains(DAVINCI_GC_TAG) ? !line.contains(String.valueOf(DAVINCI_GC_TAG) + DAVINCI_GC_VERSION) : line.contains(RUNTIME_TAG) && !line.contains(String.valueOf(RUNTIME_TAG) + "\"" + RUNTIME_VERSION)));
                return true;
            }
            finally {
                rd.close();
            }
        }
        catch (Exception e) {
            GUIComposerUIPlugin.log(e);
        }
        return false;
    }

    public static String convertLine(String line) {
        if (line.contains(DAVINCI_GC_TAG)) {
            return line.replaceAll(String.valueOf(DAVINCI_GC_TAG) + "_._.", String.valueOf(DAVINCI_GC_TAG) + DAVINCI_GC_VERSION);
        }
        if (line.contains(RUNTIME_TAG)) {
            return line.replaceAll(String.valueOf(RUNTIME_TAG) + "\\\".*\\\"", String.valueOf(RUNTIME_TAG) + "\"" + RUNTIME_VERSION + "." + PLUGIN_QUALIFIER + "\"");
        }
        return line;
    }
}

