/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui;

import com.ti.ccstudio.gui.composer.internal.ui.FileUtil;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ZipUtil {
    public static String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static String FILE_SEPARATOR = System.getProperty("file.separator");

    public static boolean addFile(ZipOutputStream zout, File file, IPath path, IZipFilter filter) {
        if (file != null && filter != null && !filter.accept(file)) {
            return true;
        }
        try {
            zout.putNextEntry(new ZipEntry(path.toOSString()));
            if (file != null) {
                int length;
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(file);
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                fin.close();
            }
            zout.closeEntry();
            return true;
        }
        catch (IOException ioe) {
            if (!ioe.getMessage().contains("duplicate entry")) {
                GUIComposerUIPlugin.log(ioe);
                return false;
            }
            return true;
        }
    }

    public static boolean addDirectory(ZipOutputStream zout, File dir, IPath baseDir, IZipFilter filter) {
        boolean result = true;
        File[] files = dir.listFiles();
        if (files.length > 0) {
            int i = 0;
            while (i < files.length) {
                IPath newBaseDir = baseDir.append(files[i].getName());
                result = files[i].isDirectory() ? (result &= ZipUtil.addDirectory(zout, files[i], newBaseDir, filter)) : (result &= ZipUtil.addFile(zout, files[i], newBaseDir, filter));
                ++i;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCustomProject(File zipFile) {
        try {
            BufferedReader reader;
            ZipFile zFile = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            block2: while (true) {
                String line;
                if (!entries.hasMoreElements()) {
                    return false;
                }
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(FileUtil.PROJECT_SETTINGS_FILENAME)) continue;
                InputStream iStream = zFile.getInputStream(entry);
                reader = new BufferedReader(new InputStreamReader(iStream));
                do {
                    if ((line = reader.readLine()) != null) continue;
                    reader.close();
                    continue block2;
                } while (!FileUtil.isCustomWizard(line));
                break;
            }
            reader.close();
            return true;
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean unzip(File zipFile, IPath destionationPath, IZipFilter filter) {
        boolean result = true;
        boolean ignoreFilter = false;
        try {
            if (ZipUtil.isCustomProject(zipFile)) {
                ignoreFilter = true;
            }
            ZipFile zFile = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements() && result) {
                int len;
                File destDir;
                ZipEntry entry = entries.nextElement();
                File file = destionationPath.append(entry.getName()).toFile();
                if (!ignoreFilter && filter != null && !filter.accept(file)) continue;
                if (entry.isDirectory() || entry.getName().endsWith(FILE_SEPARATOR)) {
                    result &= file.mkdirs();
                    continue;
                }
                if (file.isDirectory()) {
                    result &= file.mkdirs();
                    continue;
                }
                IPath dirPath = new Path(file.getPath()).removeLastSegments(1);
                File dirs = dirPath.toFile();
                if (!dirs.exists()) {
                    result &= dirs.mkdirs();
                }
                if (!(destDir = destionationPath.toFile()).exists()) {
                    result &= destDir.mkdirs();
                }
                InputStream iStream = zFile.getInputStream(entry);
                BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[1024];
                while ((len = iStream.read(buffer)) >= 0) {
                    oStream.write(buffer, 0, len);
                }
                iStream.close();
                oStream.close();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return result;
    }

    public static interface IZipFilter {
        public boolean accept(File var1);
    }
}

