/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui.browser;

import com.ti.browser.ITIBrowser;
import com.ti.browser.TIBrowserFactory;
import com.ti.browser.internal.TIBrowserPlugin;
import com.ti.ccstudio.debug.ui.launch.CCSLauncher;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.Messages;
import com.ti.ccstudio.gui.composer.internal.ui.browser.ApplicationBrowserEditorInput;
import com.ti.ccstudio.gui.composer.internal.ui.browser.BrowserUtils;
import com.ti.gui.composer.common.internal.GCAppStartupReturnInfo;
import com.ti.gui.composer.common.internal.GCServerInfo;
import com.ti.gui.composer.common.internal.WebContent;
import com.ti.gui.composer.common.internal.ui.GCCommonUIPlugin;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ApplicationBrowserEditorPart
extends EditorPart {
    public static String ID = "com.ti.ccstudio.gui.composer.editor.applicationBrowser";
    private ITIBrowser browser;
    private GCAppStartupReturnInfo appHandle;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof ApplicationBrowserEditorInput) {
            String appName = ((ApplicationBrowserEditorInput)input).appName;
            this.setPartName(appName);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ApplicationBrowserEditorInput) {
            if (!TIBrowserPlugin.hasChromeBrowserPlugin() && !GCCommonUIPlugin.isXULRunnerAvaliable()) {
                this.browser = TIBrowserFactory.createBrowser((Composite)parent);
                String errorURI = WebContent.getInstance().getXULRunnerErrorURI();
                this.browser.setUrl(errorURI);
            } else {
                this.browser = TIBrowserFactory.createBrowser((Composite)parent);
                ApplicationBrowserEditorInput input = (ApplicationBrowserEditorInput)editorInput;
                this.browser.setUrl(WebContent.getInstance().getProgressURI("Loading Application..."));
                this.startWebApp(this.browser, input.url);
                if (System.getProperty("allowRemoteConnections") != null) {
                    this.browser.addContextMenu(42, Messages.COPY_URL_TO_CLIPBOARD, BrowserUtils.getCopyMenu());
                }
            }
        }
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void dispose() {
        if (this.browser != null) {
            this.browser.dispose();
        }
        super.dispose();
        if (this.appHandle != null) {
            CCSLauncher.terminateScriptBased();
            GCServerInfo.getInstance().removeFolder(this.appHandle);
        }
    }

    private void startWebApp(final ITIBrowser browser, String url) {
        try {
            browser.setUrl(WebContent.getInstance().getProgressURI("Loading Application..."));
            GCServerInfo.getInstance().addFolder(url, "TiRex", true, new IRequestMonitor(){

                public void failed(final String errorMsg) {
                    browser.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errorURI = WebContent.getInstance().getErrorURI(errorMsg);
                            browser.setUrl(errorURI);
                        }
                    });
                }

                public void done(final Object result) {
                    browser.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationBrowserEditorPart.this.appHandle = (GCAppStartupReturnInfo)result;
                            browser.setUrl(ApplicationBrowserEditorPart.this.appHandle.getURI());
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            GUIComposerUIPlugin.log(e);
        }
    }
}

