/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui.browser;

import com.ti.browser.ITIBrowser;
import com.ti.browser.TIBrowserFactory;
import com.ti.browser.internal.TIBrowserPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.Messages;
import com.ti.ccstudio.gui.composer.internal.ui.browser.BrowserUtils;
import com.ti.gui.composer.common.internal.GCServerInfo;
import com.ti.gui.composer.common.internal.WebContent;
import com.ti.gui.composer.common.internal.ui.GCCommonUIPlugin;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class ApplicationBrowserViewPart
extends ViewPart {
    public static final String VIEW_ID = "com.ti.ccstudio.gui.composer.ui.applicationBrowserViewPart";
    private ITIBrowser fBrowser;

    public void createPartControl(final Composite parent) {
        if (!TIBrowserPlugin.hasChromeBrowserPlugin() && !GCCommonUIPlugin.isXULRunnerAvaliable()) {
            ITIBrowser browser = TIBrowserFactory.createBrowser((Composite)parent);
            String errorURI = WebContent.getInstance().getXULRunnerErrorURI();
            browser.setUrl(errorURI);
        } else {
            this.fBrowser = TIBrowserFactory.createBrowser((Composite)parent);
            String uniqueName = ((IViewSite)this.getSite()).getSecondaryId();
            int separator = uniqueName.lastIndexOf("/");
            String appName = uniqueName;
            String appInstall = "webapp0";
            if (separator != -1) {
                appInstall = uniqueName.substring(0, separator);
                appName = uniqueName.substring(separator + 1);
            }
            final String appNameFinal = appName;
            final String appInstallFinal = appInstall;
            if (appNameFinal != null && appInstallFinal != null) {
                this.setPartName(appNameFinal);
                this.fBrowser.setUrl(WebContent.getInstance().getProgressURI("Loading Application..."));
                GUIComposerUIPlugin.getDefault().startAppServer(new IRequestMonitor(){

                    public void done(Object result) {
                        parent.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                int port = GCServerInfo.getInstance().getPort();
                                String url = "http://127.0.0.1:" + port + "/gc/" + appInstallFinal + "/" + appNameFinal + "/app.html";
                                ApplicationBrowserViewPart.this.fBrowser.setUrl(url);
                            }
                        });
                    }

                    public void failed(String errorMsg) {
                        String errorURI = WebContent.getInstance().getErrorURI(errorMsg);
                        ApplicationBrowserViewPart.this.fBrowser.setUrl(errorURI);
                    }
                });
                if (System.getProperty("allowRemoteConnections") != null) {
                    this.fBrowser.addContextMenu(42, Messages.COPY_URL_TO_CLIPBOARD, BrowserUtils.getCopyMenu());
                }
            }
        }
    }

    public void dispose() {
        if (this.fBrowser != null) {
            this.fBrowser.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        if (this.fBrowser != null) {
            this.fBrowser.setFocus();
        }
    }

    public ITIBrowser getBrowser() {
        return this.fBrowser;
    }
}

