/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui.browser;

import com.ti.browser.ITIBrowser;
import com.ti.browser.ITIBrowserDisposeListener;
import com.ti.browser.ITIBrowserFunction;
import com.ti.ccstudio.gui.composer.internal.ui.BindingManager;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.MaqettaLoader;
import com.ti.ccstudio.gui.composer.internal.ui.browser.BFGetAvailableBindProperties;
import com.ti.ccstudio.gui.composer.internal.ui.browser.FileMonitor;
import com.ti.ccstudio.gui.composer.internal.ui.browser.IDesignerBrowserCallback;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;

public class DesignerBrowserFunctions {
    private IDesignerBrowserCallback callback;
    Set<FileMonitorMetaData> metaData = new HashSet<FileMonitorMetaData>();
    private ITIBrowser browser;

    public DesignerBrowserFunctions(ITIBrowser browser, IDesignerBrowserCallback callback) {
        this.browser = browser;
        this.callback = callback;
        this.addHook_isInDesignMode();
        this.addHook_showDesignMode();
        this.addHook_showPreviewMode();
        this.addHook_getPropertyBinding();
        this.addHook_bindProperty();
        this.addHook_unbindProperty();
        this.addHook_getBindingJsonString();
        this.addHook_onWidgetRemoved();
        this.addHook_onResourceChanged();
        this.addHook_deleteAllBindingFromProject();
        this.addHook_getAvailableBindProperties();
        this.addHook_openJSEditor();
        this.addHook_appendToFile();
        this.addHook_registerFileMonitor();
        this.addHook_unregisterFileMonitor();
        this.addHook_rebaseWidget();
    }

    private void addHook_showDesignMode() {
        this.browser.addFunction("$TI_showDesignMode", 0, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 0) {
                    DesignerBrowserFunctions.this.callback.designMode();
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_showPreviewMode() {
        this.browser.addFunction("$TI_showPreviewMode", 1, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 1) {
                    String url = (String)arguments[0];
                    String prefix = "/maqetta/user/maqettaUser/ws/workspace";
                    int previeIndex = url.lastIndexOf(prefix);
                    if (previeIndex == -1) {
                        return false;
                    }
                    int infoIndex = previeIndex + prefix.length() + 1;
                    String info = url.substring(infoIndex);
                    url = GUIComposerUIPlugin.getDefault().getPreviewURL(info);
                    if (url == null) {
                        return false;
                    }
                    DesignerBrowserFunctions.this.callback.previewMode(url);
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_getPropertyBinding() {
        this.browser.addFunction("$TI_getPropertyBinding", 3, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 3) {
                    return BindingManager.INSTANCE.getPropertyBinding((String)arguments[0], (String)arguments[1], (String)arguments[2]);
                }
                return "";
            }
        });
    }

    private void addHook_bindProperty() {
        this.browser.addFunction("$TI_bindProperty", 5, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 5) {
                    BindingManager.INSTANCE.bindProperty((String)arguments[0], (String)arguments[1], (String)arguments[2], (String)arguments[3], (String)arguments[4]);
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_unbindProperty() {
        this.browser.addFunction("$TI_unbindProperty", 5, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 5) {
                    BindingManager.INSTANCE.unbindProperty((String)arguments[0], (String)arguments[1], (String)arguments[2], (String)arguments[3], (String)arguments[4]);
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_getBindingJsonString() {
        this.browser.addFunction("$TI_getBindingJsonString", 1, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 1 && arguments[0] instanceof String) {
                    return BindingManager.INSTANCE.getBindingJsonString((String)arguments[0]);
                }
                return null;
            }
        });
    }

    private void addHook_onWidgetRemoved() {
        this.browser.addFunction("$TI_onWidgetRemoved", 2, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 2) {
                    BindingManager.INSTANCE.removeAllWidgetBindings((String)arguments[0], (String)arguments[1]);
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_onResourceChanged() {
        this.browser.addFunction("$TI_onResourceChanged", 2, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                String resource;
                if (arguments.length == 2 && "html".equalsIgnoreCase(new Path(resource = (String)arguments[0]).getFileExtension())) {
                    String type = (String)arguments[1];
                    if ("deleted".equals(type)) {
                        return BindingManager.INSTANCE.deleteBindingFile(resource);
                    }
                    if ("created".equals(type)) {
                        return BindingManager.INSTANCE.createBindingFile(resource);
                    }
                    "renamed".equals(type);
                }
                return false;
            }
        });
    }

    private void addHook_deleteAllBindingFromProject() {
        this.browser.addFunction("$TI_deleteAllBindingFromProject", 1, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                String resource;
                if (arguments.length == 1 && (resource = (String)arguments[0]) != null && !resource.isEmpty()) {
                    return BindingManager.INSTANCE.deleteAllBindingFromProject(resource);
                }
                return false;
            }
        });
    }

    private void addHook_isInDesignMode() {
        this.browser.addFunction("$TI_isInDesignMode", 0, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                return true;
            }
        });
    }

    private void addHook_getAvailableBindProperties() {
        this.browser.addFunction("$TI_getAvailableBindProperties", 1, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments != null && arguments.length > 0 && arguments[0] instanceof String) {
                    String widgetType = (String)arguments[0];
                    return BFGetAvailableBindProperties.get(widgetType);
                }
                return "[]";
            }
        });
    }

    private void addHook_appendToFile() {
        this.browser.addFunction("$TI_appendToFile", 2, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 2) {
                    Path path = new Path((String)arguments[0]);
                    if (!path.isAbsolute()) {
                        path = MaqettaLoader.getMaqettaWorkspacePath().append((IPath)path);
                    }
                    String text = (String)arguments[1];
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorPart[] editors;
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IEditorPart[] iEditorPartArray = editors = window.getActivePage().getDirtyEditors();
                        int n3 = editors.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            URI uri;
                            Path tmp;
                            IEditorPart editor = iEditorPartArray[n4];
                            IEditorInput input = editor.getEditorInput();
                            if (input instanceof IURIEditorInput && path.equals((Object)(tmp = new Path((uri = ((IURIEditorInput)input).getURI()).getPath())))) {
                                editor.doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    try {
                        File file = path.toFile();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
                        writer.append(text);
                        writer.close();
                    }
                    catch (Exception e) {
                        GUIComposerUIPlugin.log(e);
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_openJSEditor() {
        this.browser.addFunction("$TI_openJSEditor", 2, new ITIBrowserFunction(){

            public Object execute(final Object[] arguments) {
                if ((arguments.length == 2 || arguments.length == 1) && arguments[0] instanceof String) {
                    Display.getCurrent().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Path path = new Path((String)arguments[0]);
                            if (!path.isAbsolute()) {
                                path = MaqettaLoader.getMaqettaWorkspacePath().append((IPath)path);
                            }
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                                try {
                                    IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                                    if (arguments.length == 2 && arguments[1] instanceof Double) {
                                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                        IMarker marker = root.createMarker("org.eclipse.core.resources.textmarker");
                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                        map.put("lineNumber", ((Double)arguments[1]).intValue());
                                        map.put("location", path.toOSString());
                                        marker.setAttributes(map);
                                        IGotoMarker gotoMarker = (IGotoMarker)editorPart.getAdapter(IGotoMarker.class);
                                        if (gotoMarker != null) {
                                            gotoMarker.gotoMarker(marker);
                                        }
                                        marker.delete();
                                    }
                                }
                                catch (Exception e) {
                                    GUIComposerUIPlugin.log(e);
                                }
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_registerFileMonitor() {
        ITIBrowserDisposeListener disposeListener = new ITIBrowserDisposeListener(){

            public void onDisposing() {
                for (FileMonitorMetaData md : DesignerBrowserFunctions.this.metaData) {
                    md.dispose();
                }
            }

            public void onDisposed() {
            }
        };
        this.browser.addDisposeListener(disposeListener);
        this.browser.addFunction("$TI_registerFileMonitor", 2, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 2 && arguments[0] instanceof String && arguments[1] instanceof String) {
                    FileMonitorMetaData md2;
                    Path path = new Path((String)arguments[0]);
                    if (!path.isAbsolute()) {
                        path = MaqettaLoader.getMaqettaWorkspacePath().append((IPath)path);
                    }
                    File file = path.toFile();
                    for (FileMonitorMetaData md2 : DesignerBrowserFunctions.this.metaData) {
                        if (!md2.file.equals(file)) continue;
                        md2.dispose();
                        DesignerBrowserFunctions.this.metaData.remove(md2);
                        break;
                    }
                    md2 = new FileMonitorMetaData((String)arguments[1], (String)arguments[0], file);
                    DesignerBrowserFunctions.this.metaData.add(md2);
                }
                return true;
            }
        });
    }

    private void addHook_unregisterFileMonitor() {
        this.browser.addFunction("$TI_unregisterFileMonitor", 1, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 1 && arguments[0] instanceof String) {
                    Path path = new Path((String)arguments[0]);
                    if (!path.isAbsolute()) {
                        path = MaqettaLoader.getMaqettaWorkspacePath().append((IPath)path);
                    }
                    File file = path.toFile();
                    for (FileMonitorMetaData md : DesignerBrowserFunctions.this.metaData) {
                        if (!md.file.equals(file)) continue;
                        md.dispose();
                        DesignerBrowserFunctions.this.metaData.remove(md);
                        break;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void addHook_rebaseWidget() {
        this.browser.addFunction("$TI_rebaseWidget", 3, new ITIBrowserFunction(){

            public Object execute(Object[] arguments) {
                if (arguments.length == 3 && arguments[0] instanceof String && arguments[1] instanceof String && arguments[2] instanceof String) {
                    BindingManager.INSTANCE.rebaseAllWidgetBindings((String)arguments[0], (String)arguments[1], (String)arguments[2]);
                    return true;
                }
                return false;
            }
        });
    }

    private class FileMonitorMetaData {
        File file;
        FileMonitor.IModifiedListener listener;

        public FileMonitorMetaData(final String function, final String argument, File file) {
            this.file = file;
            this.listener = new FileMonitor.IModifiedListener(){

                @Override
                public void onModified() {
                    DesignerBrowserFunctions.this.browser.evaluate(String.valueOf(function) + "('" + argument + "')");
                }
            };
            FileMonitor.instance.addListener(this.listener, file);
        }

        void dispose() {
            FileMonitor.instance.removeListener(this.listener);
        }
    }
}

