/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui.browser;

import com.ti.browser.ITIBrowser;
import com.ti.browser.TIBrowserFactory;
import com.ti.browser.internal.TIBrowserPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.GUIComposerUIPlugin;
import com.ti.ccstudio.gui.composer.internal.ui.MaqettaLoader;
import com.ti.ccstudio.gui.composer.internal.ui.browser.DesignerBrowserFunctions;
import com.ti.ccstudio.gui.composer.internal.ui.browser.DesignerBrowserPartInput;
import com.ti.ccstudio.gui.composer.internal.ui.browser.IDesignerBrowserCallback;
import com.ti.gui.composer.common.internal.WebContent;
import com.ti.gui.composer.common.internal.ui.GCCommonUIPlugin;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.part.EditorPart;

public class DesignerBrowserPart
extends EditorPart
implements IDesignerBrowserCallback {
    private Composite parent;
    private ITIBrowser mainBrowser;
    private ITIBrowser previewBrowser;

    public void dispose() {
        if (this.mainBrowser != null) {
            this.mainBrowser.dispose();
        }
        if (this.previewBrowser != null) {
            this.previewBrowser.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        assert (input instanceof DesignerBrowserPartInput);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        String name = input.getName();
        this.setPartName(name);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite container) {
        this.parent = new Composite(container, 0);
        StackLayout layout = new StackLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.parent.setLayout((Layout)layout);
        if (!TIBrowserPlugin.hasChromeBrowserPlugin() && !GCCommonUIPlugin.isXULRunnerAvaliable()) {
            this.mainBrowser = TIBrowserFactory.createBrowser((Composite)this.parent);
            String errorURI = WebContent.getInstance().getXULRunnerErrorURI();
            this.mainBrowser.setUrl(errorURI);
            layout.topControl = this.mainBrowser.getControl();
            this.parent.layout();
            return;
        }
        this.mainBrowser = TIBrowserFactory.createBrowser((Composite)this.parent, (ITIBrowser.BrowserType)ITIBrowser.BrowserType.chrome);
        this.previewBrowser = TIBrowserFactory.createBrowser((Composite)this.parent);
        new DesignerBrowserFunctions(this.mainBrowser, this);
        new DesignerBrowserFunctions(this.previewBrowser, this);
        this.mainBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (!event.required) {
                    return;
                }
                try {
                    final Shell shell = new Shell(Display.getCurrent());
                    event.browser = new Browser((Composite)shell, 32768);
                    event.browser.addLocationListener(new LocationListener(){

                        public void changing(LocationEvent event) {
                            shell.dispose();
                            try {
                                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                                IWebBrowser browser = browserSupport.getExternalBrowser();
                                if (browser != null) {
                                    browser.openURL(new URL(event.location));
                                }
                            }
                            catch (Exception e) {
                                GUIComposerUIPlugin.log(e);
                            }
                        }

                        public void changed(LocationEvent event) {
                        }
                    });
                }
                catch (Exception e) {
                    GUIComposerUIPlugin.log(e);
                }
            }
        });
        this.mainBrowser.setUrl(WebContent.getInstance().getProgressURI("Loading GUI Composer Server..."));
        MaqettaLoader.getInstance().init(new IRequestMonitor(){

            public void done(Object result) {
                DesignerBrowserPart.this.parent.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DesignerBrowserPart.this.mainBrowser.setUrl(MaqettaLoader.getMaqettaURL());
                    }
                });
            }

            public void failed(String errorMsg) {
                WebContent.getInstance().getErrorURI(errorMsg);
            }
        });
        layout.topControl = this.mainBrowser.getControl();
        this.parent.layout();
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    @Override
    public void designMode() {
        StackLayout layout = (StackLayout)this.parent.getLayout();
        layout.topControl = this.mainBrowser.getControl();
        this.previewBrowser.setUrl("about:blank");
        this.parent.layout();
    }

    @Override
    public void previewMode(final String url) {
        StackLayout layout = (StackLayout)this.parent.getLayout();
        layout.topControl = this.previewBrowser.getControl();
        this.parent.layout();
        String progressURI = WebContent.getInstance().getProgressURI("Loading Application...");
        this.previewBrowser.setUrl(progressURI);
        GUIComposerUIPlugin.getDefault().startAppServer(new IRequestMonitor(){

            public void done(Object result) {
                DesignerBrowserPart.this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String previewURI = WebContent.getInstance().getPreviewURI(url);
                        System.out.println("Maqetta prview URL = " + previewURI);
                        DesignerBrowserPart.this.previewBrowser.setUrl(previewURI);
                    }
                });
            }

            public void failed(String errorMsg) {
                String errorURI = WebContent.getInstance().getErrorURI(errorMsg);
                DesignerBrowserPart.this.previewBrowser.setUrl(errorURI);
            }
        });
    }

    public ITIBrowser getDesignerBrowser() {
        return this.mainBrowser;
    }

    public ITIBrowser getPreviewBrowser() {
        return this.previewBrowser;
    }
}

