/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.gui.composer.internal.ui.browser;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FileMonitor {
    public static FileMonitor instance = new FileMonitor();
    private Map<IModifiedListener, MetaData> listeners = new HashMap<IModifiedListener, MetaData>();
    private Thread pollingThread;

    private FileMonitor() {
    }

    public synchronized void addListener(IModifiedListener listener, File file) {
        this.listeners.put(listener, new MetaData(file));
        if (this.pollingThread == null) {
            this.startPolling();
        }
    }

    public synchronized void removeListener(IModifiedListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.pollingThread = null;
        }
    }

    private void startPolling() {
        this.pollingThread = new Thread("Browser File Monitor"){

            @Override
            public void run() {
                while (FileMonitor.this.listeners.size() > 0) {
                    for (Map.Entry e : FileMonitor.this.listeners.entrySet()) {
                        MetaData metadata = (MetaData)e.getValue();
                        long lastModified = metadata.file.lastModified();
                        if (lastModified == metadata.lastmodified) continue;
                        metadata.lastmodified = lastModified;
                        try {
                            ((IModifiedListener)e.getKey()).onModified();
                        }
                        catch (Throwable throwable) {}
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.pollingThread.start();
    }

    public static interface IModifiedListener {
        public void onModified();
    }

    private class MetaData {
        File file;
        long lastmodified;

        MetaData(File file) {
            this.file = file;
            this.lastmodified = file.lastModified();
        }
    }
}

