/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.webserver.adapter;

import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import com.ti.gui.composer.webserver.adapter.IResourceMapperServlet;
import com.ti.gui.composer.webserver.adapter.IWebserverProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class GCServer
implements IWebserverProvider {
    private static GCServer instance;
    private IWebserverProvider provider;
    private static final String MISSIING_PLUGIN = "The Web server plugin is not activated in this install!";

    public static synchronized IWebserverProvider getInstance() {
        if (instance == null) {
            instance = new GCServer();
            instance.readExtensionPoints();
        }
        return instance;
    }

    private void readExtensionPoints() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ti.gui.composer.webserver.adapter.ServerProvider");
        if (ep == null) {
            return;
        }
        try {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IWebserverProvider) {
                        this.provider = (IWebserverProvider)obj;
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    public void addResourceMapper(IResourceMapperServlet resourceMapper, IRequestMonitor requestMonitor) {
        if (this.provider != null) {
            this.provider.addResourceMapper(resourceMapper, requestMonitor);
        } else {
            requestMonitor.failed(MISSIING_PLUGIN);
        }
    }

    public void addResourceFolder(String folder, String context, boolean autoIncrement, IRequestMonitor requestMonitor) {
        if (this.provider != null) {
            this.provider.addResourceFolder(folder, context, autoIncrement, requestMonitor);
        } else {
            requestMonitor.failed(MISSIING_PLUGIN);
        }
    }

    public void startAppServer(IRequestMonitor requestMonitor) {
        if (this.provider != null) {
            this.provider.startAppServer(requestMonitor);
        } else {
            requestMonitor.failed(MISSIING_PLUGIN);
        }
    }

    public String getCommonPagesURI(String type, Object message) {
        if (this.provider != null) {
            return this.provider.getCommonPagesURI(type, message);
        }
        return "about:blank";
    }
}

