/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IDisposable;
import com.ti.binding.program.internal.DSBaseValueBind;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ProgramModelPlugin;
import java.util.HashMap;
import java.util.Map;

public abstract class DSBaseValueBindAndBindProvider
extends DSBaseValueBind
implements IBindProvider {
    protected HashMap<String, IBind> fBinds = new HashMap();

    public DSBaseValueBindAndBindProvider(ProgramModelBase model, Object initialValue, Class<?> defaultType) {
        super(model, initialValue, defaultType);
    }

    DSBaseValueBindAndBindProvider(ProgramModelBase model) {
        super(model);
    }

    public IBind getBinding(String uri) {
        IBind bind = this.fBinds.get(uri);
        if (bind == null) {
            bind = this.createNewBind(uri);
            if (ProgramModelPlugin.DEBUG) {
                ProgramModelPlugin.debug(String.valueOf(this.getTraceName()) + ".createNewBind(" + uri + ")=" + bind, IDebugFilter.LIFECYCLE);
            }
            if (bind != null) {
                this.fBinds.put(uri, bind);
            }
        }
        if (ProgramModelPlugin.DEBUG) {
            ProgramModelPlugin.debug(String.valueOf(this.getTraceName()) + ".getBinding(" + uri + ")=" + bind, IDebugFilter.LIFECYCLE);
        }
        return bind;
    }

    public void dispose() {
        if (ProgramModelPlugin.DEBUG) {
            ProgramModelPlugin.debug(String.valueOf(this.getTraceName()) + ".dispose()", IDebugFilter.LIFECYCLE);
        }
        for (Map.Entry<String, IBind> entry : this.fBinds.entrySet()) {
            IBind bind = entry.getValue();
            if (!(bind instanceof IDisposable)) continue;
            ((IDisposable)bind).dispose();
        }
        this.fBinds.clear();
    }

    protected IBindValue getInternalBindFromMap(String variable) {
        IBind bind = this.fBinds.get(variable);
        if (bind instanceof IBindValue) {
            return (IBindValue)bind;
        }
        return null;
    }

    protected abstract IBind createNewBind(String var1);
}

