/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.IDisposable;
import com.ti.binding.program.internal.DSBaseValueBind;
import com.ti.binding.program.internal.DSSessionManager;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ProgramModelPlugin;
import java.util.ArrayList;

public class DSCPUsBind
extends DSBaseValueBind
implements IDisposable {
    DSSessionManager sessionManager;
    DSSessionManager.IDSSessionListener listener;

    DSCPUsBind(ProgramModelBase model) {
        super(model, model.getSessionManager().getCopyOfTaskNames(), ArrayList.class);
        this.sessionManager = model.getSessionManager();
        this.listener = new DSSessionManager.IDSSessionListener(){

            @Override
            public void onSessionStarted(String taskId) {
                DSCPUsBind.this.updateSessions();
            }

            @Override
            public void onSessionEnding(String taskId) {
                DSCPUsBind.this.updateSessions();
            }

            @Override
            public void onSessionActivated(String taskId) {
            }

            @Override
            public void onAppConfigured() {
            }
        };
        this.sessionManager.addSessionListener(this.listener);
    }

    void updateSessions() {
        final ArrayList<String> copiedValue = new ArrayList<String>(this.getModel().getSessionManager().getCopyOfTaskNames());
        this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                DSCPUsBind.this.setValue(copiedValue, null);
            }
        });
    }

    public void dispose() {
        if (ProgramModelPlugin.DEBUG) {
            ProgramModelPlugin.debug(String.valueOf(this.getTraceName()) + ".dispose()", IDebugFilter.LIFECYCLE);
        }
        if (this.sessionManager != null) {
            this.sessionManager.removeSessionListener(this.listener);
            this.sessionManager = null;
            this.listener = null;
        }
    }
}

