/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSBaseValueBindAndBindProvider;
import com.ti.binding.program.internal.DebugContextBind2;
import com.ti.binding.program.internal.DebugTargetCache;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDSDataBind;
import com.ti.binding.program.internal.IDebugContext;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ProgramModelPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;

public class DSDataBind2
extends DSBaseValueBindAndBindProvider
implements IDisposable,
IDSDataBind {
    String fExpression;
    DebugContextBind2 fDebugContextBind;
    DebugTargetCache fCache;
    ICancelable fCancelable;
    boolean fEnabled;
    boolean isIndex;
    DSDataBind2 fParent;

    DSDataBind2(ProgramModelBase model, DebugContextBind2 debugContextBind, String expression, DSDataBind2 parent) {
        super(model);
        this.fDefaultType = null;
        this.fEnabled = true;
        this.fExpression = expression;
        this.fDebugContextBind = debugContextBind;
        this.fParent = parent;
        try {
            Long.parseLong(this.fExpression);
            this.isIndex = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.isIndex = false;
        }
        this.setName(String.valueOf(debugContextBind.getName()) + "." + expression);
    }

    void initAfterGetValue() {
        this.fCache = new DebugTargetCache(this.getModel(), this, this.fDebugContextBind, false, true);
        this.fCache.init();
        this.setStatus(this.fCache.getStatus());
        this.fEnabled = true;
        this.fCache.forceUpdate();
    }

    @Override
    protected IBind createNewBind(String uri) {
        return new DSDataBind2(this.getModel(), this.fDebugContextBind, uri, this);
    }

    public Object getValue() {
        if (this.fCache == null) {
            this.initAfterGetValue();
        }
        return super.getValue();
    }

    @Override
    public String getExpression() {
        if (this.fParent == null) {
            return this.fExpression;
        }
        if (this.isIndex) {
            return String.valueOf(this.fParent.getExpression()) + "[" + this.fExpression + "]";
        }
        return String.valueOf(this.fParent.getExpression()) + "." + this.fExpression;
    }

    public void setValue(Object value, IFinished callback) {
        if (value instanceof Integer) {
            value = new Long(((Integer)value).longValue());
        }
        if (!this.valuesEqual(value, this.fCachedValue)) {
            this.onValueChanged(this.fCachedValue, value);
            this.fCachedValue = value;
            this.notifyChangedListeners();
            this.fCache.onSetValue();
        }
        if (callback != null) {
            callback.done(null);
        }
    }

    protected boolean valuesEqual(Object newValue, Object cachedValue) {
        if (newValue == null) {
            return true;
        }
        if (cachedValue == null) {
            return newValue == null;
        }
        if (!newValue.getClass().equals(cachedValue.getClass())) {
            return false;
        }
        if (newValue instanceof Object[]) {
            return Arrays.equals((Object[])newValue, (Object[])cachedValue);
        }
        if (newValue instanceof ArrayList) {
            return this.collectionsEqual((ArrayList)newValue, (ArrayList)cachedValue);
        }
        return newValue.equals(cachedValue);
    }

    private boolean collectionsEqual(ArrayList<?> c1, ArrayList<?> c2) {
        if (!(c1 instanceof ArrayList)) {
            return false;
        }
        if (!(c2 instanceof ArrayList)) {
            return false;
        }
        if (c1 == c2) {
            return true;
        }
        ListIterator<?> e1 = c1.listIterator();
        ListIterator<?> e2 = c2.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 == null) continue;
            if (o2 == null) {
                return false;
            }
            if (this.valuesEqual(o1, o2)) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public void assingAfterReadCompleted(Object newValue) {
        if (!this.fEnabled) {
            return;
        }
        this.setStatus(this.fCache.getStatus());
        if (!this.valuesEqual(newValue, this.fCachedValue)) {
            this.onValueChanged(this.fCachedValue, newValue);
            this.fCachedValue = newValue;
            this.notifyChangedListeners();
        }
    }

    public void onDone(Object result, IStatus status, boolean write) {
        this.fCache.onDone(result, status, write);
    }

    protected IDebugContext getDebugContext() {
        return this.fCache.getDebugContext();
    }

    @Override
    public void readValue() {
        final IDebugContext debugContext = this.getDebugContext();
        if (debugContext == null) {
            this.onDone(this.fCachedValue, this.fCache.getStatus(), false);
            return;
        }
        if (!this.fEnabled) {
            this.onDone(this.fCachedValue, this.fCache.getStatus(), false);
            return;
        }
        this.fCancelable = debugContext.requestGet(this.getExpression(), new IRequestCompletedCallback(){

            @Override
            public void done(Object retValue, IStatus status) {
                ArrayList<Object> castValue = null;
                if (status == null) {
                    Number l;
                    ArrayList<Object> a;
                    if (retValue instanceof Double) {
                        castValue = new Double((Double)retValue);
                    } else if (retValue instanceof Long) {
                        castValue = new Long((Long)retValue);
                    } else if (retValue instanceof Long[]) {
                        a = new ArrayList<Object>();
                        Long[] longArray = (Long[])retValue;
                        int n = longArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            l = longArray[n2];
                            a.add(l);
                            ++n2;
                        }
                        castValue = a;
                    } else if (retValue instanceof Double[]) {
                        a = new ArrayList();
                        Double[] doubleArray = (Double[])retValue;
                        int n = doubleArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            l = doubleArray[n3];
                            a.add(l);
                            ++n3;
                        }
                        castValue = a;
                    } else if (retValue instanceof String) {
                        castValue = retValue;
                    } else if (retValue instanceof Object[]) {
                        a = new ArrayList();
                        Object[] objectArray = (Object[])retValue;
                        int n = objectArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object o = objectArray[n4];
                            a.add(o);
                            ++n4;
                        }
                        castValue = a;
                    } else if (retValue != null) {
                        status = AbstractStatus.createErrorStatus((String)("Unsupported data type returned from DS" + retValue.getClass().toString()));
                    }
                }
                final Double finalValue = castValue;
                final IStatus finalStatus = status;
                debugContext.deferredUpdateInc();
                DSDataBind2.this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DSDataBind2.this.onDone(finalValue, finalStatus, false);
                        debugContext.deferredUpdateDec();
                    }
                });
            }
        });
    }

    @Override
    public void writeValue() {
        final IDebugContext debugContext = this.getDebugContext();
        if (debugContext == null) {
            this.onDone(null, AbstractStatus.createErrorStatus((String)"Null Debug Context."), true);
            return;
        }
        this.fCancelable = debugContext.requestSet(this.getExpression(), this.fCachedValue, new IRequestCompletedCallback(){

            @Override
            public void done(Object retValue, final IStatus status) {
                debugContext.deferredUpdateInc();
                DSDataBind2.this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DSDataBind2.this.onDone(null, status, true);
                        debugContext.deferredUpdateDec();
                    }
                });
            }
        });
    }

    @Override
    public boolean cancel() {
        if (this.fCancelable == null) {
            return true;
        }
        boolean cancelled = this.fCancelable.cancel();
        this.fCancelable = null;
        return cancelled;
    }

    @Override
    public void dispose() {
        if (ProgramModelPlugin.DEBUG) {
            ProgramModelPlugin.debug(String.valueOf(this.getTraceName()) + ".dispose()", IDebugFilter.LIFECYCLE);
        }
    }

    protected void onFirstChangeListenerAdded() {
        super.onFirstChangeListenerAdded();
        this.fEnabled = true;
        if (this.fCache != null) {
            this.fCache.forceUpdate();
        }
    }

    protected void onLastChangedListenerRemoved() {
        super.onLastChangedListenerRemoved();
        this.fEnabled = false;
    }
}

