/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.internal.update.IUpdateCompletedCallback;
import com.ti.backplane.internal.update.IUpdateListener;
import com.ti.backplane.internal.update.UpdateCompletedCounter;
import com.ti.binding.program.internal.DSSessionManager;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDebugContext;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ds.DSTask;
import com.ti.debug.engine.IDspTask;
import java.util.ArrayList;

public class DSDebugContext
implements IDebugContext {
    protected UpdateCompletedCounter updateCompletedCounter;
    protected ArrayList<IUpdateListener> updateListeners = new ArrayList();
    protected IUpdateListener serverUpdateListener = null;
    DSTask fDsTask;
    IDspTask fDspTask;
    String fName;
    ProgramModelBase model;

    DSDebugContext(ProgramModelBase model, String name) {
        this.fName = name;
        this.model = model;
        this.setEnabled(DSSessionManager.getInstance().hasSession(name));
    }

    public String getName() {
        return this.fName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DSDebugContext) {
            return this.fName == ((DSDebugContext)obj).fName;
        }
        return false;
    }

    public int hashCode() {
        return this.fDspTask.hashCode();
    }

    public String toString() {
        return this.fName;
    }

    @Override
    public ICancelable requestSet(String expression, Object value, IRequestCompletedCallback callback) {
        if (this.fDsTask != null) {
            return this.fDsTask.requestSet(expression, value, callback);
        }
        callback.done(null, AbstractStatus.createErrorStatus((String)"Debbuger task is not set"));
        return null;
    }

    @Override
    public ICancelable requestGet(String expression, IRequestCompletedCallback callback) {
        if (this.fDsTask != null) {
            return this.fDsTask.requestGet(expression, callback);
        }
        callback.done(null, AbstractStatus.createErrorStatus((String)"Debbuger task is not set"));
        return null;
    }

    protected void connectToServerUpdate(IUpdateListener updateListener) {
        if (this.fDsTask != null) {
            this.fDsTask.addUpdateListener(updateListener);
        }
    }

    protected void disconnectFromServerUpdate(IUpdateListener updateListener) {
        if (this.fDsTask != null) {
            this.fDsTask.removeUpdateListener(updateListener);
        }
    }

    public void dispose() {
        if (this.fDsTask != null) {
            this.disconnectFromServerUpdate(this.serverUpdateListener);
            this.fDsTask.dispose();
            this.fDsTask = null;
        }
        this.fDspTask = null;
    }

    @Override
    public void deferredUpdateInc() {
        if (this.updateCompletedCounter != null) {
            this.updateCompletedCounter.inc();
        }
    }

    @Override
    public void deferredUpdateDec() {
        if (this.updateCompletedCounter != null) {
            this.updateCompletedCounter.dec();
            if (this.updateCompletedCounter.hasReachedZero()) {
                this.updateCompletedCounter = null;
            }
        }
    }

    @Override
    public void addUpdateListener(IUpdateListener listener) {
        this.updateListeners.add(listener);
        if (this.updateListeners.size() == 1) {
            this.serverUpdateListener = new IUpdateListener(){

                public void update(IUpdateCompletedCallback updateCompelted) {
                    DSDebugContext.this.startDeferredUpdate(updateCompelted);
                    int i = 0;
                    while (i < DSDebugContext.this.updateListeners.size()) {
                        DSDebugContext.this.updateListeners.get(i).update((IUpdateCompletedCallback)DSDebugContext.this.updateCompletedCounter);
                        ++i;
                    }
                }
            };
            this.connectToServerUpdate(this.serverUpdateListener);
        }
    }

    @Override
    public void removeUpdateListener(IUpdateListener listener) {
        this.updateListeners.remove(listener);
        if (this.updateListeners.size() == 0) {
            this.disconnectFromServerUpdate(this.serverUpdateListener);
            this.serverUpdateListener = null;
        }
    }

    protected void startDeferredUpdate(IUpdateCompletedCallback updateCompelted) {
        if (updateCompelted != null) {
            this.updateCompletedCounter = new UpdateCompletedCounter(updateCompelted);
        }
    }

    void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.fDspTask != null) {
                return;
            }
            IDspTask newTask = DSSessionManager.getInstance().getTask(this.fName);
            if (newTask != null) {
                this.fDspTask = newTask;
                this.fDsTask = new DSTask(this.fDspTask);
                if (!this.fDsTask.initialzed()) {
                    this.fDsTask = null;
                    this.fDspTask = null;
                }
                if (this.serverUpdateListener != null) {
                    this.connectToServerUpdate(this.serverUpdateListener);
                }
            }
        } else {
            this.dispose();
        }
    }
}

