/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractBindAction;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSInitScriptInfo;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ds.DSInitializer;
import com.ti.binding.program.internal.ds.IDSErrorReporter;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.DebugServer;
import com.ti.debug.engine.scripting.TargetConfigurationEditor;
import com.ti.debug.engine.scripting.TargetConfigurationGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class DSInitRunBind
extends AbstractBindAction {
    private static final String WEB_APP_INITSCRIPT = "gc.appInitScript";
    private static final String WEB_APP_CONFIG = "gc.appConfigFile";
    private static final String WEB_APP_PROGRAM = "gc.appProgramFile";
    private static final String DEFAULT_SCRIPT_NAME = "appInitScript.js";
    private static final String DEFAULT_CONFIG_NAME = "appConfig.ccxml";
    private static final String DEFAULT_PROGRAM_NAME = "appProgram.out";

    DSInitRunBind(ProgramModelBase model) {
        super((AbstractBindFactory)model);
    }

    public ProgramModelBase getModel() {
        return (ProgramModelBase)super.getModel();
    }

    private String getWebAppLocation(Object parameters, IStatus[] status) {
        String appFilePath = null;
        String appPath = (String)this.getParameter(parameters, ProgramModelBase.DS_INTI_PARAM_APPPATH, String.class, status);
        if (appPath != null) {
            appFilePath = this.getModel().getBackplane().resolveAppPath(appPath);
            if (appFilePath == null) {
                status[0] = AbstractStatus.createErrorStatus((String)("The value '" + appPath + "' of the parameter 'appPath' is the action bind 'value:pm.$init' cannot be resolved."));
            }
        } else {
            status[0] = null;
            String uri = this.getModel().getBackplane().getURL();
            int gcIndex = uri.indexOf("/gc");
            if (gcIndex != -1) {
                String appOnlyURI = uri.substring(gcIndex);
                appFilePath = this.getModel().getBackplane().resolveAppPath(appOnlyURI);
            }
            if (appFilePath == null) {
                status[0] = AbstractStatus.createErrorStatus((String)"The parameter 'appPath' is not specified in the action bind 'value:pm.$init'.");
            }
        }
        return appFilePath;
    }

    private String getScriptPath(String webAppLocation, Object parameters, IStatus[] status) {
        String script = (String)this.getParameter(parameters, ProgramModelBase.DS_INIT_PARAM_SCRIPT, String.class, status);
        script = script != null ? new Path(webAppLocation).append(script).toOSString() : this.getEnvironmentVariableValue(webAppLocation, WEB_APP_INITSCRIPT, DEFAULT_SCRIPT_NAME);
        this.confirmValidFile(script, status, ProgramModelBase.DS_INIT_PARAM_SCRIPT);
        return script;
    }

    private String getEnvironmentVariableValue(String webAppLocation, String variableName, String defaultValue) {
        Path path;
        String value = null;
        String property = System.getProperty(variableName);
        value = property != null ? ((path = new Path(property)).isAbsolute() ? path.toOSString() : new Path(webAppLocation).append((IPath)path).toOSString()) : new Path(webAppLocation).append(defaultValue).toOSString();
        return value;
    }

    private String getOptionalVar(String webAppLocation, String variableName, String defaultValue) {
        IStatus[] status = new IStatus[1];
        String value = this.getEnvironmentVariableValue(webAppLocation, variableName, defaultValue);
        this.confirmValidFile(value, status, "");
        if (status[0] != null) {
            value = null;
        }
        return value;
    }

    private String getAppConfigFile(String webAppLocation) {
        return this.getOptionalVar(webAppLocation, WEB_APP_CONFIG, DEFAULT_CONFIG_NAME);
    }

    private String getAppProgramFile(String webAppLocation) {
        return this.getOptionalVar(webAppLocation, WEB_APP_PROGRAM, DEFAULT_PROGRAM_NAME);
    }

    public void run(Object parameters, final IFinishedWithResult callback) {
        IStatus[] status = new IStatus[1];
        String webAppLocation = null;
        String configFile = null;
        String script = null;
        this.getModel().logMessage("Restarting Program Model...\n");
        if (DSInitializer.getInstance().isRestarting()) {
            IStatus restartInProgress = AbstractStatus.createErrorStatus((String)"Program is currently restarting...");
            callback.done(restartInProgress, null);
            return;
        }
        if (status[0] == null) {
            webAppLocation = this.getWebAppLocation(parameters, status);
            if (status[0] == null) {
                script = this.getScriptPath(webAppLocation, parameters, status);
                configFile = this.getAppConfigFile(webAppLocation);
                if (status[0] == null && configFile == null) {
                    String connection = (String)this.getParameter(parameters, ProgramModelBase.DS_INIT_PARAM_CONNECTION, String.class, status);
                    String device = (String)this.getParameter(parameters, ProgramModelBase.DS_INIT_PARAM_DEVICE, String.class, status);
                    if (connection != null && device != null) {
                        IPath file = DSInitRunBind.generateConfigFile(connection, device);
                        if (file != null) {
                            configFile = file.toOSString();
                        }
                        if (file != null) {
                            this.UARTConnectionHack(connection, configFile, status);
                        }
                    }
                }
            }
        }
        if (status[0] != null && callback != null) {
            final IStatus finalStatus = status[0];
            this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DSInitRunBind.this.getModel().logMessage("Error: " + finalStatus.getMessage() + "\nRestart Failed.\n");
                    callback.done(finalStatus, null);
                }
            });
            return;
        }
        ArrayList targetProps = (ArrayList)this.getParameter(parameters, ProgramModelBase.DS_INTI_PARAM_TARGET_PROPERTIES, ArrayList.class, status);
        if (targetProps != null) {
            this.setDebuggerProperties(configFile, targetProps, status);
        }
        String appName = new Path(webAppLocation).lastSegment();
        final DSInitScriptInfo info = new DSInitScriptInfo(appName, script);
        String programFile = this.getAppProgramFile(webAppLocation);
        info.put("appConfigFile", configFile);
        info.put("appProgramFile", programFile);
        new Thread(new Runnable(){

            @Override
            public void run() {
                IDSErrorReporter errorReporter = new IDSErrorReporter(){

                    @Override
                    public void log(String error) {
                        DSInitRunBind.this.getModel().logMessage(error);
                    }
                };
                IStatus status = DSInitializer.getInstance().restart(info, errorReporter);
                DSInitRunBind.this.getModel().logMessage("Restart Completed.\n");
                if (callback != null) {
                    callback.done(status, null);
                }
            }
        }, "Program restart thread...").start();
    }

    private void confirmValidFile(String path, IStatus[] returnStatus, String name) {
        File f;
        if (path == null || path.length() == 0) {
            returnStatus[0] = AbstractStatus.createErrorStatus((String)(String.valueOf(name) + " is null or empty."));
        }
        if (!(f = new File(path)).exists()) {
            returnStatus[0] = AbstractStatus.createErrorStatus((String)(String.valueOf(path) + " does not exits."));
            return;
        }
        if (!f.isFile()) {
            returnStatus[0] = AbstractStatus.createErrorStatus((String)(String.valueOf(path) + " is not a file."));
            return;
        }
    }

    private static IPath generateConfigFile(String connection, String deviceAndBoard) {
        try {
            boolean matched = false;
            DebugServer server = (DebugServer)ScriptingEnvironment.instance().getServer("DebugServer.1");
            TargetConfigurationGenerator gen = server.createTargetConfigurationGenerator();
            gen.setConnection(connection);
            String[] boards = gen.getCombinedDeviceBoardsList();
            if (!matched) {
                String[] stringArray = boards;
                int n = boards.length;
                int n2 = 0;
                while (n2 < n) {
                    String board = stringArray[n2];
                    if (deviceAndBoard.equals(board)) {
                        gen.setBoardDevice(board);
                        matched = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (matched) {
                try {
                    URL dataArea = Platform.getInstanceLocation().getDataArea("com.ti.binding.program");
                    dataArea = FileLocator.toFileURL((URL)dataArea);
                    Path dataAreaPath = new Path(dataArea.getPath());
                    File dataAreaFile = dataAreaPath.toFile();
                    if (!dataAreaFile.exists()) {
                        dataAreaFile.mkdir();
                    }
                    gen.setOutputDirectory(dataAreaPath.toOSString());
                    gen.createConfiguration(DEFAULT_CONFIG_NAME);
                    return dataAreaPath.append(DEFAULT_CONFIG_NAME);
                }
                catch (IOException iOException) {}
            }
        }
        catch (ScriptingException scriptingException) {}
        return null;
    }

    void setDebuggerProperties(String configFile, ArrayList<Object> targetProps, IStatus[] status) {
        try {
            DebugServer debugServer = (DebugServer)ScriptingEnvironment.instance().getServer("DebugServer.1");
            TargetConfigurationEditor targetConfigEditor = debugServer.createTargetConfigurationEditor();
            targetConfigEditor.setConfigFile(configFile);
            boolean changed = false;
            for (Object m : targetProps) {
                IBind binding;
                Object val;
                if (!(m instanceof Map)) continue;
                Map m1 = (Map)m;
                Object bindingName = m1.get("bindingName");
                Object propertyName = m1.get("propertyName");
                if (!(bindingName instanceof String) || !(propertyName instanceof String) || !((val = ((IBindValue)(binding = this.getModel().getBackplane().getBinding((String)bindingName))).getValue()) instanceof String)) continue;
                targetConfigEditor.setOption((String)propertyName, (String)val);
                changed = true;
            }
            if (changed) {
                targetConfigEditor.saveChanges();
            }
        }
        catch (Exception e) {
            this.fillStatus(status, e.getMessage());
        }
    }

    void UARTConnectionHack(String connection, String configFile, IStatus[] status) {
        if (!connection.equals("UARTConnection")) {
            return;
        }
        try {
            DebugServer debugServer = (DebugServer)ScriptingEnvironment.instance().getServer("DebugServer.1");
            TargetConfigurationEditor targetConfigEditor = debugServer.createTargetConfigurationEditor();
            targetConfigEditor.setConfigFile(configFile);
            targetConfigEditor.setOption("initialization script", "");
            targetConfigEditor.saveChanges();
        }
        catch (Exception e) {
            this.fillStatus(status, e.getMessage());
        }
    }
}

