/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.internal.update.IRefreshIntervalChangeListener;
import com.ti.backplane.internal.update.UpdateManager;
import com.ti.binding.program.internal.DSBaseValueBind;
import com.ti.binding.program.internal.ProgramModelBase;

public class DSRefreshIntervalBind
extends DSBaseValueBind
implements IDisposable {
    IRefreshIntervalChangeListener refreshLisntener = new IRefreshIntervalChangeListener(){

        public void onChanged() {
            DSRefreshIntervalBind.this.onIntervalChanged();
        }
    };

    DSRefreshIntervalBind(ProgramModelBase model) {
        super(model, new Long(UpdateManager.getInstance().getRefreshInterval()));
        UpdateManager.getInstance().addRefreshIntervalChangeListener(this.refreshLisntener);
    }

    public void setValue(Object value, IFinished callback) {
        super.setValue(value, callback);
        if (value instanceof Long) {
            UpdateManager.getInstance().setRefreshInterval(((Long)value).longValue());
        }
    }

    private void onIntervalChanged() {
        this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                DSRefreshIntervalBind.this.setValue(new Long(UpdateManager.getInstance().getRefreshInterval()), null);
            }
        });
    }

    public void dispose() {
        if (this.refreshLisntener != null) {
            UpdateManager.getInstance().removeRefreshIntervalChangeListener(this.refreshLisntener);
            this.refreshLisntener = null;
        }
    }
}

