/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractBindAction;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IFinishedWithResult;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSScriptInfo;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ds.DSInitializer;
import com.ti.binding.program.internal.ds.DSScriptExecutor;
import com.ti.binding.program.internal.ds.IScriptWriter;
import com.ti.common.core.internal.javascript.JavaScriptDocParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Path;
import org.json.JSONException;
import org.json.JSONObject;

public class DSScriptActionBind
extends AbstractBindAction {
    public DSScriptActionBind(ProgramModelBase model) {
        super((AbstractBindFactory)model);
    }

    public ProgramModelBase getModel() {
        return (ProgramModelBase)super.getModel();
    }

    public void run(Object parameters, final IFinishedWithResult callback) {
        String func = null;
        ArrayList params = null;
        String path = null;
        String text = null;
        IStatus[] status = new IStatus[1];
        String appPath = null;
        if (DSInitializer.getInstance().isRestarting()) {
            status[0] = AbstractStatus.createErrorStatus((String)"Program is currently restarting...");
        }
        if (status[0] == null) {
            appPath = (String)this.getParameter(parameters, ProgramModelBase.DS_INTI_PARAM_APPPATH, String.class, status);
            if (status[0] == null && appPath == null || appPath.trim().length() == 0) {
                status[0] = AbstractStatus.createErrorStatus((String)"The value of the parameter 'appPath' cannot be empty.");
            }
        }
        if (status[0] == null) {
            String appFilePath = this.getModel().getBackplane().resolveAppPath(appPath);
            if (appFilePath == null) {
                status[0] = AbstractStatus.createErrorStatus((String)("The value '" + appPath + "' of the parameter 'appPath' is the action bind '$execute' cannot be resolved."));
            } else {
                String jsPath = new Path(appFilePath).append("dsScript.js").toOSString();
                if (new File(jsPath).exists()) {
                    path = jsPath;
                } else {
                    status[0] = AbstractStatus.createErrorStatus((String)"The file dsScript.js does not exist in the application folder.");
                }
            }
        }
        if (status[0] == null) {
            func = (String)this.getParameter(parameters, ProgramModelBase.DS_EXECUTE_FUNC, String.class, status);
            if (status[0] == null && (func == null || func.trim().length() == 0)) {
                status[0] = AbstractStatus.createErrorStatus((String)"The parameter 'func' cannot be an empty string.");
            }
        }
        if (status[0] == null) {
            String paramString = null;
            IStatus[] status1 = new IStatus[1];
            params = (ArrayList)this.getParameter(parameters, ProgramModelBase.DS_EXECUTE_PARAMS, ArrayList.class, status1);
            if (params != null && params.size() > 0) {
                try {
                    paramString = JSONObject.valueToString((Object)params);
                }
                catch (JSONException jSONException) {}
            }
            if (paramString != null) {
                paramString = paramString.trim();
                int len = paramString.length();
                paramString = paramString.substring(1, len - 1);
            }
            if (paramString == null) {
                paramString = "";
            }
            text = String.valueOf(func) + "(" + paramString + ")";
        }
        if (status[0] != null && callback != null) {
            final IStatus finalStatus = status[0];
            this.getModel().getBackplane().getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DSScriptActionBind.this.getModel().logMessage("Error: " + finalStatus.getMessage());
                    callback.done(finalStatus, null);
                }
            });
            return;
        }
        final String scriptText = text;
        final String scriptPath = path;
        final String scriptFunction = func;
        final String dsAppPath = new Path(appPath).append("dsScript.js").toOSString();
        new Thread(new Runnable(){

            @Override
            public void run() {
                JavaScriptDocParser parse = new JavaScriptDocParser();
                HashMap nodes = null;
                try {
                    nodes = parse.parse(scriptPath);
                }
                catch (Exception exception) {}
                Iterator key = nodes.keySet().iterator();
                boolean funcExists = false;
                while (key.hasNext()) {
                    String prototype = (String)key.next();
                    int braketIndex = prototype.indexOf("(");
                    if (braketIndex != -1) {
                        prototype = prototype.substring(0, braketIndex);
                    }
                    if (!scriptFunction.equals(prototype)) continue;
                    funcExists = true;
                    break;
                }
                if (!funcExists) {
                    String msg = "The function '" + scriptFunction + "' cannot be found in the file '" + dsAppPath + "'.";
                    IStatus status = AbstractStatus.createErrorStatus((String)msg);
                    DSScriptActionBind.this.getModel().logMessage(msg);
                    callback.done(status, null);
                    return;
                }
                DSScriptInfo info = new DSScriptInfo(scriptText, scriptPath);
                info.put(ProgramModelBase.ACTIVE_DEBUG_CONTEXT_NAME, DSScriptActionBind.this.getModel().getSessionManager().getActive());
                IScriptWriter writer = new IScriptWriter(){

                    @Override
                    public void write(String message) {
                        DSScriptActionBind.this.getModel().logMessage(message);
                    }
                };
                DSScriptExecutor se = new DSScriptExecutor();
                Object[] result = new Object[1];
                IStatus status = se.run(info, writer, result);
                if (callback != null) {
                    callback.done(status, result[0]);
                }
            }
        }, "Program Script thread...").start();
    }
}

