/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class DSSessionManager {
    static DSSessionManager sInstance;
    HashSet<IDSSessionListener> fListeners = new HashSet();
    HashMap<String, IDspTask> fSessions = new HashMap();
    ArrayList<String> fOrderedSessionNames = new ArrayList();
    String fActiveName = null;
    IDspTask fActiveTask = null;
    IApplication app = null;

    public static synchronized DSSessionManager getInstance() {
        if (sInstance == null) {
            sInstance = new DSSessionManager();
        }
        return sInstance;
    }

    public void addSessionListener(IDSSessionListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSessionListener(IDSSessionListener listener) {
        this.fListeners.remove(listener);
    }

    public void fireSessionStarted(IDspTask dspTask, String taskId) {
        this.fSessions.put(taskId, dspTask);
        this.fOrderedSessionNames.remove(taskId);
        this.fOrderedSessionNames.add(taskId);
        for (IDSSessionListener listener : this.fListeners) {
            listener.onSessionStarted(taskId);
        }
    }

    public void fireAppConfigured(IApplication app) {
        this.app = app;
        for (IDSSessionListener listener : this.fListeners) {
            listener.onAppConfigured();
        }
    }

    public void fireSessionEnding(IDspTask dspTask, String taskId) {
        this.fSessions.remove(taskId);
        this.fOrderedSessionNames.remove(taskId);
        HashSet<IDSSessionListener> copy = new HashSet<IDSSessionListener>(this.fListeners);
        for (IDSSessionListener listener : copy) {
            listener.onSessionEnding(taskId);
        }
        if (this.fSessions.isEmpty()) {
            this.app = null;
        }
    }

    public void fireSessionActivated(IDspTask dspTask, String taskId) {
        this.fActiveName = taskId;
        this.fActiveTask = dspTask;
        for (IDSSessionListener listener : this.fListeners) {
            listener.onSessionActivated(taskId);
        }
    }

    public boolean hasSession(String taskId) {
        return this.fSessions.get(taskId) != null;
    }

    public String getActive() {
        return this.fActiveName;
    }

    public IDspTask getTask(String taskId) {
        return this.fSessions.get(taskId);
    }

    public ArrayList<String> getCopyOfTaskNames() {
        return new ArrayList<String>(this.fOrderedSessionNames);
    }

    public IApplication getApplication() {
        return this.app;
    }

    public static interface IDSSessionListener {
        public void onSessionStarted(String var1);

        public void onSessionEnding(String var1);

        public void onSessionActivated(String var1);

        public void onAppConfigured();
    }
}

