/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.AbstractBindDependent;
import com.ti.binding.program.internal.DSBaseValueBind;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.debug.engine.scripting.DebugServer;
import com.ti.debug.engine.scripting.TargetConfigurationGenerator;
import java.util.ArrayList;

public class DSTargetConnectionsBind
extends DSBaseValueBind {
    AbstractBindDependent fParentBinds;

    public DSTargetConnectionsBind(ProgramModelBase model) {
        super(model);
        IBindValue dep1 = (IBindValue)model.getBinding(ProgramModelBase.DS_TARGET_CONNECTION_FILTER);
        IBindValue dep2 = (IBindValue)model.getBinding(ProgramModelBase.DS_INIT_DEVICE);
        this.fParentBinds = new AbstractBindDependent(new IBindValue[]{dep1, dep2}){

            public void onStatusChanged(int index, IStatus status) {
                DSTargetConnectionsBind.this.onDependantChanged();
            }

            public void onValueChanged(int index, IFinished callback) {
                DSTargetConnectionsBind.this.onDependantChanged();
                if (callback != null) {
                    callback.done(null);
                }
            }
        };
        this.onDependantChanged();
    }

    void onDependantChanged() {
        String filter = (String)this.fParentBinds.fBinds[0].getValue();
        String device = (String)this.fParentBinds.fBinds[1].getValue();
        String[] all = this.getConnections(device);
        ArrayList<String> filtered = new ArrayList<String>();
        String[] stringArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (filter != null) {
                if (s.matches(filter)) {
                    filtered.add(s);
                }
            } else {
                filtered.add(s);
            }
            ++n2;
        }
        this.setValue(filtered, null);
    }

    String[] getConnections(String device) {
        try {
            DebugServer server = (DebugServer)ScriptingEnvironment.instance().getServer("DebugServer.1");
            TargetConfigurationGenerator gen = server.createTargetConfigurationGenerator();
            if (device != null && !device.isEmpty()) {
                gen.setBoardDevice(device);
            }
            return gen.getListOfConnections();
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }
}

