/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.AbstractBindDependent;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.binding.program.internal.DSBaseValueBindAndBindProvider;
import com.ti.binding.program.internal.DSContextEnabledBind;
import com.ti.binding.program.internal.DSDataBind2;
import com.ti.binding.program.internal.DSDebugContext;
import com.ti.binding.program.internal.DSEvalBind;
import com.ti.binding.program.internal.DSRefreshIdBind;
import com.ti.binding.program.internal.DebugContextsBind;
import com.ti.binding.program.internal.ProgramModelBase;
import java.util.ArrayList;

public class DebugContextBind2
extends DSBaseValueBindAndBindProvider {
    AbstractBindDependent fParentBinds;
    String index;

    DebugContextBind2(ProgramModelBase model, DebugContextsBind arrayBind, String index) {
        super(model);
        this.setName("cpu[" + index + "]");
        this.index = index;
        this.fParentBinds = new AbstractBindDependent(new IBindValue[]{arrayBind}){

            public void onStatusChanged(int index, IStatus status) {
                DebugContextBind2.this.onDependantChanged();
            }

            public void onValueChanged(int index, IFinished callback) {
                DebugContextBind2.this.onDependantChanged();
                if (callback != null) {
                    callback.done(null);
                }
            }
        };
        this.onDependantChanged();
    }

    Object convertToLongOrString() {
        IStatus[] status = new IStatus[1];
        Long ret = (Long)new DataConverter().convert(String.class, Long.class, (Object)this.index, null, status);
        if (status[0] != null) {
            return this.index;
        }
        return ret;
    }

    void onDependantChanged() {
        Object arrayObject = this.fParentBinds.fBinds[0].getValue();
        Object indexObject = this.convertToLongOrString();
        IStatus newStatus = null;
        DSDebugContext debugContext = null;
        if (arrayObject instanceof ArrayList) {
            ArrayList arrayValue = (ArrayList)arrayObject;
            int arraySize = arrayValue.size();
            if (indexObject instanceof Number) {
                int numValue = ((Number)indexObject).intValue();
                if (numValue < 0 || numValue >= arraySize) {
                    newStatus = arraySize == 0 ? AbstractStatus.createErrorStatus((String)"Array is empty.") : AbstractStatus.createErrorStatus((String)("Index " + numValue + " out of range [0:" + (arraySize - 1) + "]."));
                } else if (arrayValue.get(numValue) instanceof DSDebugContext) {
                    debugContext = (DSDebugContext)arrayValue.get(numValue);
                }
            } else if (indexObject instanceof String) {
                int i = 0;
                while (i < arrayValue.size()) {
                    DSDebugContext dc;
                    String name;
                    if (arrayValue.get(i) instanceof DSDebugContext && indexObject.equals(name = (dc = (DSDebugContext)arrayValue.get(i)).getName())) {
                        debugContext = dc;
                        break;
                    }
                    ++i;
                }
                if (debugContext == null) {
                    newStatus = AbstractStatus.createErrorStatus((String)("CPU with name " + indexObject + " does not exist."));
                }
            } else {
                newStatus = indexObject == null ? AbstractStatus.createErrorStatus((String)"Index is null.") : AbstractStatus.createErrorStatus((String)("Index of type " + indexObject.getClass().toString() + " not supported."));
            }
        }
        this.setStatus(newStatus);
        this.setValue(debugContext, null);
    }

    DSDebugContext getDebugContext() {
        return (DSDebugContext)this.fCachedValue;
    }

    void enableDebugContext(boolean enabled) {
        IBindValue bind;
        if (this.getDebugContext() != null) {
            this.getDebugContext().setEnabled(enabled);
        }
        if ((bind = this.getInternalBindFromMap(ProgramModelBase.DEBUG_CONTEXT_ENABLED)) != null) {
            bind.setValue((Object)enabled, null);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.getDebugContext() != null) {
            this.getDebugContext().dispose();
        }
    }

    @Override
    protected IBind createNewBind(String uri) {
        if (uri.equals(ProgramModelBase.DEBUG_CONTEXT_ENABLED)) {
            return new DSContextEnabledBind(this.getModel(), this);
        }
        if (uri.equals(ProgramModelBase.DEBUG_CONTEXT_REFRESH_ID)) {
            return new DSRefreshIdBind(this.getModel(), this);
        }
        if (uri.equals(ProgramModelBase.DS_EVALUATE)) {
            return new DSEvalBind(this.getModel(), this);
        }
        return new DSDataBind2(this.getModel(), this, uri, null);
    }
}

