/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSBaseValueBindAndBindProvider;
import com.ti.binding.program.internal.DSDebugContext;
import com.ti.binding.program.internal.DebugContextBind2;
import com.ti.binding.program.internal.ProgramModelBase;
import java.util.ArrayList;

public class DebugContextsBind
extends DSBaseValueBindAndBindProvider {
    IBindValue fBindNames;

    DebugContextsBind(ProgramModelBase model, IBindValue bindNames) {
        super(model, new ArrayList(), ArrayList.class);
        this.fBindNames = bindNames;
        this.fBindNames.addChangedListener(new IChangedListener(){

            public void onValueChanged(IFinished callback) {
                ArrayList newNames = (ArrayList)DebugContextsBind.this.fBindNames.getValue();
                DebugContextsBind.this.onNamesChanged(newNames, callback);
                if (callback != null) {
                    callback.done(null);
                }
            }
        });
        this.fBindNames.addBindListener(new IBindListener(){

            public void onStatusChanged(IStatus status) {
            }
        });
        ArrayList newNames = (ArrayList)this.fBindNames.getValue();
        this.onNamesChanged(newNames, null);
    }

    private void onNamesChanged(ArrayList<String> newNames, IFinished callback) {
        ArrayList oldValue = (ArrayList)this.getValue();
        ArrayList<DSDebugContext> newValue = new ArrayList<DSDebugContext>();
        boolean different = false;
        if (oldValue == null || oldValue.size() == 0) {
            if (newNames == null || newNames.size() == 0) {
                return;
            }
            for (String name : newNames) {
                newValue.add(new DSDebugContext(this.getModel(), name));
            }
            different = true;
        } else {
            for (String name : newNames) {
                DSDebugContext found = null;
                for (DSDebugContext obj : oldValue) {
                    if (!obj.getName().equals(name)) continue;
                    found = obj;
                    break;
                }
                if (found != null) {
                    newValue.add(found);
                    continue;
                }
                newValue.add(new DSDebugContext(this.getModel(), name));
                different = true;
            }
        }
        for (DSDebugContext oldDC : oldValue) {
            if (newValue.contains(oldDC)) continue;
            different = true;
            oldDC.dispose();
        }
        if (different) {
            this.setValue(newValue, callback);
        }
    }

    @Override
    protected IBind createNewBind(String uri) {
        return new DebugContextBind2(this.getModel(), this, uri);
    }

    void enableDebugContext(String taskId, boolean enabled) {
        ArrayList newNames;
        DebugContextBind2 bind = (DebugContextBind2)this.getInternalBindFromMap(taskId);
        if (bind != null) {
            bind.enableDebugContext(enabled);
        }
        if ((newNames = (ArrayList)this.fBindNames.getValue()) == null) {
            return;
        }
        int indexId = newNames.indexOf(taskId);
        if (indexId == -1) {
            return;
        }
        bind = (DebugContextBind2)this.getInternalBindFromMap(new Integer(indexId).toString());
        if (bind != null) {
            bind.enableDebugContext(enabled);
        }
    }
}

