/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.AbstractBindDependent;
import com.ti.backplane.internal.update.UpdateCompletedCounter;
import com.ti.binding.program.internal.DSBaseValueBindAndBindProvider;
import com.ti.binding.program.internal.IDSDataBind;
import com.ti.binding.program.internal.IDebugContext;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.binding.program.internal.ProgramModelPlugin;

class DebugTargetCache {
    final ProgramModelBase fModel;
    final IDSDataBind owner;
    final boolean verifyNeeded;
    final boolean cancellable;
    UpdateCompletedCounter updateCompletedCounter;
    IStatus status = null;
    IStatus parentStatus = null;
    AbstractBindDependent fParentBinds;
    DSBaseValueBindAndBindProvider fDebugContextBind;
    private STATE state = STATE.IDLE;
    private int writeCount = 0;

    DebugTargetCache(ProgramModelBase model, IDSDataBind theOwner, DSBaseValueBindAndBindProvider debugContextBind, boolean aVerifiyNeeded, boolean aCancellable) {
        this.fModel = model;
        this.fDebugContextBind = debugContextBind;
        this.owner = theOwner;
        this.verifyNeeded = aVerifiyNeeded;
        this.cancellable = aCancellable;
    }

    void init() {
        IBindValue enabledBind = (IBindValue)this.fDebugContextBind.getBinding(ProgramModelBase.DEBUG_CONTEXT_ENABLED);
        IBindValue refreshIdBind = (IBindValue)this.fDebugContextBind.getBinding(ProgramModelBase.DEBUG_CONTEXT_REFRESH_ID);
        this.fParentBinds = new AbstractBindDependent(new IBindValue[]{this.fDebugContextBind, enabledBind, refreshIdBind}){

            public void onValueChanged(int index, IFinished callback) {
                DebugTargetCache.this.onUpdate();
                if (callback != null) {
                    callback.done(null);
                }
            }

            public void onStatusChanged(int index, IStatus status) {
                DebugTargetCache.this.onUpdate();
            }
        };
    }

    public boolean isStale() {
        return this.state == STATE.READING || this.state == STATE.REREAD;
    }

    public void onSetValue() {
        if (this.cancellable) {
            this.owner.cancel();
            this.state = STATE.WRITING;
            ++this.writeCount;
            if (ProgramModelPlugin.DEBUG) {
                ProgramModelPlugin.debug("DebugTargetCache.onSetValue() writeCount = " + this.writeCount, IDebugFilter.DS_WRITE);
            }
            this.owner.writeValue();
            return;
        }
        if (this.state == STATE.IDLE) {
            this.state = STATE.WRITING;
            this.owner.writeValue();
        } else {
            this.state = STATE.REWRITE;
        }
    }

    private void updateParentStatus() {
        this.parentStatus = null;
        IDebugContext idmContext = this.getDebugContext();
        if (idmContext == null) {
            this.parentStatus = AbstractStatus.createErrorStatus((String)"The target has not been initialized.");
        } else {
            Object dcEnabled = this.getEnabledBind().getValue();
            if (dcEnabled == null || !(dcEnabled instanceof Boolean) || !((Boolean)dcEnabled).booleanValue()) {
                this.parentStatus = AbstractStatus.createErrorStatus((String)"Debug Context is not enabeled.");
            }
        }
    }

    private void onUpdate() {
        this.updateParentStatus();
        if (this.cancellable) {
            if (this.state != STATE.WRITING) {
                if (ProgramModelPlugin.DEBUG && this.state == STATE.READING) {
                    ProgramModelPlugin.debug("DS read request cancelled.", IDebugFilter.DS_CANCELLED_READS);
                }
                this.owner.cancel();
                this.state = STATE.READING;
                this.owner.readValue();
            }
            return;
        }
        if (this.state == STATE.IDLE) {
            this.state = STATE.READING;
            this.owner.readValue();
        } else if (this.state != STATE.REWRITE) {
            this.state = STATE.REREAD;
        }
    }

    public void forceUpdate() {
        this.onUpdate();
    }

    protected boolean equalStatus(IStatus s1, IStatus s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public void onDone(Object result, IStatus status, boolean write) {
        if (!(write || this.state != STATE.WRITING && this.state != STATE.REWRITE)) {
            if (ProgramModelPlugin.DEBUG) {
                ProgramModelPlugin.debug("DebugTargetCache.onDone(read) - ignoring the value of a read request in the midile of write request.", IDebugFilter.DS_WRITE);
            }
            return;
        }
        switch (this.state) {
            case IDLE: 
            case READING: 
            case VERIFYING: {
                this.state = STATE.IDLE;
                this.status = status;
                this.owner.assingAfterReadCompleted(result);
                if (this.updateCompletedCounter == null) break;
                this.updateCompletedCounter.dec();
                this.updateCompletedCounter = null;
                break;
            }
            case WRITING: {
                if (!this.verifyNeeded) {
                    if (this.writeCount > 0) {
                        --this.writeCount;
                    }
                    if (ProgramModelPlugin.DEBUG) {
                        ProgramModelPlugin.debug("DebugTargetCache.onDone(write) writeCount = " + this.writeCount, IDebugFilter.DS_WRITE);
                    }
                    if (this.writeCount != 0) break;
                    this.state = STATE.IDLE;
                    break;
                }
                this.state = STATE.VERIFYING;
                this.owner.readValue();
                break;
            }
            case REREAD: {
                this.state = STATE.READING;
                this.owner.readValue();
                break;
            }
            case REWRITE: {
                this.state = STATE.WRITING;
                this.owner.writeValue();
            }
        }
    }

    protected IDebugContext getDebugContext() {
        return (IDebugContext)this.fDebugContextBind.getValue();
    }

    protected String getExpression() {
        return this.owner.getExpression();
    }

    public IStatus getStatus() {
        if (this.parentStatus != null) {
            return this.parentStatus;
        }
        return this.status;
    }

    IBindValue getEnabledBind() {
        return this.fParentBinds.fBinds[1];
    }

    private static enum STATE {
        IDLE,
        READING,
        WRITING,
        REREAD,
        REWRITE,
        VERIFYING;

    }
}

