/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.AbstractBindFactroryWithStockBinds;
import com.ti.backplane.internal.DefaultMultilineBind;
import com.ti.backplane.internal.bind.DefaultBackplane;
import com.ti.backplane.internal.expressionParser.UriExpressionParser;
import com.ti.binding.program.internal.DSActiveContextNameBind;
import com.ti.binding.program.internal.DSBaseValueBind;
import com.ti.binding.program.internal.DSCPUsBind;
import com.ti.binding.program.internal.DSInitDeviceBind;
import com.ti.binding.program.internal.DSInitRunBind;
import com.ti.binding.program.internal.DSRefreshIntervalBind;
import com.ti.binding.program.internal.DSScriptActionBind;
import com.ti.binding.program.internal.DSSessionManager;
import com.ti.binding.program.internal.DSTargetConnectionsBind;
import com.ti.binding.program.internal.DSTargetDevicesBind;
import com.ti.binding.program.internal.DebugContextsBind;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.events.types.IStringEventListener;

public class ProgramModelBase
extends AbstractBindFactroryWithStockBinds
implements DSSessionManager.IDSSessionListener {
    public static final String PROGRESS_TASK_NAME = "$progress.taskName";
    public static final String PROGRESS_ACTIVITY_NAME = "$progress.activityName";
    public static final String PROGRESS_LOG_MESSAGE = "$progress.message";
    public static final String PROGRESS_TASK_PERCENT = "$progress.percent";
    public static final String PROGRESS_DETAIL = "$progress.detail";
    public static String ACTIVE_DEBUG_CONTEXT = "active";
    public static String ACTIVE_DEBUG_CONTEXT_NAME = "$active_context_name";
    public static String CPUS = "cpus";
    public static String CPU_NAMES = "$cpu_names";
    public static String DEBUG_CONTEXT_ENABLED = "$enabled";
    public static String DEBUG_CONTEXT_REFRESH_ID = "$refresh_id";
    public static String LOGGER_LAST_MESSAGE = "$logger.last_message";
    public static String LOGGER_LAST_MESSAGES = "$logger.last_messages";
    public static String LOGGER_LAST_MESSAGE_MAX_LENGTH = "$logger.last_messages.max_length";
    public static int LOGGER_LAST_MESSAGE_MAX_LENGTH_DEFAULT_VALUE = 30;
    public static String DS_INIT = "$init";
    public static String DS_INIT_PARAM_SCRIPT = "script";
    public static String DS_INIT_PARAM_CONNECTION = "connection";
    public static String DS_INIT_PARAM_DEVICE = "device";
    public static String DS_INIT_DEVICE = String.valueOf(DS_INIT) + "." + DS_INIT_PARAM_DEVICE;
    public static String DS_INIT_CONNECTION = String.valueOf(DS_INIT) + "." + DS_INIT_PARAM_CONNECTION;
    public static String DS_INTI_PARAM_APPPATH = "appPath";
    public static String DS_INTI_PARAM_TARGET_PROPERTIES = "targetProperties";
    public static String DS_INIT_SCRIPT = "$init.script";
    public static String DS_REFRESH_INTERVAL = "$refresh_interval";
    public static String DS_EXECUTE = "$execute";
    public static String DS_EXECUTE_FUNC = "func";
    public static String DS_EXECUTE_PARAMS = "params";
    public static String DS_TARGET_CONNECTIONS = "$target.connections";
    public static String DS_TARGET_CONNECTION_FILTER = "$target.connection_filter";
    public static String DS_TARGET_DEVICES = "$target.devices";
    public static String DS_TARGET_DEVICE_FILTER = "$target.device_filter";
    public static String DS_EVALUATE = "evaluate";
    private IStringEventListener onErrorListener;
    private IStringEventListener onFatalListener;
    private IStringEventListener onInfoListener;
    private IStringEventListener onWarningListener;
    static String[] INTERNAL_DC_EXPRESSIONS = new String[]{DEBUG_CONTEXT_ENABLED, DEBUG_CONTEXT_REFRESH_ID};
    static String[] STOCK_BIND_URI = new String[]{LOGGER_LAST_MESSAGE, LOGGER_LAST_MESSAGES, LOGGER_LAST_MESSAGE_MAX_LENGTH, DS_INIT_SCRIPT, "$progress.message", "$progress.taskName", "$progress.activityName", "$progress.percent", "$progress.detail"};
    static Class<?>[] STOCK_BIND_TYPE = new Class[]{String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Integer.class, String.class};
    static String[] STOCK_BIND_GLOBAL_NAME = new String[]{"PROGRAM." + LOGGER_LAST_MESSAGE, "PROGRAM." + LOGGER_LAST_MESSAGES, "PROGRAM." + LOGGER_LAST_MESSAGE_MAX_LENGTH, "PROGRAM." + DS_INIT_SCRIPT, "PROGRAM.$progress.message", "PROGRAM.$progress.taskName", "PROGRAM.$progress.activityName", "PROGRAM.$progress.percent", "PROGRAM.$progress.detail"};

    public ProgramModelBase() {
        DSSessionManager.getInstance().addSessionListener(this);
        this.createListners();
    }

    protected String[] getStockBindUri() {
        return STOCK_BIND_URI;
    }

    protected Class<?>[] getStockBindType() {
        return STOCK_BIND_TYPE;
    }

    protected String[] getStockBindGlobalName() {
        return STOCK_BIND_GLOBAL_NAME;
    }

    public IBind createNewBind(String uri) {
        if (uri.equals(DS_TARGET_CONNECTIONS)) {
            return new DSTargetConnectionsBind(this);
        }
        if (uri.equals(DS_INIT_CONNECTION)) {
            return new DSBaseValueBind(this, null, String.class);
        }
        if (uri.equals(DS_TARGET_CONNECTION_FILTER)) {
            return new DSBaseValueBind(this, ".*");
        }
        if (uri.equals(DS_TARGET_DEVICES)) {
            return new DSTargetDevicesBind(this);
        }
        if (uri.equals(DS_INIT_DEVICE)) {
            return new DSInitDeviceBind(this);
        }
        if (uri.equals(DS_TARGET_DEVICE_FILTER)) {
            return new DSBaseValueBind(this, ".*");
        }
        if (uri.equals(DS_REFRESH_INTERVAL)) {
            return new DSRefreshIntervalBind(this);
        }
        if (uri.equals(ACTIVE_DEBUG_CONTEXT_NAME)) {
            return new DSActiveContextNameBind(this);
        }
        String activeDot = String.valueOf(ACTIVE_DEBUG_CONTEXT) + '.';
        if (uri.startsWith(activeDot)) {
            String rightExpression = uri.substring(activeDot.length());
            String leftExpression = String.valueOf(CPUS) + "[" + ACTIVE_DEBUG_CONTEXT_NAME + "]";
            IBindValue lValue = (IBindValue)this.getBackplane().getBinding(leftExpression);
            return UriExpressionParser.createDotOperator((IBindValue)lValue, (String)rightExpression);
        }
        if (uri.equals(CPU_NAMES)) {
            return new DSCPUsBind(this);
        }
        if (uri.equals(CPUS)) {
            IBindValue nameBind = (IBindValue)this.getBackplane().getBinding(CPU_NAMES);
            return new DebugContextsBind(this, nameBind);
        }
        IBind stockBind = this.createStockBind(uri);
        if (stockBind != null) {
            return stockBind;
        }
        if (uri.equals(DS_INIT)) {
            return new DSInitRunBind(this);
        }
        if (uri.equals(DS_EXECUTE)) {
            return new DSScriptActionBind(this);
        }
        if (uri != null && uri.length() > 0) {
            return this.getBinding(String.valueOf(activeDot) + uri);
        }
        return null;
    }

    protected IBind createStockBind(AbstractBindFactory model, Object initialValue, Class<?> defaultType, String globalName, String uri) {
        if (uri.equals(LOGGER_LAST_MESSAGES)) {
            return new DefaultMultilineBind((AbstractBindFactory)this, initialValue, defaultType, globalName, (IBindValue)this.getBinding(LOGGER_LAST_MESSAGE_MAX_LENGTH));
        }
        if (uri.equals(LOGGER_LAST_MESSAGE_MAX_LENGTH) && initialValue == null) {
            initialValue = new Integer(LOGGER_LAST_MESSAGE_MAX_LENGTH_DEFAULT_VALUE);
        }
        return super.createStockBind(model, initialValue, defaultType, globalName, uri);
    }

    public static String getGlobalName(String uri) {
        int index = -1;
        String[] stockBindNames = STOCK_BIND_URI;
        int i = 0;
        while (i < stockBindNames.length) {
            if (uri.equals(stockBindNames[i])) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        String globalName = null;
        String[] globalNames = STOCK_BIND_GLOBAL_NAME;
        if (index < globalNames.length) {
            globalName = globalNames[index];
        }
        return globalName;
    }

    @Override
    public void onSessionStarted(String taskId) {
        this.createListners();
    }

    @Override
    public void onSessionEnding(String taskId) {
        if (DSSessionManager.getInstance().getCopyOfTaskNames().isEmpty()) {
            this.removeListners();
        }
    }

    @Override
    public void onSessionActivated(final String taskId) {
        this.getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                IBind bind = ProgramModelBase.this.findBinding(ACTIVE_DEBUG_CONTEXT_NAME);
                if (bind instanceof IBindValue) {
                    ((IBindValue)bind).setValue((Object)taskId, null);
                }
            }
        });
    }

    public void dispose() {
        DSSessionManager.getInstance().removeSessionListener(this);
        this.removeListners();
        super.dispose();
    }

    public DefaultBackplane getBackplane() {
        return (DefaultBackplane)this.fBackplane;
    }

    DSSessionManager getSessionManager() {
        return DSSessionManager.getInstance();
    }

    public void logMessage(final String message) {
        this.getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgramModelBase.this.setStockBindValue(LOGGER_LAST_MESSAGES, message);
                ProgramModelBase.this.setStockBindValue(LOGGER_LAST_MESSAGE, message);
            }
        });
    }

    public void logErrors(final String message) {
        this.getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                String fullURI = "value:backplane.$last_critical_error";
                IBindValue bind = (IBindValue)ProgramModelBase.this.getBackplane().getBinding(fullURI);
                if (bind != null) {
                    bind.setValue((Object)message, null);
                }
            }
        });
    }

    private void createListners() {
        IApplication app = DSSessionManager.getInstance().getApplication();
        if (app != null) {
            if (this.onErrorListener == null) {
                this.onErrorListener = new IStringEventListener(){

                    public void onEvent(String data) {
                        ProgramModelBase.this.logErrors(data);
                    }
                };
                app.onError().addIStringEventListener(this.onErrorListener);
            }
            if (this.onFatalListener == null) {
                this.onFatalListener = new IStringEventListener(){

                    public void onEvent(String data) {
                        ProgramModelBase.this.logErrors(data);
                    }
                };
                app.onFatal().addIStringEventListener(this.onFatalListener);
            }
            if (this.onInfoListener == null) {
                this.onInfoListener = new IStringEventListener(){

                    public void onEvent(String data) {
                        ProgramModelBase.this.logMessage(data);
                    }
                };
                app.onInfo().addIStringEventListener(this.onInfoListener);
            }
            if (this.onWarningListener == null) {
                this.onWarningListener = new IStringEventListener(){

                    public void onEvent(String data) {
                        ProgramModelBase.this.logMessage(data);
                    }
                };
                app.onWarning().addIStringEventListener(this.onWarningListener);
            }
        }
    }

    private void removeListners() {
        IApplication app = DSSessionManager.getInstance().getApplication();
        if (app != null) {
            if (this.onErrorListener != null) {
                app.onError().removeIStringEventListener(this.onErrorListener);
            }
            if (this.onFatalListener != null) {
                app.onFatal().removeIStringEventListener(this.onFatalListener);
            }
            if (this.onInfoListener != null) {
                app.onInfo().removeIStringEventListener(this.onInfoListener);
            }
            if (this.onWarningListener != null) {
                app.onWarning().removeIStringEventListener(this.onWarningListener);
            }
        }
        this.onErrorListener = null;
        this.onFatalListener = null;
        this.onInfoListener = null;
        this.onWarningListener = null;
    }

    @Override
    public void onAppConfigured() {
        this.createListners();
    }
}

