/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.internal.update.ContinuousUpdator;
import com.ti.backplane.internal.update.UpdateManager;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.ds.DSInitializer;
import com.ti.binding.program.internal.ui.provider.IDSInitializer;
import com.ti.binding.program.internal.ui.provider.IProgramModelUIDelegate;
import com.ti.common.core.BaseTIPlugin;
import java.io.PrintStream;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class ProgramModelPlugin
extends BaseTIPlugin {
    public static final String PLUGIN_ID = "com.ti.binding.program";
    public static boolean DEBUG = false;
    public static boolean[] debugComponent = new boolean[IDebugFilter.values().length];
    private static ProgramModelPlugin plugin;
    private IProgramModelUIDelegate uiDelegate;

    public static ProgramModelPlugin getDefault() {
        return plugin;
    }

    public IProgramModelUIDelegate getUIDelegate() {
        return this.uiDelegate;
    }

    private void startUpdator() {
        ContinuousUpdator continuousUpdator = UpdateManager.getInstance().getContinuousUpdator("1");
        UpdateManager.getInstance().setRefreshInterval(1000L);
        continuousUpdator.enable(true);
    }

    protected void singletonInit() {
        ProgramModelPlugin.setDSEnvironmentVariable();
        this.initTraceFlags();
        this.startUpdator();
        this.setUIProvider();
    }

    protected void singletonDispose() {
    }

    private void setUIProvider() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ti.binding.program.uiDelegate");
        if (ep == null) {
            return;
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    ProgramModelPlugin.log(e);
                }
                if (obj instanceof IProgramModelUIDelegate) {
                    this.uiDelegate = (IProgramModelUIDelegate)obj;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (this.uiDelegate == null) {
            ProgramModelPlugin.log("There are no program model UI contributions.", null);
        }
        if (this.uiDelegate != null) {
            DSInitializer parent = DSInitializer.getInstance();
            IDSInitializer dsInitializer = this.uiDelegate.getDSInitializer(parent);
            parent.setInitializer(dsInitializer);
        }
    }

    public static void log(String msg, Throwable t) {
        ProgramModelPlugin.getDefault().doLog(msg, t);
    }

    public static void log(Throwable t) {
        ProgramModelPlugin.getDefault().doLog(t);
    }

    public static void log(IStatus status) {
        ProgramModelPlugin.getDefault().doLog(status);
    }

    private void initTraceFlags() {
        DEBUG = "true".equals(Platform.getDebugOption((String)"com.ti.binding.program/debug"));
        int i = 0;
        while (i < debugComponent.length) {
            String name = IDebugFilter.values()[i].toString().toLowerCase();
            ProgramModelPlugin.debugComponent[i] = "true".equals(Platform.getDebugOption((String)("com.ti.binding.program/debug/" + name)));
            ++i;
        }
    }

    public static void debug(String debugString, IDebugFilter filterType) {
        ProgramModelPlugin.printMessage(debugString, filterType, false);
    }

    public static void debug(Throwable t, IDebugFilter filterType) {
        ProgramModelPlugin.debug(t.getMessage(), filterType);
    }

    private static void printMessage(String debugString, IDebugFilter filterType, boolean error) {
        if (DEBUG) {
            int index;
            debugString = "(" + Calendar.getInstance().getTimeInMillis() + ") " + debugString;
            PrintStream stream = System.out;
            if (error) {
                debugString = "E: " + debugString;
            }
            if (debugComponent[index = filterType.ordinal()]) {
                stream.println(String.valueOf(filterType.toString()) + ": " + debugString);
            }
        }
    }
}

