/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal;

import com.ti.backplane.internal.SharedBindValues;
import com.ti.backplane.internal.bind.DefaultRealm;
import com.ti.binding.program.internal.ProgramModelBase;
import com.ti.debug.engine.framework.Disposable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProgressLogger
extends Disposable {
    static ProgressLogger sInstance = new ProgressLogger();
    static String taskBindingName = ProgramModelBase.getGlobalName("$progress.taskName");
    static String activityBindingName = ProgramModelBase.getGlobalName("$progress.activityName");
    static String percentageBindingName = ProgramModelBase.getGlobalName("$progress.percent");
    public static String LINE_DELIMITER = "<#@sep@#>";
    private Job refreshJob;
    private String activity = "";
    private int percentage;
    private String task = "";

    public static ProgressLogger getInstance() {
        return sInstance;
    }

    private ProgressLogger() {
        this.startRefreshJob();
    }

    public void dispose() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            if (this.refreshJob.getState() != 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void startRefreshJob() {
        this.refreshJob = new Job("Refesh Progress Logger"){

            protected IStatus run(IProgressMonitor monitor) {
                ProgressLogger.this.refresh();
                if (!monitor.isCanceled()) {
                    this.schedule(500L);
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
        this.refreshJob.schedule();
    }

    private synchronized void refresh() {
        DefaultRealm.getInstance().asyncExec(new Runnable(){

            @Override
            public void run() {
                SharedBindValues.getInstance().setValue(taskBindingName, (Object)ProgressLogger.this.task);
                SharedBindValues.getInstance().setValue(activityBindingName, (Object)ProgressLogger.this.activity);
                SharedBindValues.getInstance().setValue(percentageBindingName, (Object)ProgressLogger.this.percentage);
            }
        });
    }

    public void writeLog(String task, String activity, int percentage) {
        if (this.task.isEmpty() || this.task.equals(task)) {
            this.task = task;
            this.activity = activity;
            this.percentage = percentage;
        }
    }

    public void removeLog(String id) {
        if (this.task.equals(id)) {
            this.task = "";
            this.activity = "";
            this.percentage = 0;
        }
    }

    class Log {
        String activity;
        int percentage;

        Log() {
        }
    }
}

