/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.binding.program.internal.ds.ExpressionException;
import com.ti.binding.program.internal.ds.GlobalArithmeticData;
import com.ti.debug.engine.IArrayType;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ILValue;
import com.ti.debug.engine.ILocation;
import com.ti.debug.engine.IRawMemoryRange;
import com.ti.debug.engine.IType;
import com.ti.debug.engine.IValue;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.xpcom.XPCOMException;

class DSExpressionData {
    ILValue lValue;
    IType theType;
    boolean isArithmeticType;
    boolean isArrayType;
    boolean isEnumType;
    boolean isPointer;
    boolean isChar;
    boolean isArrayOfArithmeticType;
    ILocation location;
    IValue addressValue;
    IDspValue addressDspValue;
    IRawMemoryRange rawMemoryRange;
    int numElements = -1;
    Object targetValue;

    DSExpressionData(IExpressionEvaluationData data, boolean readAllInfo, boolean useNewImplementation) throws ExpressionException {
        try {
            String errorMessage = data.getErrorMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                throw new ExpressionException(errorMessage);
            }
            this.lValue = data.getLValue();
            if (this.lValue == null) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            this.theType = this.lValue.getType();
            if (this.theType == null) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            this.isArithmeticType = this.theType.isArithmetic();
            this.isEnumType = this.theType.isEnum();
            this.isArrayType = this.theType.isArray();
            this.isPointer = this.theType.isPointer();
            IType elementType = null;
            if (this.isArrayType) {
                IArrayType arrayType = this.theType.getArrayType();
                elementType = arrayType.getElementType();
                this.numElements = arrayType.getNumElements();
            }
            if (this.isPointer) {
                elementType = this.theType.getPointerType().getReferentType();
            }
            if (elementType != null) {
                String refname = elementType.getString();
                this.isChar = refname.endsWith("char");
                if (!this.isChar) {
                    this.isArrayOfArithmeticType = elementType.isArithmetic();
                }
            }
            if (useNewImplementation) {
                if (this.theType.isReference()) {
                    this.theType = this.theType.getReferenceType().getReferentType();
                }
                if (!(!this.lValue.hasValue() || this.isArrayType || this.isChar || this.theType.isVoid() || this.theType.isCompound())) {
                    IDspValue dspValue = data.getTargetData();
                    IDspValue.Type dspEnumType = dspValue.getEnumType();
                    this.targetValue = GlobalArithmeticData.isFloatType(dspEnumType) ? (Number)new Double(dspValue.toDouble()) : (Number)dspValue.toLongLong();
                    return;
                }
            }
            if (!this.lValue.hasLocation()) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            if (!(this.isArrayType || this.isArithmeticType || this.isEnumType || this.isChar)) {
                throw new ExpressionException("Only global variables or arrays are allowed.");
            }
            if (!readAllInfo) {
                return;
            }
            this.location = this.lValue.getLocation();
            if (this.location == null) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            this.addressValue = this.location.getAddress();
            if (this.addressValue == null) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            this.addressDspValue = this.addressValue.getDspValue();
            if (this.addressDspValue == null) {
                throw new ExpressionException("The expression has to be assignable.");
            }
            this.rawMemoryRange = this.location.getRawMemoryRange();
            if (this.rawMemoryRange == null) {
                throw new ExpressionException("The variable does not reside in memory.");
            }
        }
        catch (XPCOMException xPCOMException) {
            throw new ExpressionException("There is no debug session. XPCOM exception thrown.");
        }
    }
}

