/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSInitScriptInfo;
import com.ti.binding.program.internal.ErrorReporter;
import com.ti.binding.program.internal.ds.IDSErrorReporter;
import com.ti.binding.program.internal.ui.provider.IDSInitializer;
import com.ti.binding.program.internal.ui.provider.IDSInitializerParent;

public class DSInitializer
implements IDSInitializerParent {
    static DSInitializer sInstance = new DSInitializer();
    IDSErrorReporter errorReporter;
    IDSInitializer initializer;
    boolean isRestarting = false;

    public static DSInitializer getInstance() {
        return sInstance;
    }

    public void setInitializer(IDSInitializer initializer) {
        this.initializer = initializer;
    }

    public IStatus restart(DSInitScriptInfo info, IDSErrorReporter er) {
        if (this.isRestarting) {
            return AbstractStatus.createErrorStatus((String)"Program is currently restarting...");
        }
        if (this.initializer == null) {
            return AbstractStatus.createErrorStatus((String)"Program Model is not initialzed properly...");
        }
        this.isRestarting = true;
        this.errorReporter = er;
        IStatus ret = null;
        try {
            ret = this.initializer.restart(info);
        }
        finally {
            this.isRestarting = false;
        }
        this.errorReporter = null;
        return ret;
    }

    @Override
    public void reportError(String message) {
        if (this.errorReporter != null) {
            this.errorReporter.log(message);
        }
        ErrorReporter.report(message);
    }

    public boolean isRestarting() {
        return this.isRestarting;
    }
}

