/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.bind.Status;
import com.ti.binding.program.internal.DSInitScriptInfo;
import com.ti.binding.program.internal.DSSessionManager;
import com.ti.binding.program.internal.ErrorReporter;
import com.ti.binding.program.internal.ProgressLogger;
import com.ti.binding.program.internal.ds.DSScriptExecutor;
import com.ti.binding.program.internal.ds.IDSPrompter;
import com.ti.binding.program.internal.ds.IScriptWriter;
import com.ti.binding.program.internal.ui.provider.IDSInitializer;
import com.ti.binding.program.internal.ui.provider.IDSInitializerParent;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspBoard;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.IProgressTask;
import com.ti.debug.engine.cce.CCEDebugEngine;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.data.IProgressTaskData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.xpcom.XPCOMException;
import java.io.File;
import java.util.ArrayList;

public class DSInitializerRCP
implements IDSInitializer {
    IApplication app;
    IDspTask[] tasks;
    int cpuCount;
    IDSInitializerParent parent;
    boolean termiateCompleted = true;
    IDSPrompter prompter;
    boolean failed = false;
    DSInitScriptInfo lastScriptInfo;
    private OnTaskStartedListener onTaskStarted;
    private IStringEventListener onErrorListener;
    private IStringEventListener onFatalListener;
    private IStringEventListener onInfoListener;
    private IStringEventListener onWarningListener;

    public DSInitializerRCP(IDSInitializerParent parent) {
        this.parent = parent;
    }

    private IStatus start(DSInitScriptInfo info) {
        final Status[] dsErrorStatus = new Status[1];
        try {
            this.lastScriptInfo = info;
            this.tasks = null;
            this.cpuCount = 0;
            IScriptWriter writer = new IScriptWriter(){

                @Override
                public void write(String message) {
                    DSInitializerRCP.this.parent.reportError(message);
                }
            };
            this.app = new CCEDebugEngine.Factory().createInstance();
            DSScriptExecutor se = new DSScriptExecutor();
            this.onErrorListener = new IStringEventListener(){

                public void onEvent(String data) {
                    dsErrorStatus[0] = new ErrorStatus(data);
                }
            };
            this.onFatalListener = new IStringEventListener(){

                public void onEvent(String data) {
                    dsErrorStatus[0] = new ErrorStatus(data);
                }
            };
            this.onInfoListener = new IStringEventListener(){

                public void onEvent(String data) {
                    DSInitializerRCP.this.parent.reportError(String.valueOf(data) + "\n");
                }
            };
            this.onWarningListener = new IStringEventListener(){

                public void onEvent(String data) {
                    DSInitializerRCP.this.parent.reportError(String.valueOf(data) + "\n");
                }
            };
            this.onTaskStarted = new OnTaskStartedListener();
            this.app.onTaskStart().addIObjectEventListener((IObjectEventListener)this.onTaskStarted);
            this.app.onError().addIStringEventListener(this.onErrorListener);
            this.app.onFatal().addIStringEventListener(this.onFatalListener);
            this.app.onInfo().addIStringEventListener(this.onInfoListener);
            this.app.onWarning().addIStringEventListener(this.onWarningListener);
            IStatus errorStatus = se.run(info, writer);
            if (errorStatus != null) {
                this.app = null;
                writer.write(errorStatus.getMessage());
                return errorStatus;
            }
            if (dsErrorStatus[0] != null) {
                this.app = null;
                writer.write(dsErrorStatus[0].getMessage());
                return dsErrorStatus[0];
            }
            ArrayList<IDspTask> dspTasks = new ArrayList<IDspTask>();
            IDspBoards coDspBoards = this.app.getDspBoards();
            int i = 0;
            int nBoards = coDspBoards.getCount();
            while (i < nBoards) {
                IDspBoard coDspBoard = coDspBoards.getItem(i);
                IDspTasks coDspTasks = coDspBoard.getDspTasks();
                int j = 0;
                int nTasks = coDspTasks.getCount();
                while (j < nTasks) {
                    IDspTask coDspTask = coDspTasks.getItem(j);
                    dspTasks.add(coDspTask);
                    ++j;
                }
                ++i;
            }
            this.cpuCount = dspTasks.size();
            this.tasks = new IDspTask[this.cpuCount];
            i = 0;
            while (i < this.cpuCount) {
                this.tasks[i] = (IDspTask)dspTasks.get(i);
                ++i;
            }
        }
        catch (Exception e) {
            this.failed = true;
            this.tasks = null;
            this.cpuCount = 0;
            this.app = null;
            this.parent.reportError("Program Init Error:" + e);
            return AbstractStatus.createErrorStatus((String)e.getMessage());
        }
        this.notifyDSSessionManager();
        return null;
    }

    void notifyDSSessionManager() {
        try {
            IDspTask[] iDspTaskArray = this.tasks;
            int n = this.tasks.length;
            int n2 = 0;
            while (n2 < n) {
                IDspTask task = iDspTaskArray[n2];
                String taskId = task.getFullPathName();
                DSSessionManager.getInstance().fireSessionStarted(task, taskId);
                ++n2;
            }
            DSSessionManager.getInstance().fireAppConfigured(this.app);
            if (this.tasks != null && this.tasks.length > 0) {
                DSSessionManager.getInstance().fireSessionActivated(this.tasks[0], this.tasks[0].getFullPathName());
            }
        }
        catch (XPCOMException e) {
            ErrorReporter.report("DSDebugSession.notifyDSSessionManager() exception" + (Object)((Object)e));
        }
    }

    public void terminate() {
        DSSessionManager.getInstance().fireSessionActivated(null, null);
        if (this.tasks != null) {
            IDspTask[] iDspTaskArray = this.tasks;
            int n = this.tasks.length;
            int n2 = 0;
            while (n2 < n) {
                IDspTask task = iDspTaskArray[n2];
                String taskId = task.getFullPathName();
                DSSessionManager.getInstance().fireSessionEnding(task, taskId);
                ++n2;
            }
        }
        this.disconnectFromDS();
    }

    public void disconnectFromDS() {
        if (this.app != null) {
            this.termiateCompleted = false;
            try {
                this.runEndScript();
                this.app.deConfigure(new ISimpleEventListener(){

                    public void onEvent() {
                        DSInitializerRCP.this.termiateCompleted = true;
                    }
                });
            }
            catch (Exception e) {
                this.parent.reportError("Program Termiate Exception:" + e);
                this.termiateCompleted = true;
            }
            this.app = null;
        }
        while (!this.termiateCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setPrompter(IDSPrompter prompter) {
        this.prompter = prompter;
    }

    private void runEndScript() {
        try {
            if (this.lastScriptInfo == null) {
                return;
            }
            String path = this.lastScriptInfo.getEndScriptPath();
            if (!new File(path).exists()) {
                return;
            }
            IScriptWriter writer = new IScriptWriter(){

                @Override
                public void write(String message) {
                    ErrorReporter.report(message);
                }
            };
            DSScriptExecutor se = new DSScriptExecutor();
            DSInitScriptInfo endInfo = this.lastScriptInfo.createEndScript();
            IStatus errorStatus = se.run(endInfo, writer);
            if (errorStatus != null) {
                ErrorReporter.report(errorStatus.getMessage());
            }
        }
        catch (Throwable e) {
            ErrorReporter.report(e.getMessage());
        }
    }

    public boolean hasDebugSession() {
        return this.app != null;
    }

    @Override
    public IStatus restart(DSInitScriptInfo info) {
        if (this.hasDebugSession() && this.lastScriptInfo != null && this.prompter != null) {
            String message = "Application '" + this.lastScriptInfo.getAppName() + "' is currently running.\n";
            boolean sameApp = info.getAppName().equals(this.lastScriptInfo.getAppName());
            message = sameApp ? String.valueOf(message) + "Would you like to restart it?" : String.valueOf(message) + "Would you like to run the application '" + info.getAppName() + "' instead?";
            if (!sameApp && this.prompter.prompt("Restart Application", message) == IDSPrompter.Result.no) {
                String errorMsg = "Restart Cancelled. Application '" + this.lastScriptInfo.getAppName() + "' remains running.\n";
                this.parent.reportError(errorMsg);
                return AbstractStatus.createErrorStatus((String)errorMsg);
            }
        }
        this.terminate();
        return this.start(info);
    }

    class OnTaskChangedListener
    implements IObjectEventListener<IEventData<IProgressTaskData>> {
        public String taskName;

        public OnTaskChangedListener(String name) {
            this.taskName = name;
        }

        public void onEvent(IEventData<IProgressTaskData> data) {
            IProgressTaskData taskData = (IProgressTaskData)data.getEventData();
            int percentDone = taskData.getPercentDone();
            String subActivity = taskData.getSubActivity();
            if (percentDone == 0 || percentDone == 100) {
                ProgressLogger.getInstance().removeLog(this.taskName);
            } else {
                ProgressLogger.getInstance().writeLog(this.taskName, subActivity, percentDone);
            }
        }
    }

    class OnTaskStartedListener
    implements IObjectEventListener<IEventData<IProgressTask>> {
        private IStringEventListener onTaskCompletedListener;
        private OnTaskChangedListener onTaskChangedListener;

        OnTaskStartedListener() {
        }

        public void onEvent(IEventData<IProgressTask> data) {
            IProgressTask task = (IProgressTask)data.getEventData();
            final String name = task.getName();
            this.onTaskCompletedListener = new IStringEventListener(){

                public void onEvent(String error) {
                    ProgressLogger.getInstance().removeLog(name);
                }
            };
            this.onTaskChangedListener = new OnTaskChangedListener(name);
            task.onCompleted().addIStringEventListener(this.onTaskCompletedListener);
            task.onUpdate().addIObjectEventListener((IObjectEventListener)this.onTaskChangedListener);
        }
    }
}

