/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.DSScriptInfo;
import com.ti.binding.program.internal.ds.IScriptWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;

public class DSScriptExecutor {
    public IStatus run(DSScriptInfo info, IScriptWriter writer) {
        return this.run(info, writer, null);
    }

    public IStatus run(DSScriptInfo info, IScriptWriter writer, Object[] result) {
        String infoText = info.getText();
        if (info.getPath() == null && infoText == null) {
            String errorMsg = "Script path or text is not specified.";
            writer.write(errorMsg);
            return AbstractStatus.createErrorStatus((String)errorMsg);
        }
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine jsEngine = mgr.getEngineByName("JavaScript");
            byte[] encoded = Files.readAllBytes(Paths.get(info.getPath(), new String[0]));
            String str = new String(encoded, StandardCharsets.UTF_8);
            if (!System.getProperty("java.version").startsWith("1.7")) {
                str = "load(\"nashorn:mozilla_compat.js\");\n" + str;
            }
            MyWriter myErrW = new MyWriter(writer);
            MyWriter myOutW = new MyWriter(writer);
            MyScriptContext myContext = new MyScriptContext(myOutW, myErrW);
            Bindings bindings = jsEngine.createBindings();
            for (Map.Entry<String, String> entry : info.getVars().entrySet()) {
                bindings.put(entry.getKey(), (Object)entry.getValue());
            }
            myContext.setBindings(bindings, 100);
            Object ret = null;
            if (info.getPath() != null) {
                ret = jsEngine.eval(str, (ScriptContext)myContext);
            }
            if (infoText != null) {
                ret = jsEngine.eval(infoText, (ScriptContext)myContext);
            }
            if (result != null && result.length > 0) {
                result[0] = ret;
            }
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            writer.write(errorMessage);
            return AbstractStatus.createErrorStatus((String)errorMessage);
        }
        return null;
    }

    class MyScriptContext
    extends SimpleScriptContext {
        Writer errW = null;
        Writer outW = null;

        MyScriptContext(MyWriter outW, MyWriter errW) {
            this.outW = new PrintWriter(outW);
            this.errW = new PrintWriter(errW);
        }

        @Override
        public synchronized Writer getErrorWriter() {
            return this.errW;
        }

        @Override
        public synchronized Writer getWriter() {
            return this.outW;
        }
    }

    class MyWriter
    extends Writer {
        IScriptWriter writer;

        MyWriter(IScriptWriter writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] csq, int start, int end) throws IOException {
            if (this.writer != null) {
                String message = new String(Arrays.copyOfRange(csq, start, end));
                this.writer.write(message);
            }
        }
    }
}

