/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.update.ContinuousUpdator;
import com.ti.backplane.internal.update.IUpdateCompletedCallback;
import com.ti.backplane.internal.update.IUpdateListener;
import com.ti.backplane.internal.update.UpdateCompletedCounter;
import com.ti.backplane.internal.update.UpdateManager;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelPlugin;
import com.ti.binding.program.internal.ds.BaseExpressionData;
import com.ti.binding.program.internal.ds.DSArithmeticExpressionData;
import com.ti.binding.program.internal.ds.DSArrayExpressionData;
import com.ti.binding.program.internal.ds.DSCancellabeWrapper;
import com.ti.binding.program.internal.ds.DSExpressionData;
import com.ti.binding.program.internal.ds.ExpressionException;
import com.ti.binding.program.internal.ds.GlobalArithmeticData;
import com.ti.binding.program.internal.ds.GlobalArrayArrayArithmeticData;
import com.ti.binding.program.internal.ds.GlobalStringData;
import com.ti.binding.program.internal.ds.InvalidExpressionData;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IExpressionEvaluator;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.ITransaction;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.xpcom.XPCOMException;
import java.util.ArrayList;
import java.util.HashMap;

public class DSTask {
    static final String EXPR_ERR_NO_LVALUE = "The expression has to be assignable.";
    static final String EXPR_ERR_TYPE_NOT_SUPPORTED = "Only global variables or arrays are allowed.";
    static final String EXPR_ERR_NO_DEBUGGER = "There is no debug session. XPCOM exception thrown.";
    static final String EXPR_VARIABLE_NOT_IN_MEMORY = "The variable does not reside in memory.";
    static final String EXPR_CANNOT_READ_TARGET_MEMORY = "The target cannot be read.";
    static final int LENGTH_UNKNOWN = -1;
    static final int LENGTH_STRING_BATCH = 32;
    IDspTask task;
    IDspUser user;
    IMemoryAccess ma;
    IExpressionEvaluator eval;
    boolean initSucceeded = false;
    IBooleanEventListener onNewSymbolsListener = null;
    ISimpleEventListener executionStateChangeListener = null;
    IObjectEventListener<IRefreshEventData> onRefreshWithReasnoListener = null;
    ISimpleEventListener onTargetDisconnectedListener = null;
    String fullPathName = "";
    static final String VIEW_ID = "GUI composer";
    ContinuousUpdator continuousUpdator;
    ArrayList<IUpdateListener> updateListeners = new ArrayList();

    public DSTask(IDspTask dspTask) {
        try {
            this.task = dspTask;
            this.continuousUpdator = UpdateManager.getInstance().getContinuousUpdator("1");
            this.fullPathName = "";
            this.cacheTaskData();
            this.addDSListeners();
            this.initSucceeded = true;
        }
        catch (XPCOMException xPCOMException) {}
    }

    public boolean initialzed() {
        return this.initSucceeded;
    }

    void cacheTaskData() {
        this.fullPathName = this.task.getFullPathName();
        this.user = this.task.createDspUser();
        this.ma = this.task.getMemoryAccess();
        this.eval = this.task.getExpressionEvaluator();
    }

    void addDSListeners() {
        this.onNewSymbolsListener = new IBooleanEventListener(){

            public void onEvent(boolean data) {
                if (DSTask.this.updateListeners.size() == 0) {
                    return;
                }
                DSTask.this.onUpdate(null);
            }
        };
        this.user.onNewSymbols().addIBooleanEventListener(this.onNewSymbolsListener);
        this.executionStateChangeListener = new ISimpleEventListener(){

            public void onEvent() {
                DSTask.this.enableContinuousRefrehs(!DSTask.this.isTargetHalted());
            }
        };
        this.user.onExecutionStatusChanged().addISimpleEventListener(this.executionStateChangeListener);
        this.onRefreshWithReasnoListener = new IObjectEventListener<IRefreshEventData>(){

            public void onEvent(IRefreshEventData data) {
                if (data == null) {
                    return;
                }
                if (DSTask.this.updateListeners.size() == 0) {
                    return;
                }
                ITransaction transaction = DSTask.this.user.beginRefresh();
                if (ProgramModelPlugin.DEBUG) {
                    ProgramModelPlugin.debug("onRefreshWithReason.begingRefresh()", IDebugFilter.DS_UPDATE);
                }
                DSTask.this.onUpdate(transaction);
            }
        };
        this.onTargetDisconnectedListener = new ISimpleEventListener(){

            public void onEvent() {
                if (DSTask.this.updateListeners.size() == 0) {
                    return;
                }
                DSTask.this.onUpdate(null);
            }
        };
        this.user.onRefreshWithReason().addIObjectEventListener(this.onRefreshWithReasnoListener);
        this.task.getTargetConnection().onDisconnected().addISimpleEventListener(this.onTargetDisconnectedListener);
        this.enableContinuousRefrehs(!this.isTargetHalted());
    }

    private void onUpdate(final ITransaction transaction) {
        this.waitForAllListeners(new IUpdateCompletedCallback(){

            public void done() {
                if (transaction != null) {
                    transaction.dispose();
                }
            }
        });
    }

    boolean waitForAllListeners(IUpdateCompletedCallback updateCompletedCallback) {
        int listenerSize = this.updateListeners.size();
        if (listenerSize == 0) {
            return false;
        }
        final UpdateCompletedCounter updateCompletedCounter = new UpdateCompletedCounter(listenerSize, updateCompletedCallback);
        int i = 0;
        while (i < listenerSize) {
            this.updateListeners.get(i).update(new IUpdateCompletedCallback(){

                public void done() {
                    updateCompletedCounter.dec();
                }
            });
            ++i;
        }
        return true;
    }

    void enableContinuousRefrehs(boolean enable) {
        int i = 0;
        while (i < this.updateListeners.size()) {
            this.continuousUpdator.enableListener(this.updateListeners.get(i), enable);
            ++i;
        }
    }

    void removeDSLiseners() {
        if (this.executionStateChangeListener != null) {
            this.user.onExecutionStatusChanged().removeISimpleEventListener(this.executionStateChangeListener);
            this.executionStateChangeListener = null;
        }
        if (this.onNewSymbolsListener != null) {
            this.user.onNewSymbols().removeIBooleanEventListener(this.onNewSymbolsListener);
            this.onNewSymbolsListener = null;
        }
        if (this.onRefreshWithReasnoListener != null) {
            this.user.onRefreshWithReason().removeIObjectEventListener(this.onRefreshWithReasnoListener);
            this.onRefreshWithReasnoListener = null;
        }
        if (this.onTargetDisconnectedListener != null) {
            this.task.getTargetConnection().onDisconnected().removeISimpleEventListener(this.onTargetDisconnectedListener);
            this.onTargetDisconnectedListener = null;
        }
    }

    public void dispose() {
        try {
            this.removeAllListeners();
            this.removeDSLiseners();
        }
        catch (XPCOMException xPCOMException) {}
    }

    public ICancelable requestSet(String expression, final Object value, final IRequestCompletedCallback callback) {
        if (ProgramModelPlugin.DEBUG && DSTask.isExressionLogged(expression)) {
            ProgramModelPlugin.debug("requestSet(" + expression + "=" + value + ")", IDebugFilter.DS_WRITE);
        }
        long requestStartTime = 0L;
        if (ProgramModelPlugin.DEBUG) {
            requestStartTime = System.currentTimeMillis();
        }
        final long tempRequestStartTime = requestStartTime;
        if (value instanceof Number) {
            final CancelCoordinator cc = new CancelCoordinator();
            DSCancellabeWrapper dsCW = new DSCancellabeWrapper(expression);
            String assingExression = "( " + expression + " ) = " + ((Number)value).toString();
            com.ti.debug.engine.ICancelable dsCancelable = this.eval.requestEvaluation(assingExression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                public void onEvent(IExpressionEvaluationData data) {
                    if (cc.isCanceled()) {
                        callback.done(null, null);
                        return;
                    }
                    String errorMessage = data.getErrorMessage();
                    if (errorMessage != null && errorMessage.length() > 0) {
                        callback.done(null, AbstractStatus.createErrorStatus((String)errorMessage));
                        return;
                    }
                    callback.done(null, null);
                }
            });
            dsCW.addDSCancelable(dsCancelable);
            return cc;
        }
        final CancelCoordinator cc = new CancelCoordinator();
        this.addExpression(expression, new IRequestCompletedCallback(){

            @Override
            public void done(Object retValue, IStatus status) {
                if (ProgramModelPlugin.DEBUG) {
                    long elapsed = System.currentTimeMillis() - tempRequestStartTime;
                    ProgramModelPlugin.debug("add completed in " + elapsed + "ms", IDebugFilter.DS_WRITE);
                }
                if (status != null) {
                    if (ProgramModelPlugin.DEBUG) {
                        ProgramModelPlugin.debug("requestSet failed " + status.getMessage(), IDebugFilter.DS_WRITE);
                    }
                    callback.done(null, status);
                    return;
                }
                BaseExpressionData exprData = (BaseExpressionData)retValue;
                ICancelable c1 = exprData.reguestSet(value, callback, cc);
                cc.setServerCancelable(c1);
            }
        }, cc);
        return cc;
    }

    public ICancelable requestGet(String expression, IRequestCompletedCallback callback) {
        if (ProgramModelPlugin.DEBUG) {
            ProgramModelPlugin.debug("requestGet(" + expression + ")", IDebugFilter.DS_READ);
        }
        return this.requestGet2(expression, callback);
    }

    public ICancelable requestGet2(final String expression, final IRequestCompletedCallback callbackTop) {
        Statistics.addReadCount(expression);
        final CancelCoordinator cc = new CancelCoordinator();
        final IRequestCompletedCallback callback = new IRequestCompletedCallback(){

            @Override
            public void done(Object retValue, IStatus status) {
                if (status != null) {
                    if (ProgramModelPlugin.DEBUG) {
                        ProgramModelPlugin.debug("addExpression failed " + status.getMessage(), IDebugFilter.DS_ADD_EXPRESSION);
                    }
                    callbackTop.done(null, status);
                    return;
                }
                BaseExpressionData exprData = (BaseExpressionData)retValue;
                if (exprData != null) {
                    ICancelable c1 = exprData.reguestGet(callbackTop, cc);
                    cc.setServerCancelable(c1);
                }
            }
        };
        final DSCancellabeWrapper dsCW = new DSCancellabeWrapper(expression);
        com.ti.debug.engine.ICancelable dsCancelable = this.eval.requestEvaluation(expression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

            public void onEvent(IExpressionEvaluationData data) {
                if (cc.isCanceled()) {
                    callback.done(null, null);
                    return;
                }
                BaseExpressionData expr = null;
                try {
                    final DSExpressionData dsExprData = new DSExpressionData(data, true, true);
                    if (dsExprData.targetValue != null) {
                        callbackTop.done(dsExprData.targetValue, null);
                        return;
                    }
                    if (dsExprData.isArithmeticType || dsExprData.isEnumType) {
                        DSArithmeticExpressionData dsArithmeticData = new DSArithmeticExpressionData(data, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                        expr = new GlobalArithmeticData(DSTask.this, expression, 1, dsExprData.addressDspValue, dsArithmeticData, false);
                    } else if (dsExprData.isChar) {
                        DSArithmeticExpressionData dsArithmeticData = new DSArithmeticExpressionData(data, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                        expr = new GlobalStringData(DSTask.this, expression, dsExprData.numElements, dsExprData.addressDspValue, dsArithmeticData, dsExprData.isArrayType);
                    } else if (dsExprData.isArrayType) {
                        final DSArrayExpressionData dsArrayData = new DSArrayExpressionData(data, dsExprData);
                        String firstElementExpression = "(" + expression + ")[0]";
                        com.ti.debug.engine.ICancelable dsCancelable2 = DSTask.this.eval.requestEvaluation(firstElementExpression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                            public void onEvent(IExpressionEvaluationData dataElement) {
                                if (cc.isCanceled()) {
                                    callback.done(null, null);
                                    return;
                                }
                                BaseExpressionData elementExpr = null;
                                try {
                                    DSExpressionData root = new DSExpressionData(dataElement, false, false);
                                    if (root.isArrayOfArithmeticType) {
                                        new GlobalArrayArrayArithmeticData(DSTask.this, expression, dsExprData, callback, cc);
                                    } else if (root.isChar) {
                                        new GlobalArrayArrayArithmeticData(DSTask.this, expression, dsExprData, callback, cc);
                                    } else {
                                        DSArithmeticExpressionData dsElementArithmData = new DSArithmeticExpressionData(dataElement, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                                        elementExpr = new GlobalArithmeticData(DSTask.this, expression, dsArrayData.numElements, dsExprData.addressDspValue, dsElementArithmData, true);
                                    }
                                }
                                catch (ExpressionException e) {
                                    elementExpr = DSTask.this.createInvalidExpression(expression, e.getMessage());
                                }
                                if (elementExpr != null) {
                                    callback.done(elementExpr, null);
                                }
                            }
                        });
                        dsCW.addDSCancelable(dsCancelable2);
                    }
                }
                catch (ExpressionException e) {
                    expr = DSTask.this.createInvalidExpression(expression, e.getMessage());
                }
                if (expr != null) {
                    callback.done(expr, null);
                }
            }
        });
        dsCW.addDSCancelable(dsCancelable);
        return cc;
    }

    ICancelable addExpression(final String expression, final IRequestCompletedCallback callback, final CancelCoordinator cc) {
        final DSCancellabeWrapper dsCW = new DSCancellabeWrapper(expression);
        com.ti.debug.engine.ICancelable dsCancelable = this.eval.requestEvaluation(expression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

            public void onEvent(IExpressionEvaluationData data) {
                if (cc.isCanceled()) {
                    callback.done(null, null);
                    return;
                }
                BaseExpressionData expr = null;
                try {
                    final DSExpressionData dsExprData = new DSExpressionData(data, true, false);
                    if (dsExprData.isArithmeticType || dsExprData.isEnumType) {
                        DSArithmeticExpressionData dsArithmeticData = new DSArithmeticExpressionData(data, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                        expr = new GlobalArithmeticData(DSTask.this, expression, 1, dsExprData.addressDspValue, dsArithmeticData, false);
                    } else if (dsExprData.isChar) {
                        DSArithmeticExpressionData dsArithmeticData = new DSArithmeticExpressionData(data, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                        expr = new GlobalStringData(DSTask.this, expression, dsExprData.numElements, dsExprData.addressDspValue, dsArithmeticData, dsExprData.isArrayType);
                    } else if (dsExprData.isArrayType) {
                        final DSArrayExpressionData dsArrayData = new DSArrayExpressionData(data, dsExprData);
                        String firstElementExpression = "(" + expression + ")[0]";
                        com.ti.debug.engine.ICancelable dsCancelable2 = DSTask.this.eval.requestEvaluation(firstElementExpression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                            public void onEvent(IExpressionEvaluationData dataElement) {
                                if (cc.isCanceled()) {
                                    callback.done(null, null);
                                    return;
                                }
                                BaseExpressionData elementExpr = null;
                                try {
                                    DSExpressionData root = new DSExpressionData(dataElement, false, false);
                                    if (root.isArrayOfArithmeticType) {
                                        new GlobalArrayArrayArithmeticData(DSTask.this, expression, dsExprData, callback, cc);
                                    } else if (root.isChar) {
                                        new GlobalArrayArrayArithmeticData(DSTask.this, expression, dsExprData, callback, cc);
                                    } else {
                                        DSArithmeticExpressionData dsElementArithmData = new DSArithmeticExpressionData(dataElement, dsExprData.rawMemoryRange, dsExprData.addressDspValue);
                                        elementExpr = new GlobalArithmeticData(DSTask.this, expression, dsArrayData.numElements, dsExprData.addressDspValue, dsElementArithmData, true);
                                    }
                                }
                                catch (ExpressionException e) {
                                    elementExpr = DSTask.this.createInvalidExpression(expression, e.getMessage());
                                }
                                if (elementExpr != null) {
                                    callback.done(elementExpr, null);
                                }
                            }
                        });
                        dsCW.addDSCancelable(dsCancelable2);
                    }
                }
                catch (ExpressionException e) {
                    expr = DSTask.this.createInvalidExpression(expression, e.getMessage());
                }
                if (expr != null) {
                    callback.done(expr, null);
                }
            }
        });
        dsCW.addDSCancelable(dsCancelable);
        return dsCW;
    }

    private InvalidExpressionData createInvalidExpression(String expression, String errorMessage) {
        return new InvalidExpressionData(this, expression, errorMessage);
    }

    public void addUpdateListener(IUpdateListener listener) {
        this.updateListeners.add(listener);
        this.continuousUpdator.addUpdateListener(listener, !this.isTargetHalted());
    }

    public void removeUpdateListener(IUpdateListener listener) {
        this.updateListeners.remove(listener);
        this.continuousUpdator.removeUpdateListener(listener);
    }

    void removeAllListeners() {
        for (IUpdateListener l : this.updateListeners) {
            this.continuousUpdator.removeUpdateListener(l);
        }
        this.updateListeners.clear();
    }

    boolean isTargetHalted() {
        try {
            boolean[] OUT_powered = new boolean[]{true};
            boolean[] OUT_secured = new boolean[1];
            int detailedRunningState = this.user.getTaskRunningState3(OUT_powered, OUT_secured);
            return detailedRunningState == 0;
        }
        catch (XPCOMException xPCOMException) {
            return false;
        }
    }

    public String getId() {
        return this.fullPathName;
    }

    public static boolean isExressionLogged(String expression) {
        return true;
    }

    class CancelCoordinator
    implements ICancelable,
    ICancelState {
        ICancelable serverCancelable;
        boolean isCanceled;

        CancelCoordinator() {
        }

        @Override
        public boolean cancel() {
            this.isCanceled = true;
            if (this.serverCancelable != null) {
                return this.serverCancelable.cancel();
            }
            return true;
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        void setServerCancelable(ICancelable serverCancelable) {
            this.serverCancelable = serverCancelable;
        }
    }

    static interface ICancelState {
        public boolean isCanceled();
    }

    public static class Statistics {
        private static HashMap<String, Long> map = new HashMap();

        public static synchronized void resetReadCount() {
            map = new HashMap();
        }

        public static synchronized long getReadCount(String var) {
            Long count = map.get(var);
            return count != null ? count : 0L;
        }

        public static synchronized void addReadCount(String var) {
            Long count = map.get(var);
            if (count == null) {
                map.put(var, new Long(1L));
            } else {
                long newValue = count + 1L;
                map.put(var, new Long(newValue));
            }
        }
    }
}

