/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelPlugin;
import com.ti.binding.program.internal.ds.DSArithmeticExpressionData;
import com.ti.binding.program.internal.ds.DSCancellabeWrapper;
import com.ti.binding.program.internal.ds.DSTask;
import com.ti.binding.program.internal.ds.GlobalExpressionData;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.xpcom.XPCOMException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class GlobalArithmeticData
extends GlobalExpressionData {
    GlobalArithmeticData(DSTask owner, String expression, int length, IDspValue addressDspValue, DSArithmeticExpressionData dsArithmExprData, boolean isArray) {
        super(owner, expression, length, addressDspValue, dsArithmExprData, isArray);
    }

    @Override
    ICancelable reguestGet(final IRequestCompletedCallback callback, final DSTask.ICancelState cancelState) {
        try {
            final IDspValue dspValue = this.owner.ma.createDspValue(this.dspValueType, 0L);
            final ValueExtractor extractor = new ValueExtractor(this){

                @Override
                Number extract(IDspValue dspValue) {
                    if (GlobalArithmeticData.isFloatType(dspValueType)) {
                        return new Double(dspValue.toDouble());
                    }
                    return new Long(dspValue.toLong());
                }
            };
            final MutableInt totalLen = new MutableInt(this.length * this.dspValueSize);
            final MutableInt chunkLen = new MutableInt(totalLen.value);
            if (chunkLen.value > 32752) {
                chunkLen.value = 32752;
            }
            final ArrayList ret = new ArrayList();
            final Mutable<IDspValue> currentDspValue = new Mutable<IDspValue>(this.addressDspValue.plusLong(0));
            final IDspMemory mem = this.owner.ma.createDspMemory((IDspValue)currentDspValue.value, chunkLen.value, this.memPage);
            if (ProgramModelPlugin.DEBUG && DSTask.isExressionLogged(this.expression)) {
                ProgramModelPlugin.debug("DS.requestMemoryRead(" + this.expression + ")", IDebugFilter.DS_READ);
            }
            final Mutable onMemoryCompleted = new Mutable();
            final Mutable cw = new Mutable();
            onMemoryCompleted.value = new IObjectEventListener<IMemoryAccessEventData>(){

                public void onEvent(IMemoryAccessEventData arg0) {
                    if (ProgramModelPlugin.DEBUG && DSTask.isExressionLogged(GlobalArithmeticData.this.expression)) {
                        ProgramModelPlugin.debug("DS.IMemoryAccessEvent.onEvent()", IDebugFilter.DS_READ);
                    }
                    try {
                        if (cancelState.isCanceled()) {
                            callback.done(null, null);
                            return;
                        }
                        int i = 0;
                        while (i < chunkLen.value) {
                            int errorCode = mem.getDspValue(dspValue, i);
                            if (errorCode != 0) {
                                callback.done(null, AbstractStatus.createErrorStatus((String)("Read request failed: error code = " + errorCode)));
                                return;
                            }
                            Number val = extractor.extract(dspValue);
                            ret.add(val);
                            i += GlobalArithmeticData.this.dspValueSize;
                        }
                        int currentIncrement = chunkLen.value;
                        totalLen.value -= chunkLen.value;
                        chunkLen.value = totalLen.value;
                        if (chunkLen.value > 32752) {
                            chunkLen.value = 32752;
                        }
                        if (totalLen.value != 0) {
                            currentDspValue.value = ((IDspValue)currentDspValue.value).plusLong(currentIncrement);
                            mem.changeStartAddress((IDspValue)currentDspValue.value);
                            mem.setLength(chunkLen.value);
                            com.ti.debug.engine.ICancelable dsCacelable = GlobalArithmeticData.this.owner.ma.requestMemoryRead(mem, (IObjectEventListener)onMemoryCompleted.value);
                            ((DSCancellabeWrapper)cw.value).replaceTop(dsCacelable);
                            return;
                        }
                        if (ProgramModelPlugin.DEBUG) {
                            ProgramModelPlugin.debug("requestGet completed(" + GlobalArithmeticData.this.expression + ")=" + ret, IDebugFilter.DS_READ);
                        }
                        if (ret.size() == 1 && !GlobalArithmeticData.this.isArray) {
                            callback.done(ret.get(0), null);
                        } else if (GlobalArithmeticData.isFloatType(GlobalArithmeticData.this.dspValueType)) {
                            Double[] retArray = new Double[ret.size()];
                            int i2 = 0;
                            while (i2 < retArray.length) {
                                retArray[i2] = (Double)ret.get(i2);
                                ++i2;
                            }
                            callback.done(retArray, null);
                        } else {
                            Long[] retArray = new Long[ret.size()];
                            int i3 = 0;
                            while (i3 < retArray.length) {
                                retArray[i3] = (Long)ret.get(i3);
                                ++i3;
                            }
                            callback.done(retArray, null);
                        }
                    }
                    catch (XPCOMException e) {
                        callback.done(null, AbstractStatus.createErrorStatus((String)e.getMessage()));
                        return;
                    }
                }
            };
            com.ti.debug.engine.ICancelable dsCacelable = this.owner.ma.requestMemoryRead(mem, (IObjectEventListener)onMemoryCompleted.value);
            cw.value = new DSCancellabeWrapper(this.expression, dsCacelable);
            return (ICancelable)cw.value;
        }
        catch (XPCOMException e) {
            callback.done(null, AbstractStatus.createErrorStatus((String)e.getMessage()));
            return null;
        }
    }

    @Override
    ICancelable reguestSet(final Object value, final IRequestCompletedCallback callback, DSTask.ICancelState cancelState) {
        Collection collection;
        Object obj;
        boolean typesMatched = false;
        Long[] longData = null;
        Double[] doubleData = null;
        if (GlobalArithmeticData.isFloatType(this.dspValueType)) {
            Collection collection2;
            if (this.length == 1) {
                if (value instanceof Long) {
                    typesMatched = true;
                    long longValue = (Long)value;
                    double doubleValue = longValue;
                    doubleData = new Double[]{doubleValue};
                } else if (value instanceof Double) {
                    typesMatched = true;
                    doubleData = new Double[]{(Double)value};
                }
            } else if (value instanceof Double[]) {
                Double[] doubleArray = (Double[])value;
                if (doubleArray.length == this.length) {
                    typesMatched = true;
                    doubleData = doubleArray;
                }
            } else if (value instanceof Long[]) {
                Long[] longArray = (Long[])value;
                if (longArray.length == this.length) {
                    typesMatched = true;
                    doubleData = new Double[this.length];
                    int i = 0;
                    while (i < this.length) {
                        doubleData[i] = new Double(longArray[i].longValue());
                        ++i;
                    }
                }
            } else if (value instanceof Collection && (collection2 = (Collection)value).size() == this.length) {
                typesMatched = true;
                Iterator i = collection2.iterator();
                doubleData = new Double[collection2.size()];
                int j = 0;
                while (i.hasNext()) {
                    obj = i.next();
                    doubleData[j] = obj instanceof Double ? (Double)obj : (obj instanceof Long ? new Double(((Long)obj).longValue()) : Double.valueOf(0.0));
                    ++j;
                }
            }
        } else if (this.length == 1) {
            if (value instanceof Long) {
                typesMatched = true;
                longData = new Long[]{(Long)value};
            } else if (value instanceof Double) {
                typesMatched = true;
                double doubleValue = (Double)value;
                long longValue = (long)doubleValue;
                longData = new Long[]{longValue};
            }
        } else if (value instanceof Double[]) {
            Double[] doubleArray = (Double[])value;
            if (doubleArray.length == this.length) {
                typesMatched = true;
                longData = new Long[this.length];
                int i = 0;
                while (i < this.length) {
                    long longValue = doubleArray[i].longValue();
                    longData[i] = new Long(longValue);
                    ++i;
                }
            }
        } else if (value instanceof Long[]) {
            Long[] longArray = (Long[])value;
            if (longArray.length == this.length) {
                typesMatched = true;
                longData = longArray;
            }
        } else if (value instanceof Collection && (collection = (Collection)value).size() == this.length) {
            typesMatched = true;
            Iterator i = collection.iterator();
            longData = new Long[collection.size()];
            int j = 0;
            while (i.hasNext()) {
                obj = i.next();
                longData[j] = obj instanceof Long ? (Long)obj : (obj instanceof Double ? new Long(((Double)obj).longValue()) : new Long(0L));
                ++j;
            }
        }
        if (!typesMatched) {
            callback.done(null, AbstractStatus.createErrorStatus((String)"Type mismatched."));
            return null;
        }
        try {
            int i;
            IDspValue dspValue = this.owner.ma.createDspValue(this.dspValueType, 0L);
            IDspMemory mem = this.owner.ma.createDspMemory(this.addressDspValue, this.dspValueSize * this.length, this.memPage);
            if (GlobalArithmeticData.isFloatType(this.dspValueType)) {
                i = 0;
                while (i < this.length) {
                    dspValue.assignDouble(doubleData[i].doubleValue());
                    mem.setDspValue(dspValue, i * this.dspValueSize);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.length) {
                    dspValue.assignLongLong(longData[i].longValue());
                    mem.setDspValue(dspValue, i * this.dspValueSize);
                    ++i;
                }
            }
            com.ti.debug.engine.ICancelable dsCancelable = this.owner.ma.requestMemoryWrite(mem, (IObjectEventListener)new IObjectEventListener<IMemoryAccessEventData>(){

                public void onEvent(IMemoryAccessEventData data) {
                    IStatus status;
                    int errorCode = data.getMemory().getErrorCode(0);
                    IStatus iStatus = status = errorCode == 0 ? null : AbstractStatus.createErrorStatus((String)("Write failed. error code =" + errorCode));
                    if (ProgramModelPlugin.DEBUG) {
                        ProgramModelPlugin.debug("requestSet completed(" + GlobalArithmeticData.this.expression + ") value = " + value + " success = " + status, IDebugFilter.DS_WRITE);
                    }
                    callback.done(null, status);
                }
            });
            return new DSCancellabeWrapper(this.expression, dsCancelable);
        }
        catch (XPCOMException e) {
            callback.done(null, AbstractStatus.createErrorStatus((String)e.getMessage()));
            return null;
        }
    }

    static boolean isFloatType(IDspValue.Type dspType) {
        return dspType == IDspValue.Type.FLOAT || dspType == IDspValue.Type.IEEE_FLOAT || dspType == IDspValue.Type.DOUBLE || dspType == IDspValue.Type.IEEE_DOUBLE || dspType == IDspValue.Type.LDOUBLE;
    }

    class Mutable<T> {
        T value;

        Mutable() {
            this.value = null;
        }

        Mutable(T value) {
            this.value = value;
        }
    }

    class MutableInt {
        int value;

        MutableInt(int value) {
            this.value = value;
        }
    }

    abstract class ValueExtractor {
        ValueExtractor() {
        }

        abstract Number extract(IDspValue var1);
    }
}

