/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.IStatus;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelPlugin;
import com.ti.binding.program.internal.ds.BaseExpressionData;
import com.ti.binding.program.internal.ds.DSArithmeticExpressionData;
import com.ti.binding.program.internal.ds.DSCancellabeWrapper;
import com.ti.binding.program.internal.ds.DSExpressionData;
import com.ti.binding.program.internal.ds.DSTask;
import com.ti.binding.program.internal.ds.ExpressionException;
import com.ti.binding.program.internal.ds.GlobalArithmeticData;
import com.ti.binding.program.internal.ds.GlobalExpressionData;
import com.ti.binding.program.internal.ds.GlobalStringData;
import com.ti.binding.program.internal.ds.InvalidExpressionData;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.types.IObjectEventListener;

public class GlobalArrayArrayArithmeticData
extends BaseExpressionData {
    int numRows;
    DSCancellabeWrapper dsCW;
    DSTask.CancelCoordinator cc;
    IRequestCompletedCallback callback;
    RowInfo[] rowInfo;
    InvalidExpressionData error;

    GlobalArrayArrayArithmeticData(final DSTask owner, String expression, DSExpressionData rootData, final IRequestCompletedCallback callback, final DSTask.CancelCoordinator cc) {
        super(owner, expression);
        this.numRows = rootData.numElements;
        this.dsCW = new DSCancellabeWrapper(expression);
        this.rowInfo = new RowInfo[this.numRows];
        int i = 0;
        while (i < this.numRows) {
            final int currentIndex = i;
            final String eachRowExpression = "(" + expression + ")[" + i + "]";
            this.rowInfo[i] = new RowInfo();
            this.rowInfo[i].index = i;
            if (ProgramModelPlugin.DEBUG) {
                ProgramModelPlugin.debug("requestrEvaluation(" + eachRowExpression + ")", IDebugFilter.DS_ADD_EXPRESSION);
            }
            com.ti.debug.engine.ICancelable dsCancelable = owner.eval.requestEvaluation(eachRowExpression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                public void onEvent(IExpressionEvaluationData dataRow) {
                    if (cc.isCanceled()) {
                        callback.done(null, null);
                        return;
                    }
                    try {
                        final DSExpressionData dsRowData = new DSExpressionData(dataRow, true, false);
                        if (dsRowData.isChar) {
                            DSArithmeticExpressionData dsArithmeticData = new DSArithmeticExpressionData(dataRow, dsRowData.rawMemoryRange, dsRowData.addressDspValue);
                            GlobalArrayArrayArithmeticData.this.rowInfo[currentIndex].data = new GlobalStringData(owner, eachRowExpression, dsRowData.numElements, dsRowData.addressDspValue, dsArithmeticData, dsRowData.isArrayType);
                            boolean allInit = true;
                            RowInfo[] rowInfoArray = GlobalArrayArrayArithmeticData.this.rowInfo;
                            int n = GlobalArrayArrayArithmeticData.this.rowInfo.length;
                            int n2 = 0;
                            while (n2 < n) {
                                RowInfo ri = rowInfoArray[n2];
                                if (ri.data == null) {
                                    allInit = false;
                                    break;
                                }
                                ++n2;
                            }
                            if (allInit) {
                                callback.done(GlobalArrayArrayArithmeticData.this, null);
                            }
                        } else if (dsRowData.isArrayType) {
                            GlobalArrayArrayArithmeticData.this.rowInfo[currentIndex].size = dsRowData.numElements;
                            final String firstElementExpression = String.valueOf(eachRowExpression) + "[0]";
                            if (ProgramModelPlugin.DEBUG) {
                                ProgramModelPlugin.debug("requestrEvaluation(" + firstElementExpression + ")", IDebugFilter.DS_ADD_EXPRESSION);
                            }
                            com.ti.debug.engine.ICancelable dsCancelable2 = owner.eval.requestEvaluation(firstElementExpression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                                public void onEvent(IExpressionEvaluationData dataElement) {
                                    if (cc.isCanceled()) {
                                        callback.done(null, null);
                                        return;
                                    }
                                    try {
                                        DSExpressionData dsArrayData = new DSExpressionData(dataElement, false, false);
                                        if (dsArrayData.isArithmeticType) {
                                            (this).GlobalArrayArrayArithmeticData.this.rowInfo[currentIndex].size = dsArrayData.numElements;
                                            DSArithmeticExpressionData dsElementArithmData = new DSArithmeticExpressionData(dataElement, dsRowData.rawMemoryRange, dsRowData.addressDspValue);
                                            (this).GlobalArrayArrayArithmeticData.this.rowInfo[currentIndex].data = new GlobalArithmeticData(owner, firstElementExpression, dsRowData.numElements, dsRowData.addressDspValue, dsElementArithmData, true);
                                        }
                                        boolean allInit = true;
                                        RowInfo[] rowInfoArray = (this).GlobalArrayArrayArithmeticData.this.rowInfo;
                                        int n = (this).GlobalArrayArrayArithmeticData.this.rowInfo.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            RowInfo ri = rowInfoArray[n2];
                                            if (ri.data == null) {
                                                allInit = false;
                                                break;
                                            }
                                            ++n2;
                                        }
                                        if (allInit) {
                                            callback.done(GlobalArrayArrayArithmeticData.this, null);
                                        }
                                    }
                                    catch (ExpressionException e) {
                                        (this).GlobalArrayArrayArithmeticData.this.error = new InvalidExpressionData(owner, firstElementExpression, e.getMessage());
                                    }
                                }
                            });
                            GlobalArrayArrayArithmeticData.this.dsCW.addDSCancelable(dsCancelable2);
                        }
                    }
                    catch (ExpressionException e) {
                        GlobalArrayArrayArithmeticData.this.error = new InvalidExpressionData(owner, eachRowExpression, e.getMessage());
                    }
                }
            });
            this.dsCW.addDSCancelable(dsCancelable);
            ++i;
        }
    }

    @Override
    ICancelable reguestGet(final IRequestCompletedCallback callback, DSTask.ICancelState cancelState) {
        if (this.error != null) {
            return this.error.reguestGet(callback, cancelState);
        }
        if (this.rowInfo != null) {
            final boolean[] allDone = new boolean[this.rowInfo.length];
            final Object[] rowData = new Object[this.rowInfo.length];
            RowInfo[] rowInfoArray = this.rowInfo;
            int n = this.rowInfo.length;
            int n2 = 0;
            while (n2 < n) {
                final RowInfo ri = rowInfoArray[n2];
                ri.data.reguestGet(new IRequestCompletedCallback(){

                    @Override
                    public void done(Object retValue, IStatus status) {
                        allDone[ri.index] = true;
                        rowData[ri.index] = retValue;
                        boolean[] blArray = allDone;
                        int n = allDone.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean b = blArray[n2];
                            if (!b) {
                                return;
                            }
                            ++n2;
                        }
                        callback.done(rowData, null);
                    }
                }, cancelState);
                ++n2;
            }
        }
        return null;
    }

    @Override
    ICancelable reguestSet(Object value, IRequestCompletedCallback callback, DSTask.ICancelState cancelState) {
        if (this.error != null) {
            return this.error.reguestSet(value, callback, cancelState);
        }
        if (this.rowInfo != null && this.rowInfo[0] != null && this.rowInfo[0].data != null) {
            this.rowInfo[0].data.reguestSet(value, callback, cancelState);
        }
        return null;
    }

    class RowInfo {
        int index;
        int size;
        GlobalExpressionData data;

        RowInfo() {
        }
    }
}

